/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.SequenceBase;

class LazySeq<T>
extends SequenceBase<T>
implements C.Sequence<T> {
    protected T head;
    protected Lang.F0<C.Sequence<T>> tail;

    protected LazySeq() {
    }

    LazySeq(T head, Lang.Func0<? extends C.Sequence<T>> tail) {
        this.head = head;
        this.tail = $.f0(tail);
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.IMMUTABLE, C.Feature.LAZY, C.Feature.READONLY, C.Feature.ORDERED);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T first() {
        return this.head;
    }

    @Override
    public C.Sequence<T> tail() throws UnsupportedOperationException {
        return (C.Sequence)this.tail.apply();
    }

    @Override
    public C.List<T> asList() {
        return C.list(this);
    }

    @Override
    public Iterator<T> iterator() {
        final LazySeq seq = this;
        return new Iterator<T>(){
            private C.Sequence<T> _seq;
            {
                this._seq = seq;
            }

            @Override
            public boolean hasNext() {
                return !this._seq.isEmpty();
            }

            @Override
            public T next() {
                Object head = this._seq.head();
                this._seq = this._seq.tail();
                return head;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String debug() {
        StringBuilder sb = new StringBuilder("[_LS_");
        for (T t : this) {
            sb.append(", ").append(t);
        }
        return sb.append("]").toString();
    }
}

