/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public final class Keyword
implements Comparable<Keyword> {
    public static final char SEP_SPACE = ' ';
    public static final char SEP_UNDERSCORE = '_';
    public static final char SEP_DASH = '-';
    public static final char SEP_COMMA = ',';
    public static final char SEP_COLON = ':';
    public static final char SEP_DOT = '.';
    public static final char SEP_SEMI_COLON = ';';
    public static final char SEP_SLASH = '\\';
    public static final char SEP_FORWARD_SLASH = '/';
    private static final char[] SEPS = new char[]{' ', '_', '-', ',', ':', '.', ';', '/', '\\'};
    private C.List<FastStr> list = C.newList();

    public Keyword(CharSequence chars) {
        this.init(chars);
    }

    public String camelCase() {
        return Style.CAMEL_CASE.toString(this);
    }

    public String javaVariable() {
        return Style.JAVA_VARIABLE.toString(this);
    }

    public String constantName() {
        return Style.CONSTANT_NAME.toString(this);
    }

    public String underscore() {
        return Style.UNDERSCORE.toString(this);
    }

    public String dashed() {
        return Style.DASHED.toString(this);
    }

    public String hyphenated() {
        return this.dashed();
    }

    public String dotted() {
        return Style.DOTTED.toString(this);
    }

    public String httpHeader() {
        return Style.HTTP_HEADER.toString(this);
    }

    public String readable() {
        return Style.READABLE.toString(this);
    }

    public List<String> tokens() {
        ArrayList<String> list = new ArrayList<String>();
        for (FastStr fs : this.list) {
            list.add(fs.toString());
        }
        return list;
    }

    public int hashCode() {
        return $.hc(this.list);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Keyword) {
            return ((Keyword)obj).list.equals(this.list);
        }
        return false;
    }

    public String toString() {
        return this.underscore();
    }

    public String toString(Style style) {
        return style.toString(this);
    }

    @Override
    public int compareTo(Keyword o) {
        return this.camelCase().compareTo(o.camelCase());
    }

    public static Keyword of(CharSequence chars) {
        return new Keyword(chars);
    }

    public static boolean eq(CharSequence a, CharSequence b) {
        return Keyword.of(a).equals(Keyword.of(b));
    }

    public static boolean neq(CharSequence a, CharSequence b) {
        return !Keyword.eq(a, b);
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        return Keyword.eq(a, b);
    }

    public static boolean notEquals(CharSequence a, CharSequence b) {
        return !Keyword.eq(a, b);
    }

    private void init(CharSequence chars) {
        FastStr fs = FastStr.of(chars);
        int sz = fs.length();
        int last = Keyword.nextNonSeparator(fs, 0);
        while (true) {
            FastStr sub;
            int pos;
            if ((pos = Keyword.locateNextStop(fs, last)) < 0 || pos == sz) {
                sub = (FastStr)fs.substr(last);
                if (sub.isEmpty()) break;
                this.list.add(sub.toLowerCase());
                break;
            }
            sub = fs.subSequence(last, pos);
            if (sub.length() == 1 && Keyword.isUpperCase(sub.charAt(0))) {
                pos = Keyword.nextNonUpperCase(fs, pos);
                sub = fs.subSequence(last, pos);
            }
            if (!sub.isEmpty()) {
                this.list.add(sub.toLowerCase());
            }
            last = Keyword.nextNonSeparator(fs, pos);
        }
    }

    private static int locateNextStop(FastStr str, int start) {
        char ch;
        int pos;
        int sz = str.length();
        if (start >= sz - 1) {
            return -1;
        }
        for (pos = start + 1; pos < sz && !Keyword.isSeparator(ch = str.charAt(pos)) && !Keyword.isUpperCase(ch); ++pos) {
        }
        return pos;
    }

    private static int nextNonSeparator(FastStr str, int start) {
        char ch;
        int pos;
        int sz = str.length();
        for (pos = start; pos < sz && Keyword.isSeparator(ch = str.charAt(pos)); ++pos) {
        }
        return pos;
    }

    private static int nextNonUpperCase(FastStr str, int start) {
        char ch;
        int pos;
        int sz = str.size();
        for (pos = start; pos < sz && Keyword.isUpperCase(ch = str.charAt(pos)); ++pos) {
        }
        return pos;
    }

    private static boolean isSeparator(char ch) {
        return Arrays.binarySearch(SEPS, ch) >= 0;
    }

    private static boolean isUpperCase(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    static {
        Arrays.sort(SEPS);
    }

    public static enum Style {
        CAMEL_CASE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.capFirst();
            }
        }
        ,
        JAVA_VARIABLE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return seq > 0 ? token.capFirst() : token;
            }
        }
        ,
        UNDERSCORE('_'),
        CONSTANT_NAME('_'){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.toUpperCase();
            }
        }
        ,
        DASHED('-'),
        DOTTED('.'),
        HTTP_HEADER('-'){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.capFirst();
            }
        }
        ,
        READABLE(' '){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                if (seq == 0) {
                    return token.capFirst();
                }
                return token;
            }
        };

        private String separator;

        private Style() {
            this.separator = null;
        }

        private Style(char sep) {
            this.separator = String.valueOf(sep);
        }

        public String toString(Keyword keyword) {
            S.Buffer sb = S.buffer();
            int sz = keyword.list.size();
            for (int i = 0; i < sz; ++i) {
                FastStr fs = (FastStr)keyword.list.get(i);
                sb.append(this.processToken(fs, i));
                if (i >= sz - 1 || null == this.separator) continue;
                sb.append(this.separator);
            }
            return sb.toString();
        }

        protected CharSequence processToken(FastStr token, int seq) {
            return token;
        }
    }
}

