/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Collection;
import java.util.Iterator;
import org.osgl.util.C;
import org.osgl.util.DelegatingIterator;
import org.osgl.util.E;
import org.osgl.util.TraversableBase;

class IterableTrav<T>
extends TraversableBase<T> {
    private final Iterable<? extends T> data;

    IterableTrav(Iterable<? extends T> iterable) {
        E.NPE(iterable);
        this.data = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return DelegatingIterator.of(this.data.iterator(), this.is(C.Feature.READONLY));
    }

    @Override
    public int size() throws UnsupportedOperationException {
        if (this.data instanceof Collection) {
            return ((Collection)this.data).size();
        }
        throw new UnsupportedOperationException();
    }

    public static <T> C.Traversable<T> of(Iterable<? extends T> iterable) {
        if (iterable instanceof C.Traversable) {
            return (C.Traversable)iterable;
        }
        return new IterableTrav<T>(iterable);
    }
}

