/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.StatefulIterator;

class FlatMappedIterator<T, R>
extends StatefulIterator<R> {
    private final Iterator<? extends T> data;
    private final Lang.Function<? super T, ? extends Iterable<? extends R>> mapper;
    private Iterator<? extends R> curMapped = null;

    FlatMappedIterator(Iterator<? extends T> itr, Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        E.NPE(itr, mapper);
        this.data = itr;
        this.mapper = mapper;
    }

    protected Iterator<? extends T> data() {
        return this.data;
    }

    protected Lang.Function<? super T, ? extends Iterable<? extends R>> mapper() {
        return this.mapper;
    }

    @Override
    protected Lang.Option<R> getCurrent() {
        while (null == this.curMapped || !this.curMapped.hasNext()) {
            if (!this.data.hasNext()) {
                return $.none();
            }
            this.curMapped = this.mapper.apply(this.data.next()).iterator();
        }
        return $.some(this.curMapped.next());
    }
}

