/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.StatefulIterator;

class FilteredIterator<T>
extends StatefulIterator<T> {
    private final Iterator<? extends T> itr_;
    private final Lang.Predicate<T> filter_;
    private final Type type_;
    private boolean start_;

    FilteredIterator(Iterator<? extends T> iterator, Lang.Function<? super T, Boolean> filter) {
        this(iterator, filter, Type.ALL);
    }

    FilteredIterator(Iterator<? extends T> iterator, Lang.Function<? super T, Boolean> filter, Type type) {
        E.NPE(iterator, filter);
        this.itr_ = iterator;
        this.filter_ = $.predicate(filter);
        this.type_ = type;
    }

    protected Iterator<? extends T> data() {
        return this.itr_;
    }

    @Override
    protected Lang.Option<T> getCurrent() {
        block5: while (this.itr_.hasNext()) {
            T t = this.itr_.next();
            switch (this.type_) {
                case ALL: {
                    boolean ok = this.filter_.test(t);
                    if (!ok) continue block5;
                    return $.some(t);
                }
                case WHILE: {
                    boolean ok = this.filter_.test(t);
                    if (ok) {
                        return $.some(t);
                    }
                    return $.none();
                }
                case UNTIL: {
                    if (this.start_) {
                        return $.some(t);
                    }
                    boolean ok = this.filter_.test(t);
                    if (!ok) continue block5;
                    this.start_ = true;
                    return $.some(t);
                }
            }
        }
        return $.none();
    }

    static enum Type {
        ALL,
        WHILE,
        UNTIL;


        <T> Iterator<T> filter(Iterator<T> raw, Lang.Function<? super T, Boolean> predicate) {
            return new FilteredIterator<T>(raw, predicate, this);
        }
    }
}

