/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.ReadOnlyException;
import org.osgl.util.DelegatingList;
import org.osgl.util.DelegatingSet;
import org.osgl.util.E;
import org.osgl.util.EnumerationIterator;
import org.osgl.util.FilteredSeq;
import org.osgl.util.ImmutableList;
import org.osgl.util.ImmutableSet;
import org.osgl.util.IterableSeq;
import org.osgl.util.IteratorSeq;
import org.osgl.util.LazyRange;
import org.osgl.util.ListBuilder;
import org.osgl.util.MappedSeq;
import org.osgl.util.N;
import org.osgl.util.Nil;
import org.osgl.util.ReadOnlyDelegatingList;
import org.osgl.util.ReadOnlyIterator;
import org.osgl.util.ReversedRSeq;
import org.osgl.util.ReversibleMappedSeq;
import org.osgl.util.ReversibleSeqBase;
import org.osgl.util.S;
import org.osgl.util.algo.Algorithms;

public class C {
    public static final String CONF_LINKED_LIST_FACTORY = "osgl.linked_list.factory";
    public static final String CONF_RANDOM_ACCESS_LIST_FACTORY = "osgl.random_access_list.factory";
    static ListFactory linkedListFact;
    static ListFactory randomAccessListFact;
    public static final List EMPTY_LIST;
    public static final Set EMPTY_SET;
    public static final Map EMPTY_MAP;
    public static final ListOrSet EMPTY;

    C() {
    }

    public static boolean empty(Collection<?> col) {
        return null == col || col.isEmpty();
    }

    public static boolean notEmpty(Collection<?> col) {
        return !C.empty(col);
    }

    public static boolean isEmpty(Collection<?> col) {
        return C.empty(col);
    }

    public static boolean empty(java.util.Map map) {
        return null == map || map.isEmpty();
    }

    public static boolean notEmpty(java.util.Map map) {
        return !C.empty(map);
    }

    public static boolean isEmpty(java.util.Map map) {
        return C.empty(map);
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)$.cast(iterable);
        }
        return C.list(iterable);
    }

    public static Range<Integer> range(int from, int to) {
        return new LazyRange<Integer>(from, to, N.F.INT_RANGE_STEP);
    }

    public static Range<Byte> range(byte from, byte to) {
        return new LazyRange<Byte>(from, to, N.F.BYTE_RANGE_STEP);
    }

    public static Range<Short> range(short from, short to) {
        return new LazyRange<Short>(from, to, N.F.SHORT_RANGE_STEP);
    }

    public static Range<Long> range(long from, long to) {
        return new LazyRange<Long>(from, to, N.F.LONG_RANGE_STEP);
    }

    public static Range<Integer> naturalNumbers() {
        return new LazyRange<Integer>(1, Integer.MAX_VALUE, N.F.INT_RANGE_STEP);
    }

    public static Range<Integer> evenNumbers() {
        return new LazyRange<Integer>(0, Integer.MAX_VALUE, N.F.intRangeStep(2));
    }

    public static Range<Integer> oddNumbers() {
        return new LazyRange<Integer>(1, Integer.MAX_VALUE, N.F.intRangeStep(2));
    }

    public static <T> ListOrSet<T> empty() {
        return EMPTY;
    }

    public static <T> List<T> list() {
        return Nil.list();
    }

    public static <T> List<T> emptyListOf(Class<T> c) {
        return Nil.list();
    }

    public static <T> List<T> list(T t) {
        return $.val(t);
    }

    public static <T> List<T> listOf(T ... ta) {
        return ImmutableList.of(ta);
    }

    public static <T> List<T> list(T t, T ... ta) {
        int len = ta.length;
        T[] a = $.newArray(ta, len + 1);
        a[0] = t;
        System.arraycopy(ta, 0, a, 1, len);
        return ImmutableList.of(a);
    }

    public static List<Boolean> listOf(boolean[] elements) {
        return C.list(elements);
    }

    public static List<Boolean> list(boolean[] elements) {
        if (elements.length == 0) {
            return Nil.list();
        }
        Boolean[] ba = $.asObject(elements);
        return ImmutableList.of(ba);
    }

    public static List<Byte> listOf(byte[] elements) {
        return C.list(elements);
    }

    public static List<Byte> list(byte[] elements) {
        if (elements.length == 0) {
            return Nil.list();
        }
        Byte[] ba = $.asObject(elements);
        return ImmutableList.of(ba);
    }

    public static List<Character> listOf(char[] elements) {
        return C.list(elements);
    }

    public static List<Character> list(char[] elements) {
        if (0 == elements.length) {
            return Nil.list();
        }
        Character[] a = $.asObject(elements);
        return ImmutableList.of(a);
    }

    public static List<Short> listOf(short[] elements) {
        return C.list(elements);
    }

    public static List<Short> list(short[] elements) {
        if (0 == elements.length) {
            return Nil.list();
        }
        Short[] a = $.asObject(elements);
        return ImmutableList.of(a);
    }

    public static List<Integer> listOf(int[] elements) {
        return C.list(elements);
    }

    public static List<Integer> list(int[] elements) {
        if (elements.length == 0) {
            return Nil.list();
        }
        Integer[] a = $.asObject(elements);
        return ImmutableList.of(a);
    }

    public static List<Long> listOf(long[] elements) {
        return C.list(elements);
    }

    public static List<Long> list(long[] elements) {
        if (0 == elements.length) {
            return C.list();
        }
        return ImmutableList.of($.asObject(elements));
    }

    public static List<Float> listOf(float[] elements) {
        return C.list(elements);
    }

    public static List<Float> list(float[] elements) {
        if (0 == elements.length) {
            return C.list();
        }
        return ImmutableList.of($.asObject(elements));
    }

    public static List<Double> listOf(double[] elements) {
        return C.list(elements);
    }

    public static List<Double> list(double[] elements) {
        if (0 == elements.length) {
            return C.list();
        }
        return ImmutableList.of($.asObject(elements));
    }

    public static <T> List<T> list(Iterable<? extends T> iterable) {
        return ListBuilder.toList(iterable);
    }

    public static <T> List<T> list(Iterator<? extends T> iterator) {
        return ListBuilder.toList(iterator);
    }

    public static <T> List<T> list(Enumeration<? extends T> enumeration) {
        return ListBuilder.toList(enumeration);
    }

    public static <T> List<T> list(Collection<? extends T> col) {
        return ListBuilder.toList(col);
    }

    public static <T> List<T> list(java.util.List<? extends T> javaList) {
        if (javaList instanceof List) {
            List list = (List)$.cast(javaList);
            if (list.is(Feature.IMMUTABLE)) {
                return list;
            }
            return new ReadOnlyDelegatingList(list);
        }
        return new ReadOnlyDelegatingList<T>(javaList);
    }

    public static <T> List<T> singletonList(T t) {
        return C.list(t);
    }

    public static <T> List<T> wrap(java.util.List<T> list) {
        return DelegatingList.wrap(list);
    }

    public static <T> List<T> newSizedList(int size) {
        return new DelegatingList(size);
    }

    public static <T> List<T> newList() {
        return C.newSizedList(10);
    }

    public static <T> List<T> newList(Iterable<? extends T> iterable) {
        return new DelegatingList<T>(iterable);
    }

    public static <T> List<T> newList(T t) {
        return new DelegatingList(10).append((Object)t);
    }

    public static <T> List<T> newList(T t1, T t2) {
        return new DelegatingList(10).append((Object)t1).append(t2);
    }

    public static <T> List<T> newList(T t1, T t2, T t3) {
        return new DelegatingList(10).append((Object)t1).append(t2).append(t3);
    }

    public static <T> List<T> newList(T t1, T t2, T t3, T ... ta) {
        int len = ta.length;
        List<T> l = new DelegatingList(len + 3).append((Object)t1).append(t2).append(t3);
        l.addAll(C.listOf(ta));
        return l;
    }

    public static <T> List<T> newListOf(T[] ts) {
        return new DelegatingList<T>(C.listOf(ts));
    }

    public static <T> Sequence<T> seq(Iterable<? extends T> iterable) {
        if (iterable instanceof Sequence) {
            return (Sequence)iterable;
        }
        return IterableSeq.of(iterable);
    }

    public static <T> Sequence<T> seq(Iterator<? extends T> iterator) {
        return IteratorSeq.of(iterator);
    }

    public static <T> Sequence<T> seq(Enumeration<? extends T> enumeration) {
        return IteratorSeq.of(new EnumerationIterator<T>(enumeration));
    }

    public static <PROPERTY> List<PROPERTY> extract(Collection<?> collection, final String propertyPath) {
        if (collection.isEmpty()) {
            return C.list();
        }
        Lang.Transformer extractor = new Lang.Transformer<Object, PROPERTY>(){

            @Override
            public PROPERTY transform(Object element) {
                return $.getProperty(element, propertyPath);
            }
        };
        return C.list(collection).map(extractor);
    }

    public static <PROPERTY> Sequence<PROPERTY> lazyExtract(Iterable<?> iterable, final String propertyPath) {
        Lang.Transformer extractor = new Lang.Transformer<Object, PROPERTY>(){

            @Override
            public PROPERTY transform(Object element) {
                return $.getProperty(element, propertyPath);
            }
        };
        return C.map(iterable, extractor);
    }

    public static <T, R> Sequence<R> map(Iterable<? extends T> seq, Lang.Function<? super T, ? extends R> mapper) {
        if (null == seq) {
            return C.list();
        }
        if (seq instanceof ReversibleSequence) {
            ReversibleSequence rseq = (ReversibleSequence)$.cast(seq);
            return C.map(rseq, mapper);
        }
        return new MappedSeq<T, R>(seq, mapper);
    }

    public static <T, R> ReversibleSequence<R> map(ReversibleSequence<? extends T> seq, Lang.Function<? super T, ? extends R> mapper) {
        if (null == seq) {
            return C.list();
        }
        return new ReversibleMappedSeq<T, R>(seq, mapper);
    }

    public static <T> Sequence<T> filter(Iterable<? extends T> iterable, Lang.Function<? super T, Boolean> predicate) {
        return new FilteredSeq<T>(iterable, predicate);
    }

    public static <T> Sequence<T> prepend(T t, Sequence<T> sequence) {
        if (sequence instanceof ReversibleSequence) {
            return C.prepend(t, (ReversibleSequence)sequence);
        }
        return C.concat(C.list(t), sequence);
    }

    public static <T> Sequence<T> concat(Sequence<T> s1, Sequence<T> s2) {
        return s1.append(s2);
    }

    public static <T> ReversibleSequence<T> concat(ReversibleSequence<T> s1, ReversibleSequence<T> s2) {
        return s1.append(s2);
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        return l1.append(l2);
    }

    @Deprecated
    public static <T> Set<T> set() {
        return Nil.set();
    }

    public static <T> Set<T> Set() {
        return Nil.set();
    }

    public static <T> Set<T> set(T element) {
        HashSet<T> set = new HashSet<T>();
        set.add(element);
        return ImmutableSet.of(set);
    }

    public static <T> Set<T> set(T t1, T ... ta) {
        HashSet<T> set = new HashSet<T>();
        set.add(t1);
        Collections.addAll(set, ta);
        return ImmutableSet.of(set);
    }

    public static <T> Set<T> setOf(T ... ta) {
        HashSet set = new HashSet();
        Collections.addAll(set, ta);
        return ImmutableSet.of(set);
    }

    @Deprecated
    public static <T> Set<T> set(Collection<? extends T> col) {
        return ImmutableSet.of(col);
    }

    public static <T> Set<T> Set(Collection<? extends T> col) {
        return ImmutableSet.of(col);
    }

    public static <T> Set<T> set(Iterable<? extends T> itr) {
        if (itr instanceof Collection) {
            return C.set((Collection)itr);
        }
        HashSet<T> set = new HashSet<T>();
        for (T t : itr) {
            set.add(t);
        }
        return ImmutableSet.of(set);
    }

    public static <T> Set<T> newSet() {
        return new DelegatingSet();
    }

    public static <T> Set<T> newSet(T t1, T ... ta) {
        DelegatingSet set = new DelegatingSet();
        set.add(t1);
        Collections.addAll(set, ta);
        return set;
    }

    public static <T> Set<T> newSet(Collection<? extends T> col) {
        return new DelegatingSet<T>(col);
    }

    public static <T> Set<T> unionOf(Collection<? extends T> col1, Collection<? extends T> col2) {
        return C.set(col1).with(col2);
    }

    public static <T> Set<T> unionOf(Collection<? extends T> col1, Collection<? extends T> col2, Collection<? extends T> col3, Collection<? extends T> ... otherCols) {
        Set<T> union = C.newSet(col1);
        union.addAll(col2);
        union.addAll(col3);
        for (Collection<? extends T> col : otherCols) {
            union.addAll(col);
        }
        return C.set(union);
    }

    public static <T> Set<T> intercectionOf(Collection<? extends T> col1, Collection<? extends T> col2) {
        return C.set(col1).withIn(col2);
    }

    public static <T> Set<T> interceptionOf(Collection<? extends T> col1, Collection<? extends T> col2, Collection<? extends T> col3, Collection<? extends T> ... otherCols) {
        Set<T> interception = C.newSet(col1);
        interception.retainAll(col2);
        interception.retainAll(col3);
        for (Collection<? extends T> col : otherCols) {
            interception.retainAll(col);
        }
        return C.set(interception);
    }

    public static <K, V> Map<K, V> Map(Object ... args) {
        if (null == args || args.length == 0) {
            return Nil.EMPTY_MAP;
        }
        return new Map(true, args);
    }

    public static <K, V> Map<K, V> Map(boolean readOnly, java.util.Map<K, V> map) {
        return new Map<K, V>(readOnly, map);
    }

    public static <K, V> Map<K, V> Map(Collection<Lang.Tuple<K, V>> kvCol) {
        Map map = C.newMap(new Object[0]);
        for (Lang.Tuple<K, V> entry : kvCol) {
            map.put(entry._1, entry._2);
        }
        return new Map<K, V>(true, map);
    }

    public static <K, V> Map<K, V> Map(java.util.Map<? extends K, ? extends V> map) {
        if (null == map) {
            return Nil.EMPTY_MAP;
        }
        return new Map<K, V>(true, map);
    }

    public static <K, V> Map<K, V> newMap(Object ... args) {
        return new Map(false, args);
    }

    public static <K, V> Map<K, V> newMap(java.util.Map<? extends K, ? extends V> map) {
        return new Map<K, V>(false, map);
    }

    public static <T> Iterable<T> enumerable(final Enumeration<T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw E.unsupport();
                    }
                };
            }
        };
    }

    public static boolean isReadOnly(Traversable<?> t) {
        return t.is(Feature.READONLY) || t.is(Feature.IMMUTABLE);
    }

    public static boolean isImmutable(Traversable<?> t) {
        return t.is(Feature.IMMUTABLE);
    }

    public static <T> void forEach(Iterable<? extends T> iterable, Lang.Visitor<? super T> visitor) throws Lang.Break {
        for (T t : iterable) {
            try {
                visitor.apply((Object)t);
            }
            catch (NotAppliedException notAppliedException) {}
        }
    }

    public static <T> void forEach(Iterator<? extends T> iterator, Lang.Visitor<? super T> visitor) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            visitor.apply((Object)t);
        }
    }

    public static <K, V> void forEach(java.util.Map<K, V> map, Lang.IndexedVisitor<? super K, ? super V> indexedVisitor) throws Lang.Break {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            try {
                indexedVisitor.apply((Object)entry.getKey(), (Object)entry.getValue());
            }
            catch (NotAppliedException notAppliedException) {}
        }
    }

    public static _CollectStage collect(Iterable source) {
        return new _CollectStage(source);
    }

    public static _CollectStage2 collect(String propertyPath) {
        return new _CollectStage2(propertyPath);
    }

    public static <T> List<T> collect(Iterable source, String propertyPath) {
        if (null == source) {
            return C.list();
        }
        int sz = 10;
        if (source instanceof Collection && 0 == (sz = ((Collection)source).size())) {
            return C.list();
        }
        List<T> retList = C.newSizedList(sz);
        for (Object o : source) {
            retList.add($.getProperty(o, propertyPath));
        }
        return retList;
    }

    public static <T> _MapStage<T> map(Iterable<? extends T> source) {
        return new _MapStage<T>(source);
    }

    public static <T, R> _MapStage2 map(Lang.Function<? super T, ? extends R> mapper) {
        return new _MapStage2<T, R>(mapper);
    }

    public static <T> _FilterStage<T> filter(Iterable<? extends T> source) {
        return new _FilterStage<T>(source);
    }

    public static <T> _FilterStage2<T> filter(Lang.Predicate<? super T> predicate) {
        return new _FilterStage2<T>(predicate);
    }

    private static void ensureWritable(boolean ro, String containerName) {
        if (ro) {
            throw new ReadOnlyException(containerName + " is readonly");
        }
    }

    static {
        Lang.Option fact;
        String factCls = System.getProperty(CONF_LINKED_LIST_FACTORY);
        linkedListFact = null == factCls ? ListFactory.Predefined.defLinked() : ((fact = $.safeNewInstance(factCls)).isDefined() ? (ListFactory)fact.get() : ListFactory.Predefined.defLinked());
        factCls = System.getProperty(CONF_RANDOM_ACCESS_LIST_FACTORY);
        randomAccessListFact = null == factCls ? ListFactory.Predefined.defRandomAccess() : ((fact = $.safeNewInstance(factCls)).isDefined() ? (ListFactory)fact.get() : ListFactory.Predefined.defRandomAccess());
        EMPTY_LIST = Nil.list();
        EMPTY_SET = Nil.set();
        EMPTY_MAP = Nil.EMPTY_MAP;
        EMPTY = Nil.EMPTY;
    }

    public static enum F {


        public static <T> Lang.Transformer<Iterable<T>, Collection<T>> asCollection() {
            return new Lang.Transformer<Iterable<T>, Collection<T>>(){

                @Override
                public Collection<T> transform(Iterable<T> iterable) {
                    return C.asCollection(iterable);
                }
            };
        }

        public static <T> Lang.Predicate<T> containsIn(final Collection<? super T> collection) {
            return new Lang.Predicate<T>(){

                @Override
                public boolean test(T t) throws NotAppliedException, Lang.Break {
                    return collection.contains(t);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> contains(final T element) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> collection) {
                    return collection.contains(element);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? extends T>> allContainsIn(final Collection<? super T> collection) {
            return new Lang.Predicate<Collection<? extends T>>(){

                @Override
                public boolean test(Collection<? extends T> theCollection) {
                    return collection.containsAll(theCollection);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> containsAll(final Collection<? extends T> collection) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> theCollection) {
                    return theCollection.contains(collection);
                }
            };
        }

        public static <T> Lang.Predicate<T> addTo(final Collection<? super T> destination) {
            return new Lang.Predicate<T>(){

                @Override
                public boolean test(T t) throws NotAppliedException, Lang.Break {
                    return destination.add(t);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> add(final T element) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> collection) {
                    return collection.add(element);
                }
            };
        }

        public static <L extends List<? super T>, T> Lang.F1<T, L> addTo(final int index, final L destination) {
            return new Lang.F1<T, L>(){

                @Override
                public L apply(T t) throws NotAppliedException, Lang.Break {
                    destination.add(index, t);
                    return destination;
                }
            };
        }

        public static <L extends List<? super T>, T> Lang.F1<L, L> add(final int index, final T element) {
            return new Lang.F1<L, L>(){

                @Override
                public L apply(L list) throws NotAppliedException, Lang.Break {
                    list.add(index, (Object)element);
                    return list;
                }
            };
        }

        public static <T> Lang.Predicate<Iterable<? extends T>> addAllTo(final Collection<? super T> destination) {
            return new Lang.Predicate<Iterable<? extends T>>(){

                @Override
                public boolean test(Iterable<? extends T> source) throws NotAppliedException, Lang.Break {
                    if (source instanceof Collection) {
                        return destination.addAll((Collection)source);
                    }
                    return destination.addAll(C.list(source));
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> addAll(final Collection<? extends T> source) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> destination) {
                    return destination.addAll(source);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? extends T>> addAllTo(final int index, final List<? super T> destination) {
            if (0 > index || destination.size() < index) {
                throw new IndexOutOfBoundsException();
            }
            return new Lang.Predicate<Collection<? extends T>>(){

                @Override
                public boolean test(Collection<? extends T> collection) throws NotAppliedException, Lang.Break {
                    return destination.addAll(index, collection);
                }
            };
        }

        public static <T> Lang.Predicate<List<? super T>> addAll(final int index, final Collection<? extends T> source) {
            return new Lang.Predicate<List<? super T>>(){

                @Override
                public boolean test(List<? super T> destination) {
                    return destination.addAll(index, source);
                }
            };
        }

        public static <T> Lang.Predicate<T> removeFrom(final Collection<? super T> collection) {
            return new Lang.Predicate<T>(){

                @Override
                public boolean test(T t) throws NotAppliedException, Lang.Break {
                    return collection.remove(t);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> remove(final T toBeRemoved) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> collection) {
                    return collection.remove(toBeRemoved);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? extends T>> removeAllFrom(final Collection<? super T> fromCollection) {
            return new Lang.Predicate<Collection<? extends T>>(){

                @Override
                public boolean test(Collection<? extends T> theCollection) {
                    return fromCollection.removeAll(theCollection);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> removeAll(final Collection<? extends T> source) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> collection) {
                    return collection.removeAll(source);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? extends T>> retainAllIn(final Collection<? super T> collection) {
            return new Lang.Predicate<Collection<? extends T>>(){

                @Override
                public boolean test(Collection<? extends T> theCollection) {
                    return collection.retainAll(theCollection);
                }
            };
        }

        public static <T> Lang.Predicate<Collection<? super T>> retainAll(final Collection<? extends T> collection) {
            return new Lang.Predicate<Collection<? super T>>(){

                @Override
                public boolean test(Collection<? super T> theCollection) {
                    return theCollection.retainAll(collection);
                }
            };
        }

        public static <T> Lang.F1<T, Deque<? super T>> prependTo(final Deque<? super T> deque) {
            return new Lang.F1<T, Deque<? super T>>(){

                @Override
                public Deque<? super T> apply(T t) throws NotAppliedException, Lang.Break {
                    deque.addFirst(t);
                    return deque;
                }
            };
        }

        public static <T> Lang.Processor<Deque<? super T>> dequePrepend(final T element) {
            return new Lang.Processor<Deque<? super T>>(){

                @Override
                public void process(Deque<? super T> deque) throws Lang.Break, NotAppliedException {
                    deque.addFirst(element);
                }
            };
        }

        public static <T> Lang.F1<T, Deque<? super T>> appendTo(final Deque<? super T> deque) {
            return new Lang.F1<T, Deque<? super T>>(){

                @Override
                public Deque<? super T> apply(T t) throws NotAppliedException, Lang.Break {
                    deque.addLast(t);
                    return deque;
                }
            };
        }

        public static <T> Lang.Processor<Deque<? super T>> dequeAppend(final T element) {
            return new Lang.Processor<Deque<? super T>>(){

                @Override
                public void process(Deque<? super T> deque) throws Lang.Break, NotAppliedException {
                    deque.add(element);
                }
            };
        }

        public static <T> Lang.F1<T, Sequence<? super T>> prependTo(final Sequence<? super T> sequence) {
            return new Lang.F1<T, Sequence<? super T>>(){

                @Override
                public Sequence<? super T> apply(T t) throws NotAppliedException, Lang.Break {
                    sequence.prepend(t);
                    return sequence;
                }
            };
        }

        public static <T> Lang.Processor<Sequence<? super T>> sequencePrepend(final T element) {
            return new Lang.Processor<Sequence<? super T>>(){

                @Override
                public void process(Sequence<? super T> sequence) throws Lang.Break, NotAppliedException {
                    sequence.prepend(element);
                }
            };
        }

        public static <T> Lang.F1<T, Sequence<? super T>> appendTo(final Sequence<? super T> sequence) {
            return new Lang.F1<T, Sequence<? super T>>(){

                @Override
                public Sequence<? super T> apply(T t) throws NotAppliedException, Lang.Break {
                    sequence.append(t);
                    return sequence;
                }
            };
        }

        public static <T> Lang.Processor<Sequence<? super T>> sequenceAppend(final T element) {
            return new Lang.Processor<Sequence<? super T>>(){

                @Override
                public void process(Sequence<? super T> sequence) throws Lang.Break, NotAppliedException {
                    sequence.append(element);
                }
            };
        }

        public static <T> Lang.F1<Iterable<? extends T>, Void> forEachIterable(final Lang.Visitor<? super T> visitor) {
            return new Lang.F1<Iterable<? extends T>, Void>(){

                @Override
                public Void apply(Iterable<? extends T> iterable) throws NotAppliedException, Lang.Break {
                    C.forEach(iterable, visitor);
                    return null;
                }
            };
        }
    }

    public static enum Mutable {

    }

    public static class _FilterStage2<T> {
        Lang.Predicate<? super T> predicate;

        _FilterStage2(Lang.Predicate<? super T> predicate) {
            this.predicate = $.requireNotNull(predicate);
        }

        public Sequence<T> on(Iterable<? extends T> source) {
            return C.filter(source, this.predicate);
        }
    }

    public static class _FilterStage<T> {
        Iterable<? extends T> source;

        _FilterStage(Iterable<? extends T> source) {
            this.source = source;
        }

        public Sequence<T> by(Lang.Predicate<? super T> predicate) {
            return C.filter(this.source, predicate);
        }
    }

    public static class _MapStage2<T, R> {
        Lang.Function<? super T, ? extends R> mapper;

        _MapStage2(Lang.Function<? super T, ? extends R> mapper) {
            this.mapper = $.requireNotNull(mapper);
        }

        public Sequence<R> on(Iterable<T> source) {
            return C.map(source, this.mapper);
        }
    }

    public static class _MapStage<T> {
        Iterable<? extends T> source;

        _MapStage(Iterable<? extends T> source) {
            this.source = source;
        }

        public <R> Sequence<R> with(Lang.Function<? super T, ? extends R> mapper) {
            return C.map(this.source, mapper);
        }
    }

    public static class _CollectStage2 {
        String propertyPath;

        public _CollectStage2(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        public <T> List<T> on(Iterable source) {
            return C.collect(source, this.propertyPath);
        }
    }

    public static class _CollectStage {
        Iterable source;

        public _CollectStage(Iterable source) {
            this.source = source;
        }

        public <T> List<T> by(String propertyPath) {
            return C.collect(this.source, propertyPath);
        }
    }

    public static interface ListFactory {
        public <ET> java.util.List<ET> create();

        public <ET> java.util.List<ET> create(Collection<? extends ET> var1) throws NullPointerException;

        public <ET> java.util.List<ET> create(int var1);

        public static enum Predefined {

            static final ListFactory JDK_ARRAYLIST_FACT = new ListFactory(){

                @Override
                public <ET> java.util.List<ET> create() {
                    return new ArrayList();
                }

                @Override
                public <ET> java.util.List<ET> create(Collection<? extends ET> collection) {
                    return new ArrayList<ET>(collection);
                }

                @Override
                public <ET> java.util.List<ET> create(int initialCapacity) {
                    return new ArrayList(initialCapacity);
                }
            };
            static final ListFactory JDK_LINKEDLIST_FACT = new ListFactory(){

                @Override
                public <ET> java.util.List<ET> create() {
                    return new LinkedList();
                }

                @Override
                public <ET> java.util.List<ET> create(Collection<? extends ET> collection) {
                    return new LinkedList<ET>(collection);
                }

                @Override
                public <ET> java.util.List<ET> create(int initialCapacity) {
                    return new LinkedList();
                }
            };

            static ListFactory defLinked() {
                return JDK_LINKEDLIST_FACT;
            }

            static ListFactory defRandomAccess() {
                return JDK_ARRAYLIST_FACT;
            }
        }
    }

    public static interface ListOrSet<T>
    extends List<T>,
    Set<T> {
        @Override
        public ListOrSet<T> parallel();

        @Override
        public ListOrSet<T> sequential();

        @Override
        public ListOrSet<T> lazy();

        @Override
        public ListOrSet<T> eager();

        @Override
        public ListOrSet<T> accept(Lang.Visitor<? super T> var1);

        @Override
        public ListOrSet<T> each(Lang.Visitor<? super T> var1);

        @Override
        public ListOrSet<T> forEach(Lang.Visitor<? super T> var1);

        @Override
        public ListOrSet<T> filter(Lang.Function<? super T, Boolean> var1);

        @Override
        public ListOrSet<T> without(Collection<? super T> var1);

        @Override
        public ListOrSet<T> without(T var1);

        @Override
        public ListOrSet<T> without(T var1, T ... var2);

        @Override
        public <R> ListOrSet<R> map(Lang.Function<? super T, ? extends R> var1);
    }

    public static interface Set<T>
    extends java.util.Set<T>,
    Traversable<T> {
        @Override
        public Set<T> parallel();

        @Override
        public Set<T> sequential();

        @Override
        public Set<T> lazy();

        @Override
        public Set<T> eager();

        @Override
        public Set<T> filter(Lang.Function<? super T, Boolean> var1);

        @Override
        public Set<T> accept(Lang.Visitor<? super T> var1);

        @Override
        public Set<T> each(Lang.Visitor<? super T> var1);

        @Override
        public Set<T> forEach(Lang.Visitor<? super T> var1);

        public Set<T> onlyIn(Collection<? extends T> var1);

        public Set<T> withIn(Collection<? extends T> var1);

        public Set<T> without(Collection<? super T> var1);

        public Set<T> with(Collection<? extends T> var1);

        public Set<T> with(T var1);

        public Set<T> with(T var1, T ... var2);

        public Set<T> without(T var1);

        public Set<T> without(T var1, T ... var2);
    }

    public static class Map<K, V>
    implements java.util.Map<K, V>,
    Serializable {
        private java.util.Map<K, V> _m;
        private boolean ro;
        private static final long serialVersionUID = 262498820763181265L;

        protected Map(boolean readOnly, Object ... args) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            int len = args.length;
            for (int i = 0; i < len; i += 2) {
                Object k = args[i];
                Object v = null;
                if (i + 1 < len) {
                    v = args[i + 1];
                }
                map.put(k, v);
            }
            this.ro = readOnly;
            this._m = readOnly ? Collections.unmodifiableMap(map) : map;
        }

        protected Map(boolean readOnly, java.util.Map<? extends K, ? extends V> map) {
            E.NPE(map);
            boolean sorted = map instanceof SortedMap;
            AbstractMap m = sorted ? new TreeMap() : new HashMap();
            for (K k : map.keySet()) {
                V v = map.get(k);
                m.put(k, v);
            }
            this.ro = readOnly;
            this._m = readOnly ? Collections.unmodifiableMap(m) : m;
        }

        @Override
        public int size() {
            return this._m.size();
        }

        @Override
        public boolean isEmpty() {
            return this._m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this._m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this._m.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this._m.get(key);
        }

        @Override
        public V put(K key, V value) {
            this.ensureWritable();
            return this._m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.ensureWritable();
            return this._m.remove(key);
        }

        @Override
        public void putAll(java.util.Map<? extends K, ? extends V> m) {
            this.ensureWritable();
            this._m.putAll(m);
        }

        @Override
        public void clear() {
            this.ensureWritable();
            this._m.clear();
        }

        @Override
        public java.util.Set<K> keySet() {
            return this._m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this._m.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = C.newSet();
            for (K k : this._m.keySet()) {
                V v = this._m.get(k);
                set.add(Entry.valueOf(k, v));
            }
            return set;
        }

        @Override
        public int hashCode() {
            return this._m.hashCode();
        }

        public String toString() {
            StringBuilder sb = S.builder(this._m.toString());
            if (this.ro) {
                sb.append("[ro]");
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof java.util.Map)) {
                return false;
            }
            if (o instanceof Map) {
                return o.equals(this._m) && ((Map)o).ro == this.ro;
            }
            return o.equals(this._m);
        }

        public _Builder map(K key) {
            return new _Builder(key);
        }

        public boolean isReadOnly() {
            return this.ro;
        }

        public Map<K, V> readOnly(boolean readOnly) {
            if (this.ro ^ readOnly) {
                return new Map<K, V>(readOnly, this._m);
            }
            return this;
        }

        public Map<K, V> forEach(Lang.IndexedVisitor<? super K, ? super V> indexedVisitor) {
            for (Map.Entry entry : this.entrySet()) {
                try {
                    indexedVisitor.apply(entry.getKey(), entry.getValue());
                }
                catch (NotAppliedException notAppliedException) {}
            }
            return this;
        }

        public Map<K, V> each(Lang.IndexedVisitor<? super K, ? super V> indexedVisitor) {
            return this.forEach(indexedVisitor);
        }

        public Map<K, V> accept(Lang.IndexedVisitor<? super K, ? super V> indexedVisitor) {
            return this.forEach(indexedVisitor);
        }

        public Map<K, V> filter(Lang.Function<K, Boolean> predicate) {
            HashMap map = new HashMap();
            for (Map.Entry entry : this.entrySet()) {
                Object k = entry.getKey();
                if (!predicate.apply(k).booleanValue()) continue;
                map.put(k, entry.getValue());
            }
            Map filtered = new Map(this.isReadOnly(), map);
            return filtered;
        }

        public <NV> Map<K, NV> transformValues(Lang.Function<V, NV> valueTransformer) {
            Map newMap = C.newMap(new Object[0]);
            for (Map.Entry entry : this.entrySet()) {
                newMap.put(entry.getKey(), valueTransformer.apply(entry.getValue()));
            }
            return newMap;
        }

        public <NK> Map<NK, V> transformKeys(Lang.Function<K, NK> keyTransformer) {
            Map newMap = C.newMap(new Object[0]);
            for (Map.Entry entry : this.entrySet()) {
                newMap.put(keyTransformer.apply(entry.getKey()), entry.getValue());
            }
            return newMap;
        }

        public <NK, NV> Map<NK, NV> transform(Lang.Function<K, NK> keyTransformer, Lang.Function<V, NV> valueTransformer) {
            Map<NK, NV> newMap = C.newMap(new Object[0]);
            for (Map.Entry entry : this.entrySet()) {
                newMap.put(keyTransformer.apply(entry.getKey()), valueTransformer.apply(entry.getValue()));
            }
            return newMap;
        }

        public Set<Lang.Binary<K, V>> zip() {
            Set<Lang.Binary<K, V>> zipped = C.newSet();
            for (Map.Entry entry : this.entrySet()) {
                zipped.add($.T2(entry.getKey(), entry.getValue()));
            }
            return zipped;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this._m);
            if (this.ro) {
                s.writeInt(1);
            } else {
                s.writeInt(0);
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._m = (java.util.Map)s.readObject();
            int i = s.readInt();
            this.ro = i != 0;
        }

        private void ensureWritable() {
            C.ensureWritable(this.ro, "map");
        }

        public class _Builder {
            private K key;

            private _Builder(K key) {
                this.key = $.requireNotNull(key);
            }

            public Map<K, V> to(V val) {
                Map me = Map.this;
                if (me.ro) {
                    Map mapBuffer = C.newMap(me);
                    mapBuffer.put(this.key, val);
                    return C.Map(mapBuffer);
                }
                Map.this.put(this.key, val);
                return Map.this;
            }
        }

        public static class Entry<K, V>
        extends Lang.T2<K, V>
        implements Map.Entry<K, V> {
            public Entry(K _1, V _2) {
                super(_1, _2);
            }

            @Override
            public K getKey() {
                return (K)this._1;
            }

            @Override
            public V getValue() {
                return (V)this._2;
            }

            @Override
            public V setValue(V value) {
                throw E.unsupport();
            }

            public static <K, V> Entry<K, V> valueOf(K k, V v) {
                return new Entry<K, V>(k, v);
            }
        }
    }

    public static interface List<T>
    extends java.util.List<T>,
    ReversibleSequence<T> {
        @Override
        public List<T> parallel();

        @Override
        public List<T> sequential();

        @Override
        public List<T> lazy();

        @Override
        public List<T> eager();

        public List<T> snapshot();

        public List<T> readOnly();

        public List<T> copy();

        public List<T> sorted();

        public List<T> unique();

        public List<T> unique(Comparator<T> var1);

        public List<T> sorted(Comparator<? super T> var1);

        @Override
        public List<T> subList(int var1, int var2);

        @Override
        public boolean addAll(Iterable<? extends T> var1);

        @Override
        public List<T> head(int var1);

        @Override
        public List<T> take(int var1);

        @Override
        public List<T> tail();

        @Override
        public List<T> tail(int var1);

        @Override
        public List<T> drop(int var1);

        @Override
        public List<T> dropWhile(Lang.Function<? super T, Boolean> var1);

        @Override
        public List<T> takeWhile(Lang.Function<? super T, Boolean> var1);

        public List<T> remove(Lang.Function<? super T, Boolean> var1);

        @Override
        public <R> List<R> map(Lang.Function<? super T, ? extends R> var1);

        @Override
        public <R> List<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> var1);

        @Override
        public <R> List<R> collect(String var1);

        @Override
        public List<T> filter(Lang.Function<? super T, Boolean> var1);

        public Lang.T2<List<T>, List<T>> split(Lang.Function<? super T, Boolean> var1);

        public Cursor<T> locateFirst(Lang.Function<T, Boolean> var1);

        public Cursor<T> locate(Lang.Function<T, Boolean> var1);

        public Cursor<T> locateLast(Lang.Function<T, Boolean> var1);

        public List<T> insert(int var1, T var2) throws IndexOutOfBoundsException;

        public List<T> insert(int var1, T ... var2) throws IndexOutOfBoundsException;

        public List<T> insert(int var1, java.util.List<T> var2) throws IndexOutOfBoundsException;

        @Override
        public List<T> append(T var1);

        @Override
        public List<T> append(Collection<? extends T> var1);

        @Override
        public List<T> append(List<T> var1);

        @Override
        public List<T> prepend(T var1);

        @Override
        public List<T> prepend(Collection<? extends T> var1);

        @Override
        public List<T> prepend(List<T> var1);

        @Override
        public List<T> reverse();

        public List<T> without(Collection<? super T> var1);

        public List<T> without(T var1);

        public List<T> without(T var1, T ... var2);

        @Override
        public List<T> accept(Lang.Visitor<? super T> var1);

        @Override
        public List<T> each(Lang.Visitor<? super T> var1);

        @Override
        public List<T> forEach(Lang.Visitor<? super T> var1);

        @Override
        public List<T> acceptLeft(Lang.Visitor<? super T> var1);

        @Override
        public List<T> acceptRight(Lang.Visitor<? super T> var1);

        public List<T> accept(Lang.IndexedVisitor<Integer, ? super T> var1);

        public List<T> each(Lang.IndexedVisitor<Integer, ? super T> var1);

        public List<T> forEach(Lang.IndexedVisitor<Integer, ? super T> var1);

        public List<T> acceptLeft(Lang.IndexedVisitor<Integer, ? super T> var1);

        public List<T> acceptRight(Lang.IndexedVisitor<Integer, ? super T> var1);

        @Override
        public <T2> List<Lang.Binary<T, T2>> zip(java.util.List<T2> var1);

        @Override
        public <T2> List<Lang.Binary<T, T2>> zipAll(java.util.List<T2> var1, T var2, T2 var3);

        @Override
        public Sequence<Lang.Binary<T, Integer>> zipWithIndex();

        public <K, V> Map<K, V> toMap(Lang.Function<? super T, ? extends K> var1, Lang.Function<? super T, ? extends V> var2);

        public <K> Map<K, T> toMapByVal(Lang.Function<? super T, ? extends K> var1);

        public <V> Map<T, V> toMapByKey(Lang.Function<? super T, ? extends V> var1);

        public static interface Cursor<T> {
            public boolean isDefined();

            public int index();

            public boolean hasNext();

            public boolean hasPrevious();

            public Cursor<T> forward() throws UnsupportedOperationException;

            public Cursor<T> backward() throws UnsupportedOperationException;

            public Cursor<T> parkLeft();

            public Cursor<T> parkRight();

            public T get() throws NoSuchElementException;

            public Cursor<T> set(T var1) throws IndexOutOfBoundsException, NullPointerException;

            public Cursor<T> drop() throws NoSuchElementException, UnsupportedOperationException;

            public Cursor<T> prepend(T var1) throws IndexOutOfBoundsException;

            public Cursor<T> append(T var1);
        }
    }

    public static interface Range<ELEMENT>
    extends Sequence<ELEMENT> {
        public ELEMENT from();

        public ELEMENT to();

        public boolean contains(ELEMENT var1);

        public boolean containsAll(Range<ELEMENT> var1);

        public Comparator<ELEMENT> order();

        public Lang.Func2<ELEMENT, Integer, ELEMENT> step();

        public Range<ELEMENT> merge(Range<ELEMENT> var1);

        public ELEMENT last();

        public Range<ELEMENT> tail(int var1);

        public Range<ELEMENT> reverse();

        public Iterator<ELEMENT> reverseIterator();

        public <R> R reduceRight(R var1, Lang.Func2<R, ELEMENT, R> var2);

        public Lang.Option<ELEMENT> reduceRight(Lang.Func2<ELEMENT, ELEMENT, ELEMENT> var1);

        public Lang.Option<ELEMENT> findLast(Lang.Function<? super ELEMENT, Boolean> var1);

        @Override
        public Range<ELEMENT> accept(Lang.Visitor<? super ELEMENT> var1);

        @Override
        public Range<ELEMENT> each(Lang.Visitor<? super ELEMENT> var1);

        @Override
        public Range<ELEMENT> forEach(Lang.Visitor<? super ELEMENT> var1);

        @Override
        public Range<ELEMENT> acceptLeft(Lang.Visitor<? super ELEMENT> var1);

        public Range<ELEMENT> acceptRight(Lang.Visitor<? super ELEMENT> var1);
    }

    public static class Array<T>
    extends ReversibleSeqBase<T>
    implements ReversibleSequence<T> {
        T[] data;

        @Override
        public Array<T> lazy() {
            super.lazy();
            return this;
        }

        @Override
        public Array<T> eager() {
            super.eager();
            return this;
        }

        @Override
        public Array<T> parallel() {
            super.parallel();
            return this;
        }

        @Override
        public Array<T> sequential() {
            super.sequential();
            return this;
        }

        Array(T[] data) {
            E.NPE(data);
            this.data = data;
        }

        @Override
        public int size() throws UnsupportedOperationException {
            return this.data.length;
        }

        @Override
        public boolean isEmpty() {
            return 0 == this.size();
        }

        public boolean isNotEmpty() {
            return 0 < this.size();
        }

        public T get(int idx) {
            return this.data[idx];
        }

        public Array<T> set(int idx, T val) {
            this.data[idx] = val;
            return this;
        }

        @Override
        public Iterator<T> iterator() {
            final int size = this.size();
            return new ReadOnlyIterator<T>(){
                int cursor = 0;

                @Override
                public boolean hasNext() {
                    return this.cursor < size;
                }

                @Override
                public T next() {
                    if (this.cursor >= size) {
                        throw new NoSuchElementException();
                    }
                    return Array.this.data[this.cursor++];
                }
            };
        }

        @Override
        public Iterator<T> reverseIterator() {
            final int size = this.size();
            return new ReadOnlyIterator<T>(){
                int cursor;
                {
                    this.cursor = size - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor < 0;
                }

                @Override
                public T next() {
                    if (this.cursor < 0) {
                        throw new NoSuchElementException();
                    }
                    return Array.this.data[this.cursor--];
                }
            };
        }

        @Override
        public ReversibleSequence<T> reverse() throws UnsupportedOperationException {
            if (this.isLazy()) {
                return ReversedRSeq.of(this);
            }
            if (this.isMutable()) {
                Algorithms.arrayReverseInplace().reverse(this.data, 0, this.data.length);
                return this;
            }
            T[] newData = Algorithms.ARRAY_REVERSE.apply(this.data, 0, this.data.length);
            return Array.of(newData);
        }

        @Override
        public List<T> asList() {
            return C.listOf(this.data);
        }

        public List<T> asNewList() {
            return C.newListOf(this.data);
        }

        public static <T> Array<T> of(T[] data) {
            return new Array<T>(data);
        }

        public static <T> Array<T> copyOf(T[] data) {
            int len = data.length;
            T[] newData = $.newArray(data, len);
            System.arraycopy(data, 0, newData, 0, len);
            return new Array<T>(newData);
        }
    }

    public static interface ReversibleSequence<T>
    extends Sequence<T> {
        @Override
        public ReversibleSequence<T> parallel();

        @Override
        public ReversibleSequence<T> sequential();

        @Override
        public ReversibleSequence<T> lazy();

        @Override
        public ReversibleSequence<T> eager();

        @Override
        public ReversibleSequence<T> head(int var1);

        @Override
        public ReversibleSequence<T> tail();

        @Override
        public ReversibleSequence<T> take(int var1);

        @Override
        public ReversibleSequence<T> takeWhile(Lang.Function<? super T, Boolean> var1);

        @Override
        public ReversibleSequence<T> drop(int var1);

        @Override
        public ReversibleSequence<T> dropWhile(Lang.Function<? super T, Boolean> var1);

        @Override
        public ReversibleSequence<T> filter(Lang.Function<? super T, Boolean> var1);

        @Override
        public ReversibleSequence<T> append(T var1);

        @Override
        public ReversibleSequence<T> append(ReversibleSequence<T> var1);

        @Override
        public ReversibleSequence<T> prepend(T var1);

        @Override
        public ReversibleSequence<T> prepend(ReversibleSequence<T> var1);

        public T last() throws UnsupportedOperationException, NoSuchElementException;

        public ReversibleSequence<T> tail(int var1) throws UnsupportedOperationException, IndexOutOfBoundsException;

        public ReversibleSequence<T> reverse() throws UnsupportedOperationException;

        public Iterator<T> reverseIterator();

        public <R> R reduceRight(R var1, Lang.Func2<R, T, R> var2);

        public Lang.Option<T> reduceRight(Lang.Func2<T, T, T> var1);

        public Lang.Option<T> findLast(Lang.Function<? super T, Boolean> var1);

        @Override
        public <R> ReversibleSequence<R> map(Lang.Function<? super T, ? extends R> var1);

        @Override
        public <R> ReversibleSequence<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> var1);

        @Override
        public ReversibleSequence<T> accept(Lang.Visitor<? super T> var1);

        @Override
        public ReversibleSequence<T> each(Lang.Visitor<? super T> var1);

        @Override
        public ReversibleSequence<T> forEach(Lang.Visitor<? super T> var1);

        @Override
        public ReversibleSequence<T> acceptLeft(Lang.Visitor<? super T> var1);

        public ReversibleSequence<T> acceptRight(Lang.Visitor<? super T> var1);

        @Override
        public <T2> ReversibleSequence<Lang.Binary<T, T2>> zip(ReversibleSequence<T2> var1);

        @Override
        public <T2> ReversibleSequence<Lang.Binary<T, T2>> zipAll(ReversibleSequence<T2> var1, T var2, T2 var3);
    }

    public static interface Sequence<T>
    extends Traversable<T> {
        @Override
        public Sequence<T> parallel();

        @Override
        public Sequence<T> sequential();

        @Override
        public Sequence<T> lazy();

        @Override
        public Sequence<T> eager();

        public T first() throws NoSuchElementException;

        public T head() throws NoSuchElementException;

        public Sequence<T> head(int var1);

        public Sequence<T> tail() throws UnsupportedOperationException;

        public Sequence<T> take(int var1);

        public Sequence<T> takeWhile(Lang.Function<? super T, Boolean> var1);

        public Sequence<T> drop(int var1) throws IllegalArgumentException;

        public Sequence<T> dropWhile(Lang.Function<? super T, Boolean> var1);

        public Sequence<T> append(Iterable<? extends T> var1);

        public Sequence<T> append(Sequence<? extends T> var1);

        public Sequence<T> append(Iterator<? extends T> var1);

        public Sequence<T> append(Enumeration<? extends T> var1);

        public Sequence<T> append(T var1);

        public Sequence<T> prepend(Iterable<? extends T> var1);

        public Sequence<T> prepend(Iterator<? extends T> var1);

        public Sequence<T> prepend(Enumeration<? extends T> var1);

        public Sequence<T> prepend(Sequence<? extends T> var1);

        public Sequence<T> prepend(T var1);

        public List<T> asList();

        @Override
        public <R> Sequence<R> map(Lang.Function<? super T, ? extends R> var1);

        @Override
        public <R> Sequence<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> var1);

        @Override
        public <R> Sequence<R> collect(String var1);

        @Override
        public Sequence<T> filter(Lang.Function<? super T, Boolean> var1);

        @Override
        public <R> R reduce(R var1, Lang.Func2<R, T, R> var2);

        public <R> R reduceLeft(R var1, Lang.Func2<R, T, R> var2);

        @Override
        public Lang.Option<T> reduce(Lang.Func2<T, T, T> var1);

        public Lang.Option<T> reduceLeft(Lang.Func2<T, T, T> var1);

        public Lang.Option<T> findFirst(Lang.Function<? super T, Boolean> var1);

        @Override
        public Sequence<T> accept(Lang.Visitor<? super T> var1);

        @Override
        public Sequence<T> each(Lang.Visitor<? super T> var1);

        @Override
        public Sequence<T> forEach(Lang.Visitor<? super T> var1);

        public Sequence<T> acceptLeft(Lang.Visitor<? super T> var1);

        public <T2> Sequence<? extends Lang.Binary<T, T2>> zip(Iterable<T2> var1);

        public <T2> Sequence<? extends Lang.Binary<T, T2>> zipAll(Iterable<T2> var1, T var2, T2 var3);

        public Sequence<? extends Lang.Binary<T, Integer>> zipWithIndex();

        public int count(T var1);
    }

    public static interface Traversable<T>
    extends Iterable<T>,
    Featured {
        public Traversable<T> parallel();

        public Traversable<T> sequential();

        public Traversable<T> lazy();

        public Traversable<T> eager();

        public boolean isEmpty();

        public int size() throws UnsupportedOperationException;

        public <R> Traversable<R> map(Lang.Function<? super T, ? extends R> var1);

        public <R> Traversable<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> var1);

        public <R> Traversable<R> collect(String var1);

        public Traversable<T> filter(Lang.Function<? super T, Boolean> var1);

        public <R> R reduce(R var1, Lang.Func2<R, T, R> var2);

        public Lang.Option<T> reduce(Lang.Func2<T, T, T> var1);

        public boolean allMatch(Lang.Function<? super T, Boolean> var1);

        public boolean anyMatch(Lang.Function<? super T, Boolean> var1);

        public boolean noneMatch(Lang.Function<? super T, Boolean> var1);

        public Lang.Option<T> findOne(Lang.Function<? super T, Boolean> var1);

        public Traversable<T> accept(Lang.Visitor<? super T> var1);

        public Traversable<T> each(Lang.Visitor<? super T> var1);

        public Traversable<T> forEach(Lang.Visitor<? super T> var1);
    }

    public static interface Featured {
        public EnumSet<Feature> features();

        public boolean is(Feature var1);

        public static class Factory {
            public static Featured identity(final EnumSet<Feature> predefined) {
                return new Featured(){

                    @Override
                    public EnumSet<Feature> features() {
                        return predefined;
                    }

                    @Override
                    public boolean is(Feature c) {
                        return predefined.contains((Object)c);
                    }
                };
            }
        }
    }

    public static enum Feature {
        IMMUTABLE,
        READONLY,
        RANDOM_ACCESS,
        LIMITED,
        LAZY,
        PARALLEL,
        ORDERED,
        SORTED;

    }
}

