/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage;

import java.util.Map;
import org.osgl.Lang;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.storage.ISObject;
import osgl.version.Version;

public interface IStorageService {
    public static final Version VERSION = ISObject.VERSION;
    public static final String DEFAULT = "default";
    public static final String CONF_KEY_GEN = "storage.keygen";
    public static final String CONF_CONTEXT_PATH = "storage.context";
    public static final String CONF_ID = "storage.id";

    public String id();

    public String contextPath();

    public ISObject get(String var1);

    public ISObject getLazy(String var1, Map<String, String> var2);

    public ISObject forceGet(String var1);

    public ISObject getFull(String var1);

    public ISObject loadContent(ISObject var1);

    public ISObject put(String var1, ISObject var2) throws UnexpectedIOException;

    public boolean isManaged(ISObject var1);

    public void remove(String var1);

    public String getContextPath();

    public String getStaticWebEndpoint();

    public String getUrl(String var1);

    public String getKey(String var1);

    public String getKey();

    public IStorageService subFolder(String var1);

    public static class f {
        public static Lang.F0<Void> put(String key, ISObject stuff, IStorageService ss) {
            return f.put().curry(key, stuff, ss);
        }

        public static Lang.F3<String, ISObject, IStorageService, Void> put() {
            return new Lang.F3<String, ISObject, IStorageService, Void>(){

                @Override
                public Void apply(String s, ISObject isObject, IStorageService iStorageService) {
                    iStorageService.put(s, isObject);
                    return null;
                }
            };
        }

        public static Lang.F0<ISObject> get(String key, IStorageService ss) {
            return f.get().curry(key, ss);
        }

        public static Lang.F2<String, IStorageService, ISObject> get() {
            return new Lang.F2<String, IStorageService, ISObject>(){

                @Override
                public ISObject apply(String key, IStorageService ss) {
                    return ss.get(key);
                }
            };
        }

        public static Lang.F0<Void> remove(String key, IStorageService ss) {
            return f.remove().curry(key, ss);
        }

        public static Lang.F2<String, IStorageService, Void> remove() {
            return new Lang.F2<String, IStorageService, Void>(){

                @Override
                public Void apply(String s, IStorageService ss) {
                    ss.remove(s);
                    return null;
                }
            };
        }
    }
}

