/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.concurrent;

import org.osgl.Lang;
import org.osgl.concurrent.JDKThreadLocal;

public interface ContextLocal<T> {
    public static final String CONF_CONTEXT_LOCAL_FACTORY = "osgl.context_local.factory";

    public T get();

    public void set(T var1);

    public void remove();

    public T initialValue();

    public static interface Factory {
        public <T> ContextLocal<T> create();

        public <T> ContextLocal<T> create(InitialValueProvider<T> var1);

        public static enum Predefined {

            public static Factory JDKThreadLocalFactory = new Factory(){

                @Override
                public <T> ContextLocal<T> create() {
                    return new JDKThreadLocal();
                }

                @Override
                public <T> ContextLocal<T> create(InitialValueProvider<T> ivp) {
                    return new JDKThreadLocal<T>(ivp);
                }
            };

            public static Factory defaultFactory() {
                return JDKThreadLocalFactory;
            }
        }
    }

    public static abstract class InitialValueProvider<T>
    extends Lang.F0<T> {
        @Override
        public T apply() {
            return this.initialValue();
        }

        public abstract T initialValue();
    }
}

