/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import org.osgl.logging.LogService;
import org.osgl.logging.Logger;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.Logger;

public class TinyLogService
implements LogService {
    protected int level;
    private String name;

    public TinyLogService(Class<?> clz) {
        this.name = clz.getName();
        this.level = Logger.getLevel((String)this.name).ordinal();
    }

    public TinyLogService(String name) {
        this.name = name;
        this.level = Logger.getLevel((String)name).ordinal();
    }

    @Override
    public void setLevel(Logger.Level level) {
        Level theirLevel = this.convert(level);
        Configurator.defaultConfig().level(this.name, theirLevel);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= Level.TRACE.ordinal();
    }

    @Override
    public void trace(String msg) {
        Logger.trace((String)msg);
    }

    @Override
    public void trace(Throwable t, String msg) {
        Logger.trace((Throwable)t, (String)msg);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String msg) {
        Logger.debug((String)msg);
    }

    @Override
    public void debug(Throwable t, String msg) {
        Logger.debug((Throwable)t, (String)msg);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level >= Level.INFO.ordinal();
    }

    @Override
    public void info(String msg) {
        Logger.info((String)msg);
    }

    @Override
    public void info(Throwable t, String msg) {
        Logger.info((Throwable)t, (String)msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= Level.WARNING.ordinal();
    }

    @Override
    public void warn(String msg) {
        Logger.warn((String)msg);
    }

    @Override
    public void warn(Throwable t, String msg) {
        Logger.warn((Throwable)t, (String)msg);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= Level.ERROR.ordinal();
    }

    @Override
    public void error(String msg) {
        Logger.error((String)msg);
    }

    @Override
    public void error(Throwable t, String msg) {
        Logger.error((Throwable)t, (String)msg);
    }

    @Override
    public void fatal(String msg) {
        Logger.error((String)msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        Logger.error((Throwable)t, (String)msg);
    }

    private Level convert(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
        }
        return Level.ERROR;
    }
}

