/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgl.logging.LogService;
import org.osgl.logging.LogServiceProvider;
import org.osgl.logging.Logger;

public class JDKLogService
implements LogService {
    private static final long serialVersionUID = 1L;
    protected final Logger logger;
    protected final String cname;

    public JDKLogService(Class c) {
        this.cname = c.getName();
        this.logger = Logger.getLogger(this.cname);
    }

    public JDKLogService(String name) {
        this.cname = name;
        this.logger = Logger.getLogger(name);
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.logger.setLevel(this.convert(level));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINEST, msg);
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.log(Level.FINEST, t, msg);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.log(Level.FINE, t, msg);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void info(Throwable t, String msg) {
        this.log(Level.INFO, t, msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    @Override
    public void warn(Throwable t, String format) {
        this.log(Level.WARNING, t, format);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format) {
        this.log(Level.SEVERE, format);
    }

    @Override
    public void error(Throwable t, String msg) {
        this.log(Level.SEVERE, t, msg);
    }

    @Override
    public void fatal(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        this.log(Level.SEVERE, t, msg);
    }

    protected void log(Level l, Throwable t, String m) {
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        String method = "unknown";
        if (locations != null && locations.length > 4) {
            StackTraceElement caller = locations[4];
            method = caller.getMethodName();
        }
        this.logger.logp(l, this.cname, method, m, t);
    }

    protected void log(Level l, String m) {
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        String method = "unknown";
        if (locations != null && locations.length > 6) {
            StackTraceElement caller = locations[6];
            method = caller.getMethodName();
        }
        this.logger.logp(l, this.cname, method, m);
    }

    private Level convert(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.FINEST;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
        }
        return Level.SEVERE;
    }

    public static class Factory
    implements LogServiceProvider {
        @Override
        public LogService getLogService(String name) {
            return new JDKLogService(name);
        }
    }
}

