/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.osgl.cache.CacheService;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.cache.impl.CacheServiceBase;
import org.osgl.util.S;

public class EhCacheService
extends CacheServiceBase {
    private static volatile EhCacheService INSTANCE = null;
    CacheManager cacheManager;
    Cache cache;
    private String cacheName = "osgl-cache";
    private int defaultTTL = 60;

    EhCacheService(String name) {
        if (S.notBlank((String)name)) {
            this.cacheName = name;
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration();
        configuration.setClassLoader(CacheServiceProvider.Impl.classLoader());
        this.cacheManager = CacheManager.create((Configuration)configuration);
        Cache cache = this.cacheManager.getCache(this.cacheName);
        if (null == cache) {
            cache = (Cache)this.cacheManager.addCacheIfAbsent(this.cacheName);
        }
        this.cache = cache;
        long l = this.cache.getCacheConfiguration().getTimeToLiveSeconds();
        if (0L != l) {
            this.defaultTTL = (int)l;
        }
    }

    public void put(String key, Object value, int ttl) {
        Element element = new Element((Object)key, value);
        if (0 >= ttl) {
            ttl = this.defaultTTL;
        }
        element.setTimeToLive(ttl);
        this.cache.put(element);
    }

    public void put(String key, Object value) {
        this.put(key, value, this.defaultTTL);
    }

    public void evict(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    public <T> T get(String key) {
        Element e = this.cache.get((Serializable)((Object)key));
        if (null == e) {
            return null;
        }
        return (T)e.getObjectValue();
    }

    public void clear() {
        this.cache.removeAll();
    }

    public void setDefaultTTL(int ttl) {
        if (ttl <= 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero or negative number");
        }
        this.defaultTTL = ttl;
    }

    public void shutdown() {
        this.clear();
    }

    public void startup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CacheService defaultInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<CacheService> clazz = CacheService.class;
        synchronized (CacheService.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new EhCacheService("osgl-cache");
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

