/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache;

import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.cache.impl.NullCacheService;
import org.osgl.cache.impl.SimpleCacheServiceProvider;
import org.osgl.util.S;

public interface CacheServiceProvider {
    public CacheService get();

    public CacheService get(String var1);

    public static enum Impl implements CacheServiceProvider
    {
        NoCache{

            @Override
            public CacheService get() {
                return NullCacheService.INSTANCE;
            }

            @Override
            public CacheService get(String name) {
                return this.get();
            }
        }
        ,
        Simple{

            @Override
            public CacheService get() {
                return SimpleCacheServiceProvider.INSTANCE.get();
            }

            @Override
            public CacheService get(String name) {
                return SimpleCacheServiceProvider.INSTANCE.get(name);
            }
        }
        ,
        EhCache{

            @Override
            public CacheService get() {
                CacheServiceProvider fact = (CacheServiceProvider)$.newInstance((String)"org.osgl.cache.impl.EhCacheServiceProvider");
                return fact.get();
            }

            @Override
            public CacheService get(String name) {
                CacheServiceProvider fact = (CacheServiceProvider)$.newInstance((String)"org.osgl.cache.impl.EhCacheServiceProvider");
                return fact.get(name);
            }
        }
        ,
        Memcached{

            @Override
            public CacheService get() {
                CacheServiceProvider fact = (CacheServiceProvider)$.newInstance((String)"org.osgl.cache.impl.MemcachedServiceProvider");
                return fact.get();
            }

            @Override
            public CacheService get(String name) {
                CacheServiceProvider fact = (CacheServiceProvider)$.newInstance((String)"org.osgl.cache.impl.MemcachedServiceProvider");
                return fact.get(name);
            }
        }
        ,
        Auto{

            private CacheServiceProvider configured(String name) {
                if (S.blank((String)name)) {
                    name = "osgl.cache.impl";
                } else if (!(name = name.toLowerCase().trim()).startsWith("osgl.cache.impl.")) {
                    name = "osgl.cache.impl." + name;
                }
                String cacheImpl = System.getProperty(name);
                if (S.notBlank((String)cacheImpl)) {
                    try {
                        return (CacheServiceProvider)$.newInstance((String)cacheImpl);
                    }
                    catch (Exception e) {
                        try {
                            CacheServiceProvider csp = Impl.valueOfIgnoreCase(cacheImpl);
                            return csp == Auto ? null : csp;
                        }
                        catch (Exception e2) {
                            return null;
                        }
                    }
                }
                return null;
            }

            private CacheServiceProvider configured() {
                return this.configured(null);
            }

            @Override
            public CacheService get() {
                CacheServiceProvider csp = this.configured();
                if (null != csp) {
                    return csp.get();
                }
                try {
                    return Memcached.get();
                }
                catch (Throwable throwable) {
                    try {
                        return EhCache.get();
                    }
                    catch (Throwable throwable2) {
                        return Simple.get();
                    }
                }
            }

            @Override
            public CacheService get(String name) {
                CacheServiceProvider csp = this.configured(name);
                if (null != csp) {
                    return csp.get();
                }
                try {
                    return Memcached.get(name);
                }
                catch (Throwable throwable) {
                    try {
                        return EhCache.get(name);
                    }
                    catch (Throwable throwable2) {
                        return Simple.get(name);
                    }
                }
            }
        };

        private static volatile ClassLoader classLoader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ClassLoader classLoader() {
            if (null != classLoader) return classLoader;
            Class<CacheServiceProvider> clazz = CacheServiceProvider.class;
            synchronized (CacheServiceProvider.class) {
                if (null != classLoader) return classLoader;
                classLoader = Thread.currentThread().getContextClassLoader();
                // ** MonitorExit[var0] (shouldn't be in output)
                return classLoader;
            }
        }

        public static void setClassLoader(ClassLoader classLoader) {
            Impl.classLoader = (ClassLoader)$.notNull((Object)classLoader);
        }

        public static CacheServiceProvider valueOfIgnoreCase(String name) {
            if (S.blank((String)name)) {
                return null;
            }
            if ((name = name.trim().toLowerCase().intern()) == NoCache.name().intern()) {
                return NoCache;
            }
            if (name == Simple.name().toLowerCase().intern()) {
                return Simple;
            }
            if (name == Memcached.name().toLowerCase().intern()) {
                return Memcached;
            }
            if (name == EhCache.name().toLowerCase().intern()) {
                return EhCache;
            }
            if (name == Auto.name().toLowerCase().intern()) {
                return Auto;
            }
            return null;
        }
    }
}

