/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgl.$;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.util.S;

class SimpleAnnoInvocationHandler
implements InvocationHandler {
    private final Class<? extends Annotation> type;

    SimpleAnnoInvocationHandler(Class<? extends Annotation> type) {
        this.type = type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (S.eq((String)"hashCode", (String)methodName)) {
            return this.hashCode();
        }
        if (S.eq((String)"equals", (String)methodName)) {
            return this.equals(args[0]);
        }
        if (S.eq((String)"annotationType", (String)methodName)) {
            return this.type;
        }
        if (S.eq((String)"toString", (String)methodName)) {
            return this.toString();
        }
        Object result = method.getDefaultValue();
        if (result == null) {
            throw new IncompleteAnnotationException(this.type, methodName);
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (Method m : this.type.getDeclaredMethods()) {
            Object o = m.getDefaultValue();
            if (null == o) {
                throw new IncompleteAnnotationException(this.type, m.getName());
            }
            result += AnnotationUtil.hashMember(m.getName(), o);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.type.isInstance(obj)) {
            return false;
        }
        if (SimpleAnnoInvocationHandler.isUs(obj)) {
            return true;
        }
        for (Method m : this.type.getDeclaredMethods()) {
            Object thatVal;
            Object thisVal = m.getDefaultValue();
            try {
                thatVal = m.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if ($.eq2((Object)thatVal, (Object)thisVal)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString();
    }

    private static boolean isUs(Object o) {
        if (Proxy.isProxyClass(o.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(o);
            return handler instanceof SimpleAnnoInvocationHandler;
        }
        return false;
    }
}

