/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.GenericTypedBeanLoader;
import org.osgl.inject.Genie;
import org.osgl.util.C;
import org.osgl.util.E;

public abstract class Module {
    private List<Genie.Binder> binders = new ArrayList<Genie.Binder>();
    private Set<Class<? extends Annotation>> qualifiers = new HashSet<Class<? extends Annotation>>();
    private Map<Class<?>, GenericTypedBeanLoader<?>> genericTypedBeanLoaders = new HashMap();
    private boolean configured;

    protected final <T> Genie.Binder<T> bind(Class<T> type) {
        Genie.Binder<T> binder = new Genie.Binder<T>(type);
        this.binders.add(binder);
        return binder;
    }

    protected final Module registerQualifiers(Class<? extends Annotation> ... qualifiers) {
        this.qualifiers.addAll((Collection<Class<? extends Annotation>>)C.listOf((Object[])qualifiers));
        return this;
    }

    protected final <T> void registerGenericTypedBeanLoader(Class<T> type, GenericTypedBeanLoader<T> loader) {
        this.genericTypedBeanLoaders.put(type, loader);
    }

    protected abstract void configure();

    final void applyTo(Genie genie) {
        if (!this.configured) {
            this.configure();
        }
        this.configured = true;
        this.validate(genie);
        for (Genie.Binder binder : this.binders) {
            binder.register(genie);
        }
        genie.registerQualifiers(this.qualifiers);
        for (Map.Entry entry : this.genericTypedBeanLoaders.entrySet()) {
            genie.registerGenericTypedBeanLoader((Class)entry.getKey(), (GenericTypedBeanLoader)entry.getValue());
        }
    }

    private void validate(Genie genie) {
        C.Map map = C.newMap((Object[])new Object[0]);
        for (Genie.Binder binder : this.binders) {
            BeanSpec spec = binder.beanSpec(genie);
            if (map.containsKey(spec)) {
                throw E.invalidConfiguration((String)"Duplicate bean spec found: ", (Object[])new Object[]{spec});
            }
            map.put(spec, binder);
        }
    }
}

