/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class PythonSourceFile
extends DataTable<Row> {
    public PythonSourceFile(Recipe recipe) {
        super(recipe, "Python source files", "Python sources present in LSTs on the SAAS.");
    }

    public static enum SourceFileType {
        Python,
        Quark,
        PlainText;

    }

    public static final class Row {
        @Column(displayName="Source path before the run", description="The source path of the file before the run.")
        private final String sourcePath;
        @Column(displayName="Source file type", description="The source file type that was created.")
        private final SourceFileType sourceFileType;
        @Column(displayName="Language level", description="The version of python.")
        private final String languageLevel;

        public Row(String sourcePath, SourceFileType sourceFileType, String languageLevel) {
            this.sourcePath = sourcePath;
            this.sourceFileType = sourceFileType;
            this.languageLevel = languageLevel;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public SourceFileType getSourceFileType() {
            return this.sourceFileType;
        }

        public String getLanguageLevel() {
            return this.languageLevel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            SourceFileType this$sourceFileType = this.getSourceFileType();
            SourceFileType other$sourceFileType = other.getSourceFileType();
            if (this$sourceFileType == null ? other$sourceFileType != null : !((Object)((Object)this$sourceFileType)).equals((Object)other$sourceFileType)) {
                return false;
            }
            String this$languageLevel = this.getLanguageLevel();
            String other$languageLevel = other.getLanguageLevel();
            return !(this$languageLevel == null ? other$languageLevel != null : !this$languageLevel.equals(other$languageLevel));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            SourceFileType $sourceFileType = this.getSourceFileType();
            result = result * 59 + ($sourceFileType == null ? 43 : ((Object)((Object)$sourceFileType)).hashCode());
            String $languageLevel = this.getLanguageLevel();
            result = result * 59 + ($languageLevel == null ? 43 : $languageLevel.hashCode());
            return result;
        }

        public String toString() {
            return "PythonSourceFile.Row(sourcePath=" + this.getSourcePath() + ", sourceFileType=" + (Object)((Object)this.getSourceFileType()) + ", languageLevel=" + this.getLanguageLevel() + ")";
        }
    }
}

