/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Space;
import org.openrewrite.python.tree.PySpace;

public class PsiPaddingCursor {
    private State state = State.Uninitialized.INSTANCE;
    private final PsiFile file;

    private static State attachAfter(PsiElement element) {
        ASTNode nextNode = PsiPaddingCursor.nodeAfter(element.getNode());
        if (nextNode == null) {
            return new State.StoppedAtEOF(element.getContainingFile());
        }
        return PsiPaddingCursor.attachAt(nextNode.getPsi());
    }

    private static State attachToSpaceBefore(PsiElement element) {
        State state = PsiPaddingCursor.attachAt(element);
        while (element.getPrevSibling() != null) {
            State prevState = PsiPaddingCursor.attachAt(element = element.getPrevSibling());
            if (prevState instanceof State.Consumable) {
                state = prevState;
                continue;
            }
            return state;
        }
        return state;
    }

    private static State attachAtTrailingSpaceWithin(PsiElement element) {
        PsiElement child = element.getLastChild();
        if (child == null) {
            return PsiPaddingCursor.attachAfter(element);
        }
        State state = PsiPaddingCursor.attachAt(child);
        if (!(state instanceof State.Consumable)) {
            return PsiPaddingCursor.attachAfter(element);
        }
        while (child.getPrevSibling() != null) {
            State prevState = PsiPaddingCursor.attachAt(child = child.getPrevSibling());
            if (prevState instanceof State.Consumable) {
                state = prevState;
                continue;
            }
            return state;
        }
        return state;
    }

    private static State attachAt(PsiElement element) {
        ASTNode node;
        ASTNode next2 = element.getNode();
        while ((next2 = PsiPaddingCursor.nextNodeInTraversal(node = next2)) != null && next2.getStartOffset() == node.getStartOffset()) {
        }
        element = node.getPsi();
        if (element instanceof PsiWhiteSpace) {
            return new State.WhitespaceNext((PsiWhiteSpace)element, 0);
        }
        if (element instanceof PsiComment) {
            return new State.CommentNext((PsiComment)element);
        }
        return new State.StoppedAtElement(element);
    }

    @Nullable
    private static ASTNode nextNodeInTraversal(ASTNode node) {
        if (node.getFirstChildNode() != null) {
            return node.getFirstChildNode();
        }
        return PsiPaddingCursor.nodeAfter(node);
    }

    @Nullable
    private static ASTNode nodeAfter(ASTNode node) {
        if (node.getTreeNext() != null) {
            return node.getTreeNext();
        }
        for (node = node.getTreeParent(); node != null && node.getTreeNext() == null; node = node.getTreeParent()) {
        }
        if (node == null) {
            return null;
        }
        return node.getTreeNext();
    }

    private static int actualNodeOffset(PsiElement element) {
        return element.getNode().getStartOffset();
    }

    public PsiPaddingCursor(PsiFile file) {
        this.file = file;
    }

    @Nullable
    public Integer offsetInFile() {
        return this.state.getSourceOffset();
    }

    public boolean isPast(PsiElement element) {
        @Nullable Integer offset = this.offsetInFile();
        if (offset == null) {
            throw new IllegalStateException("not attached");
        }
        return offset > PsiPaddingCursor.actualNodeOffset(element);
    }

    public <T> T withRollback(Supplier<T> fn) {
        State prev = this.state;
        T result = fn.get();
        this.state = prev;
        return result;
    }

    public Space consumeRemaining() {
        AtomicReference<Space> acc = new AtomicReference<Space>(Space.EMPTY);
        while (this.state instanceof State.Consumable) {
            this.state = ((State.Consumable)this.state).consume(acc);
        }
        return acc.get();
    }

    public Space consumeRemainingAndExpect(PsiElement expectedNext) {
        Space space = this.consumeRemaining();
        this.expectNext(expectedNext);
        return space;
    }

    public Space consumeRemainingAndExpectEOF() {
        Space space = this.consumeRemaining();
        this.expectEOF();
        return space;
    }

    public WithStatus<Space> consumeUntilNewlineWithStatus() {
        return this.consumeUntilFoundWithStatus("\n");
    }

    public WithStatus<Space> consumeUntilFoundWithStatus(String search) {
        AtomicReference<Space> acc = new AtomicReference<Space>(Space.EMPTY);
        while (this.state instanceof State.Consumable) {
            this.state = ((State.Consumable)this.state).consumeUntilFound(acc, search);
            if (!(this.state instanceof State.FoundMatch)) continue;
        }
        boolean success = this.state instanceof State.FoundMatch;
        return new WithStatus<Space>(acc.get(), success);
    }

    public Space consumeUntilNewline() {
        return (Space)((WithStatus)this.consumeUntilNewlineWithStatus()).value;
    }

    public Space consumeUntilFound(String search) {
        return (Space)((WithStatus)this.consumeUntilFoundWithStatus(search)).value;
    }

    @Nullable
    public Space consumeUntilNewlineOrRollback() {
        return this.consumeUntilFoundOrRollback("\n", space -> space);
    }

    @Nullable
    public <T> T consumeUntilNewlineOrRollback(Function<Space, T> fn) {
        return this.consumeUntilFoundOrRollback("\n", fn);
    }

    @Nullable
    public <T> T consumeUntilFoundOrRollback(String search, Function<Space, T> fn) {
        State initialState = this.state;
        WithStatus<Space> result = this.consumeUntilFoundWithStatus(search);
        if (((WithStatus)result).succeeded) {
            return fn.apply((Space)((WithStatus)result).value);
        }
        this.state = initialState;
        return null;
    }

    public Space consumeUntilExpectedNewline() {
        return this.consumeUntilExpectedWhitespace("\n");
    }

    public Space consumeUntilExpectedWhitespace(String search) {
        WithStatus<Space> withStatus = this.consumeUntilFoundWithStatus(search);
        if (!((WithStatus)withStatus).succeeded) {
            throw new IllegalStateException("did not find pattern as expected;\n" + this.printDebuggingMessage("STOPPED HERE"));
        }
        return (Space)((WithStatus)withStatus).value;
    }

    private void assertDiscardable() {
        if (!(this.state instanceof State.Discardable)) {
            throw new IllegalStateException("resetting would discard an active whitespace position;\n" + this.printDebuggingMessage("ATTEMPTED TO RESET HERE"));
        }
    }

    public void resetTo(PsiElement next2) {
        this.assertDiscardable();
        this.state = PsiPaddingCursor.attachAt(next2);
    }

    public void resetToSpaceBefore(PsiElement elementAfterSpace) {
        this.assertDiscardable();
        this.state = PsiPaddingCursor.attachToSpaceBefore(elementAfterSpace);
    }

    public void resetToSpaceAfter(PsiElement next2) {
        this.assertDiscardable();
        this.state = PsiPaddingCursor.attachAfter(next2);
    }

    public void resetToTrailingSpaceWithin(PsiElement within) {
        this.assertDiscardable();
        this.state = PsiPaddingCursor.attachAtTrailingSpaceWithin(within);
    }

    public void expectNext(PsiElement expectedNext) {
        @Nullable Integer currentOffset = this.state.getSourceOffset();
        int expectedOffset = PsiPaddingCursor.actualNodeOffset(expectedNext);
        if (currentOffset == null || currentOffset != expectedOffset) {
            throw new IllegalStateException(String.format("did not stop (%d) where expected (%d);\n%s\n%s", currentOffset == null ? -1 : currentOffset, expectedOffset, this.printDebuggingMessage("STOPPED HERE"), this.printDebuggingMessage("EXPECTED HERE", expectedOffset)));
        }
    }

    public void expectEOF() {
        if (!(this.state instanceof State.StoppedAtEOF)) {
            throw new IllegalStateException(String.format("did not stop where expected (at eof);\n%s", this.printDebuggingMessage("STOPPED HERE")));
        }
    }

    private String printDebuggingMessage(String label) {
        return this.printDebuggingMessage(label, this.state.getSourceOffset());
    }

    private String printDebuggingMessage(String label, @Nullable Integer offset) {
        StringBuilder sb = new StringBuilder();
        sb.append("In file " + this.file.getName() + ":\n");
        sb.append("--\n");
        if (offset == null) {
            sb.append("<null position>\n");
        } else {
            String text = this.file.getText();
            int lastNewlineBeforeHere = PsiPaddingCursor.lastNewline(text, offset - 1);
            int nextNewline = PsiPaddingCursor.nextNewline(text, offset);
            int previewStart = PsiPaddingCursor.lastNewline(text, lastNewlineBeforeHere - 80);
            int previewEnd = PsiPaddingCursor.nextNewline(text, nextNewline + 80);
            if (previewStart < nextNewline) {
                sb.append(text, previewStart, nextNewline + 1);
            }
            for (int i = 0; i < offset - lastNewlineBeforeHere - 1; ++i) {
                sb.append(" ");
            }
            sb.append("^-------[ ").append(label).append(" ]\n");
            if (nextNewline < previewEnd) {
                sb.append(text, nextNewline + 1, previewEnd);
            }
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append("\n");
        }
        sb.append("--\n");
        return sb.toString();
    }

    private static int nextNewline(String str, int afterPosition) {
        if (afterPosition >= str.length() || afterPosition < 0) {
            return str.length();
        }
        int found = str.substring(afterPosition).indexOf("\n");
        return found < 0 ? str.length() : afterPosition + found;
    }

    private static int lastNewline(String str, int beforePosition) {
        if (beforePosition >= str.length() || beforePosition < 0) {
            return 0;
        }
        return Math.max(0, str.substring(0, beforePosition).lastIndexOf("\n"));
    }

    private static interface State {
        @Nullable
        public Integer getSourceOffset();

        public static final class StoppedAtEOF
        implements Discardable {
            private final PsiElement file;

            @Override
            public Integer getSourceOffset() {
                return this.file.getTextRange().getEndOffset();
            }

            public StoppedAtEOF(PsiElement file) {
                this.file = file;
            }

            public PsiElement getFile() {
                return this.file;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StoppedAtEOF)) {
                    return false;
                }
                StoppedAtEOF other = (StoppedAtEOF)o;
                PsiElement this$file = this.getFile();
                PsiElement other$file = other.getFile();
                return !(this$file == null ? other$file != null : !this$file.equals(other$file));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PsiElement $file = this.getFile();
                result = result * 59 + ($file == null ? 43 : $file.hashCode());
                return result;
            }

            public String toString() {
                return "PsiPaddingCursor.State.StoppedAtEOF(file=" + this.getFile() + ")";
            }
        }

        public static final class StoppedAtElement
        implements Discardable {
            private final PsiElement stoppedAt;

            @Override
            public Integer getSourceOffset() {
                return PsiPaddingCursor.actualNodeOffset(this.stoppedAt);
            }

            public StoppedAtElement(PsiElement stoppedAt) {
                this.stoppedAt = stoppedAt;
            }

            public PsiElement getStoppedAt() {
                return this.stoppedAt;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StoppedAtElement)) {
                    return false;
                }
                StoppedAtElement other = (StoppedAtElement)o;
                PsiElement this$stoppedAt = this.getStoppedAt();
                PsiElement other$stoppedAt = other.getStoppedAt();
                return !(this$stoppedAt == null ? other$stoppedAt != null : !this$stoppedAt.equals(other$stoppedAt));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PsiElement $stoppedAt = this.getStoppedAt();
                result = result * 59 + ($stoppedAt == null ? 43 : $stoppedAt.hashCode());
                return result;
            }

            public String toString() {
                return "PsiPaddingCursor.State.StoppedAtElement(stoppedAt=" + this.getStoppedAt() + ")";
            }
        }

        public static final class FoundMatch
        implements Consumable {
            private final PsiWhiteSpace matchEndedInWhitespace;
            private final int matchEndIndexExclusive;
            private final String search;

            private WhitespaceNext nextState() {
                return new WhitespaceNext(this.matchEndedInWhitespace, this.matchEndIndexExclusive);
            }

            @Override
            public State consume(AtomicReference<Space> acc) {
                return this.nextState().consume(acc);
            }

            @Override
            public State consumeUntilFound(AtomicReference<Space> acc, String search) {
                return this.nextState().consumeUntilFound(acc, search);
            }

            @Override
            public Integer getSourceOffset() {
                return PsiPaddingCursor.actualNodeOffset(this.matchEndedInWhitespace) + this.matchEndIndexExclusive - this.search.length();
            }

            public FoundMatch(PsiWhiteSpace matchEndedInWhitespace, int matchEndIndexExclusive, String search) {
                this.matchEndedInWhitespace = matchEndedInWhitespace;
                this.matchEndIndexExclusive = matchEndIndexExclusive;
                this.search = search;
            }

            public PsiWhiteSpace getMatchEndedInWhitespace() {
                return this.matchEndedInWhitespace;
            }

            public int getMatchEndIndexExclusive() {
                return this.matchEndIndexExclusive;
            }

            public String getSearch() {
                return this.search;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FoundMatch)) {
                    return false;
                }
                FoundMatch other = (FoundMatch)o;
                if (this.getMatchEndIndexExclusive() != other.getMatchEndIndexExclusive()) {
                    return false;
                }
                PsiWhiteSpace this$matchEndedInWhitespace = this.getMatchEndedInWhitespace();
                PsiWhiteSpace other$matchEndedInWhitespace = other.getMatchEndedInWhitespace();
                if (this$matchEndedInWhitespace == null ? other$matchEndedInWhitespace != null : !this$matchEndedInWhitespace.equals(other$matchEndedInWhitespace)) {
                    return false;
                }
                String this$search = this.getSearch();
                String other$search = other.getSearch();
                return !(this$search == null ? other$search != null : !this$search.equals(other$search));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getMatchEndIndexExclusive();
                PsiWhiteSpace $matchEndedInWhitespace = this.getMatchEndedInWhitespace();
                result = result * 59 + ($matchEndedInWhitespace == null ? 43 : $matchEndedInWhitespace.hashCode());
                String $search = this.getSearch();
                result = result * 59 + ($search == null ? 43 : $search.hashCode());
                return result;
            }

            public String toString() {
                return "PsiPaddingCursor.State.FoundMatch(matchEndedInWhitespace=" + this.getMatchEndedInWhitespace() + ", matchEndIndexExclusive=" + this.getMatchEndIndexExclusive() + ", search=" + this.getSearch() + ")";
            }
        }

        public static final class CommentNext
        implements Consumable {
            private final PsiComment element;

            @Override
            public State consume(AtomicReference<Space> acc) {
                acc.updateAndGet(space -> PySpace.appendComment(space, this.element.getText()));
                return PsiPaddingCursor.attachAfter(this.element);
            }

            @Override
            public State consumeUntilFound(AtomicReference<Space> acc, String search) {
                return this.consume(acc);
            }

            @Override
            public Integer getSourceOffset() {
                return PsiPaddingCursor.actualNodeOffset(this.element);
            }

            public CommentNext(PsiComment element) {
                this.element = element;
            }

            public PsiComment getElement() {
                return this.element;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CommentNext)) {
                    return false;
                }
                CommentNext other = (CommentNext)o;
                PsiComment this$element = this.getElement();
                PsiComment other$element = other.getElement();
                return !(this$element == null ? other$element != null : !this$element.equals(other$element));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                PsiComment $element = this.getElement();
                result = result * 59 + ($element == null ? 43 : $element.hashCode());
                return result;
            }

            public String toString() {
                return "PsiPaddingCursor.State.CommentNext(element=" + this.getElement() + ")";
            }
        }

        public static final class WhitespaceNext
        implements Consumable {
            private final PsiWhiteSpace element;
            private final int startIndex;

            @Override
            public State consume(AtomicReference<Space> acc) {
                acc.updateAndGet(space -> PySpace.appendWhitespace(space, this.element.getText().substring(this.startIndex)));
                return PsiPaddingCursor.attachAfter(this.element);
            }

            @Override
            public State consumeUntilFound(AtomicReference<Space> acc, String search) {
                String nextText = this.element.getText().substring(this.startIndex);
                String prevText = acc.get().getLastWhitespace();
                String combinedText = prevText + nextText;
                int startIndexInCombined = combinedText.indexOf(search, prevText.length() - (search.length() - 1));
                if (startIndexInCombined < 0) {
                    return this.consume(acc);
                }
                int endIndexInCombined = startIndexInCombined + search.length();
                int endIndexInNext = endIndexInCombined - prevText.length();
                String upToMatch = nextText.substring(0, endIndexInNext);
                acc.updateAndGet(space -> PySpace.appendWhitespace(space, upToMatch));
                return new FoundMatch(this.element, endIndexInNext, search);
            }

            @Override
            public Integer getSourceOffset() {
                return PsiPaddingCursor.actualNodeOffset(this.element) + this.startIndex;
            }

            public WhitespaceNext(PsiWhiteSpace element, int startIndex) {
                this.element = element;
                this.startIndex = startIndex;
            }

            public PsiWhiteSpace getElement() {
                return this.element;
            }

            public int getStartIndex() {
                return this.startIndex;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WhitespaceNext)) {
                    return false;
                }
                WhitespaceNext other = (WhitespaceNext)o;
                if (this.getStartIndex() != other.getStartIndex()) {
                    return false;
                }
                PsiWhiteSpace this$element = this.getElement();
                PsiWhiteSpace other$element = other.getElement();
                return !(this$element == null ? other$element != null : !this$element.equals(other$element));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getStartIndex();
                PsiWhiteSpace $element = this.getElement();
                result = result * 59 + ($element == null ? 43 : $element.hashCode());
                return result;
            }

            public String toString() {
                return "PsiPaddingCursor.State.WhitespaceNext(element=" + this.getElement() + ", startIndex=" + this.getStartIndex() + ")";
            }
        }

        public static final class Uninitialized
        implements Discardable {
            static final Uninitialized INSTANCE = new Uninitialized();

            private Uninitialized() {
            }

            @Override
            @Nullable
            public Integer getSourceOffset() {
                return null;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Uninitialized;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "PsiPaddingCursor.State.Uninitialized()";
            }
        }

        public static interface Discardable
        extends State {
        }

        public static interface Consumable
        extends State {
            public State consume(AtomicReference<Space> var1);

            public State consumeUntilFound(AtomicReference<Space> var1, String var2);
        }
    }

    public static final class WithStatus<T> {
        private final T value;
        private final boolean succeeded;

        public WithStatus(T value, boolean succeeded) {
            this.value = value;
            this.succeeded = succeeded;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithStatus)) {
                return false;
            }
            WithStatus other = (WithStatus)o;
            if (this.isSucceeded() != other.isSucceeded()) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSucceeded() ? 79 : 97);
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "PsiPaddingCursor.WithStatus(value=" + this.getValue() + ", succeeded=" + this.isSucceeded() + ")";
        }
    }
}

