/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.CurrentJobCancellationException;
import com.intellij.openapi.progress.JobCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return Cancellation.contextJob(ThreadContext.currentThreadContext());
    }

    @Nullable
    public static Job contextJob(@NotNull CoroutineContext context) {
        if (context == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        return (Job)context.get((CoroutineContext.Key)Job.Key);
    }

    public static boolean isCancelled() {
        Job job = Cancellation.currentJob();
        return job != null && job.isCancelled();
    }

    public static void checkCancelled() {
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive((Job)currentJob);
            }
            catch (CancellationException e) {
                throw new JobCanceledException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Throwable> T withCurrentJob(@NotNull Job job, @NotNull ThrowableComputable<T, E> action) throws E, CancellationException {
        if (job == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        if (action == null) {
            Cancellation.$$$reportNull$$$0(2);
        }
        try (AccessToken ignored = ThreadContext.withThreadContext((CoroutineContext)job);){
            T t = action.compute();
            return t;
        }
        catch (JobCanceledException e) {
            if (job.isCancelled()) throw new CurrentJobCancellationException(e);
            throw new IllegalStateException("JobCanceledException must be thrown by ProgressManager.checkCanceled()", e);
        }
    }

    @Nullable
    public static Throwable getCause(@NotNull CancellationException ce) {
        if (ce == null) {
            Cancellation.$$$reportNull$$$0(3);
        }
        if (ce instanceof CurrentJobCancellationException) {
            return ((CurrentJobCancellationException)ce).getOriginalCancellationException().getCause();
        }
        return ce.getCause();
    }

    public static boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(4);
        }
        try {
            if (Cancellation.isInNonCancelableSection()) {
                return computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                T t = computable.compute();
                return t;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ce";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/progress/Cancellation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contextJob";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withCurrentJob";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeInNonCancelableSection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

