/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyKey
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.", example="management.metrics.binders.files.enabled")
    private final String oldPropertyKey;
    @Option(displayName="New property key", description="The new name for the key identified by `oldPropertyKey`.", example="management.metrics.enable.process.files")
    private final String newPropertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `oldPropertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    @Incubating(since="7.17.0")
    private final Boolean relaxedBinding;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.properties")
    @Nullable
    @Incubating(since="7.8.0")
    private final String fileMatcher;
    @Option(displayName="Regex", description="Default false. If enabled, `oldPropertyKey` will be interepreted as a Regular Expression, and capture group contents will be available in `newPropertyKey`", required=false)
    @Nullable
    private final Boolean regex;

    @Deprecated
    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding, @Nullable String fileMatcher) {
        this(oldPropertyKey, newPropertyKey, relaxedBinding, fileMatcher, null);
    }

    @JsonCreator
    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding, @Nullable String fileMatcher, @Nullable Boolean regex) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.relaxedBinding = relaxedBinding;
        this.fileMatcher = fileMatcher;
        this.regex = regex;
    }

    public String getDisplayName() {
        return "Change property key";
    }

    public String getDescription() {
        return "Change a property key leaving the value intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyKeyVisitor<ExecutionContext>();
    }

    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ", fileMatcher=" + this.getFileMatcher() + ", regex=" + this.getRegex() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKey)) {
            return false;
        }
        ChangePropertyKey other = (ChangePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        if (this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }

    public class ChangePropertyKeyVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            if (Boolean.TRUE.equals(ChangePropertyKey.this.regex)) {
                if (!Boolean.FALSE.equals(ChangePropertyKey.this.relaxedBinding) ? NameCaseConvention.matchesRegexRelaxedBinding((String)entry.getKey(), (String)ChangePropertyKey.this.oldPropertyKey) : entry.getKey().matches(ChangePropertyKey.this.oldPropertyKey)) {
                    entry = entry.withKey(entry.getKey().replaceFirst(ChangePropertyKey.this.oldPropertyKey, ChangePropertyKey.this.newPropertyKey)).withPrefix(entry.getPrefix());
                }
            } else if (!Boolean.FALSE.equals(ChangePropertyKey.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)entry.getKey(), (String)ChangePropertyKey.this.oldPropertyKey) : entry.getKey().equals(ChangePropertyKey.this.oldPropertyKey)) {
                entry = entry.withKey(ChangePropertyKey.this.newPropertyKey).withPrefix(entry.getPrefix());
            }
            return super.visitEntry(entry, p);
        }
    }
}

