/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.List;
import java.util.Objects;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.internal.KotlinPrinter;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.style.SpacesStyle;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;

public class SpacesVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final SpacesStyle style;
    private static final boolean beforeKeywords = true;
    private static final boolean beforeLeftBrace = true;
    private static final boolean withinParentheses = false;

    public SpacesVisitor(SpacesStyle style) {
        this(style, null);
    }

    public SpacesVisitor(SpacesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (!j.getComments().isEmpty()) {
            return j;
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    Space updateSpace(Space s, boolean haveSpace) {
        if (!s.getComments().isEmpty()) {
            return s;
        }
        if (haveSpace && SpacesVisitor.notSingleSpace(s.getWhitespace())) {
            return s.withWhitespace(" ");
        }
        if (!haveSpace && SpacesVisitor.onlySpacesAndNotEmpty(s.getWhitespace())) {
            return s.withWhitespace("");
        }
        return s;
    }

    <T> JContainer<T> spaceBefore(JContainer<T> container, boolean spaceBefore, boolean formatComment) {
        if (!container.getBefore().getComments().isEmpty()) {
            if (formatComment) {
                List<Comment> comments = SpacesVisitor.spaceLastCommentSuffix(container.getBefore().getComments(), spaceBefore);
                return container.withBefore(container.getBefore().withComments(comments));
            }
            return container;
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBefore(JLeftPadded<T> container, boolean spaceBefore) {
        if (!container.getBefore().getComments().isEmpty()) {
            return container;
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBeforeLeftPaddedElement(JLeftPadded<T> container, boolean spaceBefore) {
        return container.withElement((Object)this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceBeforeRightPaddedElement(JRightPadded<T> container, boolean spaceBefore) {
        return container.withElement((Object)this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceAfter(JRightPadded<T> container, boolean spaceAfter) {
        if (!container.getAfter().getComments().isEmpty()) {
            List<Comment> comments = SpacesVisitor.spaceLastCommentSuffix(container.getAfter().getComments(), spaceAfter);
            return container.withAfter(container.getAfter().withComments(comments));
        }
        if (spaceAfter && SpacesVisitor.notSingleSpace(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(" "));
        }
        if (!spaceAfter && SpacesVisitor.onlySpacesAndNotEmpty(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(""));
        }
        return container;
    }

    private static List<Comment> spaceLastCommentSuffix(List<Comment> comments, boolean spaceSuffix) {
        return ListUtils.mapLast(comments, comment -> SpacesVisitor.spaceSuffix(comment, spaceSuffix));
    }

    private static Comment spaceSuffix(Comment comment, boolean spaceSuffix) {
        if (spaceSuffix && SpacesVisitor.notSingleSpace(comment.getSuffix())) {
            return comment.withSuffix(" ");
        }
        if (!spaceSuffix && SpacesVisitor.onlySpacesAndNotEmpty(comment.getSuffix())) {
            return comment.withSuffix("");
        }
        return comment;
    }

    private static boolean onlySpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean onlySpacesAndNotEmpty(String s) {
        return !StringUtils.isNullOrEmpty((String)s) && SpacesVisitor.onlySpaces(s);
    }

    private static boolean notSingleSpace(String str) {
        return SpacesVisitor.onlySpaces(str) && !" ".equals(str);
    }

    private Markers spaceBeforeColonAfterDeclarationName(Markers markers) {
        return markers.withMarkers(ListUtils.map((List)markers.getMarkers(), marker -> {
            if (marker instanceof TypeReferencePrefix) {
                TypeReferencePrefix mf = (TypeReferencePrefix)marker;
                return mf.withPrefix(this.updateSpace(mf.getPrefix(), this.style.getOther().getBeforeColonAfterDeclarationName()));
            }
            return marker;
        }));
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        if ((c = c.withBody(this.spaceBefore(c.getBody(), true))).getBody().getStatements().isEmpty()) {
            if (c.getKind() != J.ClassDeclaration.Kind.Type.Enum) {
                if (" ".equals(c.getBody().getEnd().getWhitespace())) {
                    c = c.withBody(c.getBody().withEnd(c.getBody().getEnd().withWhitespace("")));
                }
            } else if (" ".equals(c.getBody().getEnd().getWhitespace())) {
                c = c.withBody(c.getBody().withEnd(c.getBody().getEnd().withWhitespace("")));
            }
        }
        boolean beforeTypeParameterLeftAngleBracket = true;
        if (c.getPadding().getTypeParameters() != null) {
            c = c.getPadding().withTypeParameters(this.spaceBefore(c.getPadding().getTypeParameters(), beforeTypeParameterLeftAngleBracket, true));
        }
        if (c.getPadding().getTypeParameters() != null) {
            int typeParametersSize = c.getPadding().getTypeParameters().getElements().size();
            c = c.getPadding().withTypeParameters(c.getPadding().getTypeParameters().getPadding().withElements(ListUtils.map((List)c.getPadding().getTypeParameters().getPadding().getElements(), (index, elemContainer) -> {
                elemContainer = index == 0 ? elemContainer.withElement((Object)this.spaceBefore((J.TypeParameter)elemContainer.getElement(), false)) : elemContainer.withElement((Object)this.spaceBefore((J.TypeParameter)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                if (index == typeParametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, false);
                }
                return elemContainer;
            })));
        }
        return c;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        boolean isConstructor = m.getMarkers().findFirst(PrimaryConstructor.class).isPresent();
        JContainer jc = (m = m.getPadding().withParameters(this.spaceBefore(m.getPadding().getParameters(), false, false))).getPadding().getParameters();
        List rps = jc.getPadding().getElements();
        if (rps.size() > 1) {
            int range = rps.size() - 1;
            rps = ListUtils.map((List)rps, (index, rp) -> index < range ? this.spaceAfter((JRightPadded)rp, this.style.getOther().getBeforeComma()) : rp);
            m = m.getPadding().withParameters(jc.getPadding().withElements(rps));
        }
        m = m.withParameters(ListUtils.map((List)m.getParameters(), (index, param) -> index == 0 ? param : this.spaceBefore(param, (boolean)this.style.getOther().getAfterComma())));
        if ((m = m.withMarkers(this.spaceBeforeColonAfterDeclarationName(m.getMarkers()))).getReturnTypeExpression() != null && !isConstructor) {
            m = m.withReturnTypeExpression(this.spaceBefore(m.getReturnTypeExpression(), (boolean)this.style.getOther().getAfterColonBeforeDeclarationType()));
        }
        if (m.getBody() != null) {
            m = m.withBody(this.spaceBefore(m.getBody(), true));
        }
        if (m.getParameters().isEmpty() || m.getParameters().iterator().next() instanceof J.Empty) {
            m = m.getPadding().withParameters(m.getPadding().getParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getParameters().getPadding().getElements(), param -> param.withElement((Object)this.spaceBefore((Statement)param.getElement(), false)))));
        } else {
            int paramsSize = m.getParameters().size();
            m = m.getPadding().withParameters(m.getPadding().getParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getParameters().getPadding().getElements(), (index, param) -> {
                param = index == 0 ? param.withElement((Object)this.spaceBefore((Statement)param.getElement(), false)) : param.withElement((Object)this.spaceBefore((Statement)param.getElement(), (boolean)this.style.getOther().getAfterComma()));
                param = index == paramsSize - 1 ? this.spaceAfter((JRightPadded)param, false) : this.spaceAfter((JRightPadded)param, this.style.getOther().getBeforeComma());
                return param;
            })));
        }
        if (m.getAnnotations().getTypeParameters() != null) {
            int typeParametersSize = m.getAnnotations().getTypeParameters().getTypeParameters().size();
            m = m.getAnnotations().withTypeParameters(m.getAnnotations().getTypeParameters().getPadding().withTypeParameters(ListUtils.map((List)m.getAnnotations().getTypeParameters().getPadding().getTypeParameters(), (index, elemContainer) -> {
                elemContainer = index == 0 ? elemContainer.withElement((Object)this.spaceBefore((J.TypeParameter)elemContainer.getElement(), false)) : elemContainer.withElement((Object)this.spaceBefore((J.TypeParameter)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                if (index == typeParametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, false);
                }
                return elemContainer;
            })));
        }
        return m;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        boolean noParens = m.getMarkers().findFirst(OmitParentheses.class).isPresent();
        if (noParens && m.getPadding().getSelect() != null) {
            m = m.getPadding().withSelect(this.spaceAfter(m.getPadding().getSelect(), true));
        }
        if ((m = m.getPadding().withArguments(this.spaceBefore(m.getPadding().getArguments(), noParens, false))).getArguments().isEmpty() || m.getArguments().iterator().next() instanceof J.Empty) {
            m = m.getPadding().withArguments(m.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)m.getPadding().getArguments().getPadding().getElements(), arg -> arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), false)))));
        } else {
            int argsSize = m.getArguments().size();
            m = m.getPadding().withArguments(m.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)m.getPadding().getArguments().getPadding().getElements(), (index, arg) -> {
                arg = index == 0 ? arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), false)) : arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), (boolean)this.style.getOther().getAfterComma()));
                arg = index == argsSize - 1 ? this.spaceAfter((JRightPadded)arg, false) : this.spaceAfter((JRightPadded)arg, this.style.getOther().getBeforeComma());
                return arg;
            })));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.spaceBefore(m.getPadding().getTypeParameters(), false, true));
            m = m.withName(this.spaceBefore(m.getName(), false));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(m.getPadding().getTypeParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getTypeParameters().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement((Object)this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                return elemContainer;
            })));
        }
        return m;
    }

    @Override
    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J.MultiCatch mc = super.visitMultiCatch(multiCatch, p);
        int argsSize = mc.getAlternatives().size();
        boolean aroundOperatorsBitwise = true;
        mc = mc.getPadding().withAlternatives(ListUtils.map((List)mc.getPadding().getAlternatives(), (index, arg) -> {
            if (index > 0) {
                arg = arg.withElement((Object)this.spaceBefore((NameTree)arg.getElement(), aroundOperatorsBitwise));
            }
            if (index != argsSize - 1) {
                arg = this.spaceAfter((JRightPadded)arg, aroundOperatorsBitwise);
            }
            return arg;
        }));
        return mc;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J.If i = super.visitIf(iff, p);
        i = i.withIfCondition(this.spaceBefore(i.getIfCondition(), (boolean)this.style.getBeforeParentheses().getIfParentheses()));
        i = i.getPadding().withThenPart(this.spaceBeforeRightPaddedElement(i.getPadding().getThenPart(), true));
        i = i.withIfCondition(i.getIfCondition().getPadding().withTree(this.spaceAfter(i.getIfCondition().getPadding().getTree().withElement((Object)this.spaceBefore((Expression)i.getIfCondition().getPadding().getTree().getElement(), false)), false)));
        return i;
    }

    @Override
    public J.If.Else visitElse(J.If.Else else_, P p) {
        J.If.Else e = super.visitElse(else_, p);
        e = e.getPadding().withBody(this.spaceBeforeRightPaddedElement(e.getPadding().getBody(), true));
        boolean beforeKeywordsElseKeyword = true;
        e = this.spaceBefore(e, beforeKeywordsElseKeyword);
        return e;
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J.ForEachLoop f = super.visitForEachLoop(forLoop, p);
        f = f.withControl(this.spaceBefore(f.getControl(), (boolean)this.style.getBeforeParentheses().getForParentheses()));
        f = f.getPadding().withBody(this.spaceBeforeRightPaddedElement(f.getPadding().getBody(), true));
        boolean spaceWithinForParens = false;
        f = f.withControl(f.getControl().withVariable(this.spaceBefore(f.getControl().getVariable(), spaceWithinForParens)));
        f = f.withControl(f.getControl().getPadding().withIterable(this.spaceAfter(f.getControl().getPadding().getIterable(), spaceWithinForParens)));
        boolean otherBeforeColonInForLoop = true;
        f = f.withControl(f.getControl().getPadding().withVariable(this.spaceAfter(f.getControl().getPadding().getVariable(), otherBeforeColonInForLoop)));
        return f;
    }

    @Override
    public K.When visitWhen(K.When when, P p) {
        J w = super.visitWhen(when, (Object)p);
        if (w.getSelector() != null) {
            w = w.withSelector(this.spaceBefore((J)w.getSelector(), (boolean)this.style.getBeforeParentheses().getWhenParentheses()));
        }
        return w;
    }

    @Override
    public K.WhenBranch visitWhenBranch(K.WhenBranch whenBranch, P p) {
        J wb = super.visitWhenBranch(whenBranch, (Object)p);
        List rps = wb.getPadding().getExpressions().getPadding().getElements();
        rps = ListUtils.mapLast((List)rps, exp -> this.spaceAfter((JRightPadded)exp, this.style.getOther().getAroundArrowInWhenClause()));
        if ((wb = wb.getPadding().withExpressions((JContainer<Expression>)wb.getPadding().getExpressions().getPadding().withElements(rps))).getBody() instanceof J.Block) {
            J.Block block = (J.Block)wb.getBody();
            block = block.getMarkers().findFirst(OmitBraces.class).isPresent() ? block.withStatements(ListUtils.mapFirst((List)block.getStatements(), s -> this.spaceBefore(s, (boolean)this.style.getOther().getAroundArrowInWhenClause()))) : this.spaceBefore(block, (boolean)this.style.getOther().getAroundArrowInWhenClause());
            wb = wb.withBody((J)block);
        } else {
            wb = wb.withBody(this.spaceBefore(wb.getBody(), (boolean)this.style.getOther().getAroundArrowInWhenClause()));
        }
        return wb;
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = super.visitWhileLoop(whileLoop, p);
        w = w.withCondition(this.spaceBefore(w.getCondition(), (boolean)this.style.getBeforeParentheses().getWhileParentheses()));
        w = w.getPadding().withBody(this.spaceBeforeRightPaddedElement(w.getPadding().getBody(), true));
        w = w.withCondition(w.getCondition().withTree((J)this.spaceBefore((Expression)w.getCondition().getTree(), false)));
        w = w.withCondition(w.getCondition().getPadding().withTree(this.spaceAfter(w.getCondition().getPadding().getTree(), false)));
        return w;
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop d = super.visitDoWhileLoop(doWhileLoop, p);
        d = d.getPadding().withWhileCondition(this.spaceBefore(d.getPadding().getWhileCondition(), true));
        d = d.getPadding().withWhileCondition(this.spaceBeforeLeftPaddedElement(d.getPadding().getWhileCondition(), this.style.getBeforeParentheses().getWhileParentheses()));
        d = d.getPadding().withBody(this.spaceBeforeRightPaddedElement(d.getPadding().getBody(), true));
        d = d.withWhileCondition(d.getWhileCondition().withTree((J)this.spaceBefore((Expression)d.getWhileCondition().getTree(), false)));
        d = d.withWhileCondition(d.getWhileCondition().getPadding().withTree(this.spaceAfter(d.getWhileCondition().getPadding().getTree(), false)));
        return d;
    }

    @Override
    public J.Try visitTry(J.Try _try, P p) {
        J.Try t = super.visitTry(_try, p);
        if ((t = t.withBody(this.spaceBefore(t.getBody(), true))).getPadding().getFinally() != null) {
            JLeftPadded f = this.spaceBefore(t.getPadding().getFinally(), true);
            f = this.spaceBeforeLeftPaddedElement(f, true);
            t = t.getPadding().withFinally(f);
        }
        if (t.getResources() != null) {
            t = t.withResources(ListUtils.mapFirst((List)t.getResources(), res -> this.spaceBefore(res, false)));
        }
        if (t.getPadding().getResources() != null) {
            t = t.getPadding().withResources(t.getPadding().getResources().getPadding().withElements(ListUtils.mapLast((List)t.getPadding().getResources().getPadding().getElements(), res -> this.spaceAfter((JRightPadded)res, false))));
        }
        return t;
    }

    @Override
    public J.Try.Catch visitCatch(J.Try.Catch _catch, P p) {
        J.Try.Catch c = super.visitCatch(_catch, p);
        c = this.spaceBefore(c, true);
        c = c.withParameter(this.spaceBefore(c.getParameter(), (boolean)this.style.getBeforeParentheses().getCatchParentheses()));
        c = c.withBody(this.spaceBefore(c.getBody(), true));
        c = c.withParameter(c.getParameter().withTree((J)this.spaceBefore((J.VariableDeclarations)c.getParameter().getTree(), false)));
        c = c.withParameter(c.getParameter().getPadding().withTree(this.spaceAfter(c.getParameter().getPadding().getTree(), false)));
        return c;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        J.Annotation a = super.visitAnnotation(annotation, p);
        if (a.getPadding().getArguments() != null) {
            a = a.getPadding().withArguments(this.spaceBefore(a.getPadding().getArguments(), false, true));
        }
        if (a.getPadding().getArguments() != null) {
            int argsSize = a.getPadding().getArguments().getElements().size();
            a = a.getPadding().withArguments(a.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)a.getPadding().getArguments().getPadding().getElements(), (index, arg) -> {
                if (index != 0) {
                    arg = arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index == argsSize - 1) {
                    arg = this.spaceAfter((JRightPadded)arg, false);
                }
                return arg;
            })));
        }
        return a;
    }

    @Override
    public J.Assignment visitAssignment(J.Assignment assignment, P p) {
        J.Assignment a = super.visitAssignment(assignment, p);
        a = a.getPadding().withAssignment(this.spaceBefore(a.getPadding().getAssignment(), (boolean)this.style.getAroundOperators().getAssignment()));
        a = a.getPadding().withAssignment(a.getPadding().getAssignment().withElement((Object)this.spaceBefore((Expression)a.getPadding().getAssignment().getElement(), (boolean)this.style.getAroundOperators().getAssignment())));
        return a;
    }

    @Override
    public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J.AssignmentOperation a = super.visitAssignmentOperation(assignOp, p);
        J.AssignmentOperation.Padding padding = a.getPadding();
        JLeftPadded operator = padding.getOperator();
        String operatorBeforeWhitespace = operator.getBefore().getWhitespace();
        if (this.style.getAroundOperators().getAssignment().booleanValue() && StringUtils.isNullOrEmpty((String)operatorBeforeWhitespace)) {
            a = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
        } else if (!this.style.getAroundOperators().getAssignment().booleanValue() && " ".equals(operatorBeforeWhitespace)) {
            a = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
        }
        a = a.withAssignment(this.spaceBefore(a.getAssignment(), (boolean)this.style.getAroundOperators().getAssignment()));
        return a;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, p);
        mv = mv.withMarkers(this.spaceBeforeColonAfterDeclarationName(mv.getMarkers()));
        if (multiVariable.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null) != null && mv.getTypeExpression() != null) {
            mv = mv.withTypeExpression(this.spaceBefore(mv.getTypeExpression(), (boolean)this.style.getOther().getAfterColonBeforeDeclarationType()));
        }
        return mv;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v2 = super.visitVariable(variable, p);
        if (v2.getPadding().getInitializer() != null) {
            v2 = v2.getPadding().withInitializer(this.spaceBefore(v2.getPadding().getInitializer(), (boolean)this.style.getAroundOperators().getAssignment()));
        }
        if (v2.getPadding().getInitializer() != null) {
            v2 = v2.getPadding().withInitializer(v2.getPadding().getInitializer().withElement((Object)this.spaceBefore((Expression)v2.getPadding().getInitializer().getElement(), (boolean)this.style.getAroundOperators().getAssignment())));
        }
        return v2;
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        J.Binary b = super.visitBinary(binary, p);
        J.Binary.Type operator = b.getOperator();
        switch (operator) {
            case And: 
            case Or: {
                b = this.applyBinarySpaceAround(b, (boolean)this.style.getAroundOperators().getLogical());
                break;
            }
            case Equal: 
            case NotEqual: {
                b = this.applyBinarySpaceAround(b, (boolean)this.style.getAroundOperators().getEquality());
                break;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: {
                b = this.applyBinarySpaceAround(b, (boolean)this.style.getAroundOperators().getRelational());
                break;
            }
            case Addition: 
            case Subtraction: {
                b = this.applyBinarySpaceAround(b, (boolean)this.style.getAroundOperators().getAdditive());
                break;
            }
            case Multiplication: 
            case Division: 
            case Modulo: {
                b = this.applyBinarySpaceAround(b, (boolean)this.style.getAroundOperators().getMultiplicative());
                break;
            }
            case BitAnd: 
            case BitOr: 
            case BitXor: 
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                b = this.applyBinarySpaceAround(b, true);
            }
        }
        return b;
    }

    @Override
    public K.Binary visitBinary(K.Binary binary, P p) {
        J b = super.visitBinary(binary, (Object)p);
        K.Binary.Type operator = b.getOperator();
        switch (operator) {
            case NotContains: 
            case Contains: {
                break;
            }
            case Get: {
                b = b.withAfter(this.updateSpace(b.getAfter(), false));
                b = b.withRight(this.spaceBefore(b.getRight(), false));
                break;
            }
            case IdentityEquals: 
            case IdentityNotEquals: {
                b = this.applyBinarySpaceAround((K.Binary)b, (boolean)this.style.getAroundOperators().getEquality());
                break;
            }
            case RangeTo: {
                b = this.applyBinarySpaceAround((K.Binary)b, (boolean)this.style.getAroundOperators().getRange());
            }
        }
        return b;
    }

    private J.Binary applyBinarySpaceAround(J.Binary binary, boolean useSpaceAround) {
        J.Binary.Padding padding = binary.getPadding();
        JLeftPadded operator = padding.getOperator();
        if (useSpaceAround) {
            if (StringUtils.isNullOrEmpty((String)operator.getBefore().getWhitespace())) {
                binary = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
            }
            if (StringUtils.isNullOrEmpty((String)binary.getRight().getPrefix().getWhitespace())) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace(" ")));
            }
        } else {
            if (" ".equals(operator.getBefore().getWhitespace())) {
                binary = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
            }
            if (" ".equals(binary.getRight().getPrefix().getWhitespace())) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace("")));
            }
        }
        return binary;
    }

    private K.Binary applyBinarySpaceAround(K.Binary binary, boolean useSpaceAround) {
        K.Binary.Padding padding = binary.getPadding();
        JLeftPadded<K.Binary.Type> operator = padding.getOperator();
        if (useSpaceAround) {
            if (StringUtils.isNullOrEmpty((String)operator.getBefore().getWhitespace())) {
                binary = padding.withOperator((JLeftPadded<K.Binary.Type>)operator.withBefore(operator.getBefore().withWhitespace(" ")));
            }
            if (StringUtils.isNullOrEmpty((String)binary.getRight().getPrefix().getWhitespace())) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace(" ")));
            }
        } else {
            if (" ".equals(operator.getBefore().getWhitespace())) {
                binary = padding.withOperator((JLeftPadded<K.Binary.Type>)operator.withBefore(operator.getBefore().withWhitespace("")));
            }
            if (binary.getRight().getPrefix().getWhitespace().equals(" ")) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace("")));
            }
        }
        return binary;
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        J.Unary u = super.visitUnary(unary, p);
        switch (u.getOperator()) {
            case PostIncrement: 
            case PostDecrement: {
                u = this.applyUnaryOperatorBeforeSpace(u, this.style.getAroundOperators().getUnary());
                break;
            }
            case PreIncrement: 
            case PreDecrement: 
            case Negative: 
            case Positive: 
            case Not: 
            case Complement: {
                u = this.applyUnaryOperatorBeforeSpace(u, this.style.getAroundOperators().getUnary());
                u = this.applyUnaryOperatorExprSpace(u, this.style.getAroundOperators().getUnary());
            }
        }
        return u;
    }

    private J.Unary applyUnaryOperatorExprSpace(J.Unary unary, boolean useAroundUnaryOperatorSpace) {
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)unary.getExpression().getPrefix().getWhitespace())) {
            unary = unary.withExpression((Expression)unary.getExpression().withPrefix(unary.getExpression().getPrefix().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && " ".equals(unary.getExpression().getPrefix().getWhitespace())) {
            unary = unary.withExpression((Expression)unary.getExpression().withPrefix(unary.getExpression().getPrefix().withWhitespace("")));
        }
        return unary;
    }

    private J.Unary applyUnaryOperatorBeforeSpace(J.Unary u, boolean useAroundUnaryOperatorSpace) {
        J.Unary.Padding padding = u.getPadding();
        JLeftPadded operator = padding.getOperator();
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)operator.getBefore().getWhitespace())) {
            u = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && " ".equals(operator.getBefore().getWhitespace())) {
            u = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
        }
        return u;
    }

    @Override
    public K.FunctionType visitFunctionType(K.FunctionType functionType, P p) {
        J kf = super.visitFunctionType(functionType, (Object)p);
        TypedTree tree = kf.getTypedTree();
        if (tree instanceof J.Lambda) {
            J.Lambda l = (J.Lambda)tree;
            l = l.withArrow(this.updateSpace(l.getArrow(), this.style.getOther().getAroundArrowInFunctionTypes()));
            l = l.withBody(this.spaceBefore(l.getBody(), (boolean)this.style.getOther().getAroundArrowInFunctionTypes()));
            kf = kf.withTypedTree((TypedTree)l);
        }
        return kf;
    }

    @Override
    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        boolean omitBraces;
        J.Lambda l = super.visitLambda(lambda, p);
        boolean isFunctionType = Objects.requireNonNull(this.getCursor().getParent()).getValue() instanceof K.FunctionType;
        if (isFunctionType) {
            return lambda;
        }
        boolean useSpaceBeforeLambdaArrow = this.style.getOther().getBeforeLambdaArrow();
        boolean lastParamHasSpace = false;
        List parameters = l.getParameters().getPadding().getParams();
        if (!parameters.isEmpty()) {
            Space after = ((JRightPadded)parameters.get(parameters.size() - 1)).getAfter();
            boolean bl = lastParamHasSpace = after.getComments().isEmpty() && SpacesVisitor.onlySpacesAndNotEmpty(after.getWhitespace());
        }
        if (lastParamHasSpace) {
            parameters = ListUtils.mapLast((List)parameters, rp -> this.spaceAfter((JRightPadded)rp, useSpaceBeforeLambdaArrow));
            l = l.withParameters(l.getParameters().getPadding().withParams(parameters));
        } else {
            l = l.withArrow(this.updateSpace(l.getArrow(), useSpaceBeforeLambdaArrow));
        }
        boolean useSpaceAfterLambdaArrow = true;
        l = l.withBody(this.spaceBefore(l.getBody(), useSpaceAfterLambdaArrow));
        if (!l.getParameters().getParameters().isEmpty() && !(l.getParameters().getParameters().iterator().next() instanceof J.Empty)) {
            int parametersSize = l.getParameters().getParameters().size();
            l = l.withParameters(l.getParameters().getPadding().withParams(ListUtils.map((List)l.getParameters().getPadding().getParams(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement((Object)this.spaceBefore((J)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != parametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            })));
        }
        if (!(omitBraces = l.getMarkers().findFirst(OmitBraces.class).isPresent())) {
            boolean singleLine;
            PrintOutputCapture print = new PrintOutputCapture((Object)0);
            new KotlinPrinter().visitLambda(l, print);
            boolean bl = singleLine = !print.out.toString().contains("\n");
            if (singleLine && !l.getParameters().getParameters().isEmpty()) {
                List params = ListUtils.mapFirst((List)l.getParameters().getParameters(), x -> this.spaceBefore(x, (boolean)this.style.getOther().getInSimpleOneLineMethods()));
                if ((l = l.withParameters(l.getParameters().withParameters(params))).getBody() instanceof J.Block) {
                    J.Block block = (J.Block)l.getBody();
                    block = block.withEnd(this.updateSpace(block.getEnd(), this.style.getOther().getInSimpleOneLineMethods()));
                    l = l.withBody((J)block);
                }
            }
        }
        return l;
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        J.MemberReference m = super.visitMemberReference(memberRef, p);
        if ((m = m.getPadding().withContaining(this.spaceAfter(m.getPadding().getContaining(), false))).getPadding().getTypeParameters() != null) {
            m.getPadding().withTypeParameters(this.spaceBefore(m.getPadding().getTypeParameters(), false, true));
        } else {
            m = m.getPadding().withReference(this.spaceBefore(m.getPadding().getReference(), false));
        }
        return m;
    }

    @Override
    public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J.ArrayAccess a = super.visitArrayAccess(arrayAccess, p);
        if (" ".equals(((Expression)a.getDimension().getPadding().getIndex().getElement()).getPrefix().getWhitespace())) {
            a = a.withDimension(a.getDimension().getPadding().withIndex(a.getDimension().getPadding().getIndex().withElement((Object)((Expression)((Expression)a.getDimension().getPadding().getIndex().getElement()).withPrefix(((Expression)a.getDimension().getPadding().getIndex().getElement()).getPrefix().withWhitespace(""))))));
        }
        if (" ".equals(a.getDimension().getPadding().getIndex().getAfter().getWhitespace())) {
            a = a.withDimension(a.getDimension().getPadding().withIndex(a.getDimension().getPadding().getIndex().withAfter(a.getDimension().getPadding().getIndex().getAfter().withWhitespace(""))));
        }
        return a;
    }

    @Override
    public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
        J.Parentheses p2 = super.visitParentheses(parens, p);
        if (" ".equals(((J)p2.getPadding().getTree().getElement()).getPrefix().getWhitespace())) {
            p2 = p2.getPadding().withTree(p2.getPadding().getTree().withElement((Object)((J)p2.getPadding().getTree().getElement()).withPrefix(((J)p2.getPadding().getTree().getElement()).getPrefix().withWhitespace(""))));
        }
        if (" ".equals(p2.getPadding().getTree().getAfter().getWhitespace())) {
            p2 = p2.getPadding().withTree(p2.getPadding().getTree().withAfter(p2.getPadding().getTree().getAfter().withWhitespace("")));
        }
        return p2;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J.NewClass nc = super.visitNewClass(newClass, p);
        if (nc.getPadding().getArguments() != null) {
            nc = nc.getPadding().withArguments(this.spaceBefore(nc.getPadding().getArguments(), false, true));
            int argsSize = nc.getPadding().getArguments().getElements().size();
            nc = nc.getPadding().withArguments(nc.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)nc.getPadding().getArguments().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement((Object)this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != argsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            })));
        }
        return nc;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue _enum, P p) {
        J.EnumValue e = super.visitEnumValue(_enum, p);
        if (e.getInitializer() != null && e.getInitializer().getPadding().getArguments() != null) {
            int initializerArgumentsSize = e.getInitializer().getPadding().getArguments().getPadding().getElements().size();
            e = e.withInitializer(e.getInitializer().getPadding().withArguments(e.getInitializer().getPadding().getArguments().getPadding().withElements(ListUtils.map((List)e.getInitializer().getPadding().getArguments().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement((Object)this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != initializerArgumentsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            }))));
        }
        return e;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().getRoot().putMessage("stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

