/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class FindRepeatableAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Find uses of `@Repeatable` annotations";
    }

    public String getDescription() {
        return "Java 8 introduced the concept of `@Repeatable` annotations.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                for (JavaType javaType : cu.getTypesInUse().getTypesInUse()) {
                    if (!FindRepeatableAnnotations.isRepeatable(javaType)) continue;
                    return (J)SearchResult.found((Tree)cu);
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (FindRepeatableAnnotations.isRepeatable(annotation.getType())) {
                    return (J)SearchResult.found((Tree)annotation);
                }
                return super.visitAnnotation(annotation, ctx);
            }
        };
    }

    public static boolean isRepeatable(@Nullable JavaType javaType) {
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(javaType);
        if (TypeUtils.isAssignableTo("java.lang.annotation.Annotation", (JavaType)type)) {
            for (JavaType.FullyQualified ann : type.getAnnotations()) {
                if (!TypeUtils.isOfClassType(ann, "java.lang.annotation.Repeatable")) continue;
                return true;
            }
        }
        return false;
    }
}

