/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseStandardCharset
extends Recipe {
    public String getDisplayName() {
        return "Use `StandardCharset` constants";
    }

    public String getDescription() {
        return "Replaces `Charset.forName(java.lang.String)` with the equivalent `StandardCharset` constant.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.nio.charset.Charset");
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new UseStandardCharsetVisitor();
    }

    private static class UseStandardCharsetVisitor
    extends JavaVisitor<ExecutionContext> {
        MethodMatcher CHARSET_FOR_NAME = new MethodMatcher("java.nio.charset.Charset forName(java.lang.String)");

        private UseStandardCharsetVisitor() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            String maybeReplace;
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
            if (this.CHARSET_FOR_NAME.matches(m) && (maybeReplace = (String)((J.Literal)m.getArguments().get(0)).getValue()) != null) {
                Charset charset;
                this.maybeAddImport("java.nio.charset.StandardCharsets");
                try {
                    charset = Charset.forName(maybeReplace);
                }
                catch (UnsupportedCharsetException ex) {
                    return method;
                }
                String standardName = "";
                if (charset == StandardCharsets.ISO_8859_1) {
                    standardName = "ISO_8859_1";
                } else if (charset == StandardCharsets.US_ASCII) {
                    standardName = "US_ASCII";
                } else if (charset == StandardCharsets.UTF_8) {
                    standardName = "UTF_8";
                } else if (charset == StandardCharsets.UTF_16) {
                    standardName = "UTF_16";
                } else if (charset == StandardCharsets.UTF_16BE) {
                    standardName = "UTF_16BE";
                } else if (charset == StandardCharsets.UTF_16LE) {
                    standardName = "UTF_16LE";
                }
                if (!StringUtils.isBlank((String)standardName)) {
                    return m.withTemplate(JavaTemplate.builder(() -> ((UseStandardCharsetVisitor)this).getCursor(), "StandardCharsets." + standardName).imports("java.nio.charset.StandardCharsets").build(), m.getCoordinates().replace(), new Object[0]);
                }
            }
            return m;
        }
    }
}

