/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;

public class SimplifyCompoundVisitor<P>
extends JavaVisitor<P> {
    @Override
    @Nullable
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        Expression cleanedUpAssignment = this.cleanupBooleanExpression(assignOp.getAssignment(), p);
        if (assignOp.getOperator() == J.AssignmentOperation.Type.BitAnd) {
            if (SimplifyCompoundVisitor.isLiteralTrue(cleanedUpAssignment)) {
                return null;
            }
            if (SimplifyCompoundVisitor.isLiteralFalse(cleanedUpAssignment)) {
                return this.maybeAutoFormat(assignOp, new J.Assignment(Tree.randomId(), assignOp.getPrefix(), assignOp.getMarkers(), assignOp.getVariable(), JLeftPadded.build(cleanedUpAssignment), assignOp.getType()), p);
            }
        } else if (assignOp.getOperator() == J.AssignmentOperation.Type.BitOr) {
            if (SimplifyCompoundVisitor.isLiteralFalse(cleanedUpAssignment)) {
                return null;
            }
            if (SimplifyCompoundVisitor.isLiteralTrue(cleanedUpAssignment)) {
                return this.maybeAutoFormat(assignOp, new J.Assignment(Tree.randomId(), assignOp.getPrefix(), assignOp.getMarkers(), assignOp.getVariable(), JLeftPadded.build(cleanedUpAssignment), assignOp.getType()), p);
            }
        }
        return super.visitAssignmentOperation(assignOp, p);
    }

    private <E extends Expression> E cleanupBooleanExpression(E expression, P context) {
        Expression ex1 = (Expression)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(expression, context, this.getCursor().getParentOrThrow());
        Expression ex2 = (Expression)new SimplifyBooleanExpressionVisitor().visitNonNull(ex1, context, this.getCursor().getParentOrThrow());
        return (E)ex2;
    }

    private static boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private static boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }
}

