/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.ChainStringBuilderAppendCalls;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ReplaceDeprecatedRuntimeExecMethods
extends Recipe {
    private static final MethodMatcher RUNTIME_EXEC_CMD = new MethodMatcher("java.lang.Runtime exec(String)");
    private static final MethodMatcher RUNTIME_EXEC_CMD_ENVP = new MethodMatcher("java.lang.Runtime exec(String, String[])");
    private static final MethodMatcher RUNTIME_EXEC_CMD_ENVP_FILE = new MethodMatcher("java.lang.Runtime exec(String, String[], java.io.File)");

    public String getDisplayName() {
        return "Replace deprecated Runtime.Exec() methods";
    }

    public String getDescription() {
        return "Replace Runtime.exec(String) methods to use exec(String[]) instead because the former is deprecated after java 18 and no longer recommended for use by the Java documentation.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesJavaVersion<ExecutionContext>(18);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J m = super.visitMethodInvocation(method, executionContext);
                if (RUNTIME_EXEC_CMD.matches((J.MethodInvocation)m) || RUNTIME_EXEC_CMD_ENVP.matches((J.MethodInvocation)m) || RUNTIME_EXEC_CMD_ENVP_FILE.matches((J.MethodInvocation)m)) {
                    Expression command = ((J.MethodInvocation)m).getArguments().get(0);
                    ArrayList<Expression> commands = new ArrayList<Expression>();
                    boolean flattenAble = ChainStringBuilderAppendCalls.flatAdditiveExpressions(command, commands);
                    StringBuilder sb = new StringBuilder();
                    if (flattenAble) {
                        for (Expression e : commands) {
                            if (e instanceof J.Literal && ((J.Literal)e).getType() == JavaType.Primitive.String) {
                                sb.append(((J.Literal)e).getValue());
                                continue;
                            }
                            flattenAble = false;
                            break;
                        }
                    }
                    if (flattenAble) {
                        String[] cmds = sb.toString().split(" ");
                        String templateCode = String.format("new String[] {%s}", ReplaceDeprecatedRuntimeExecMethods.toStringArguments(cmds));
                        JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), templateCode).build();
                        List<Expression> args = ((J.MethodInvocation)m).getArguments();
                        args.set(0, (Expression)args.get(0).withTemplate(template, args.get(0).getCoordinates().replace(), new Object[0]));
                        List<JavaType> parameterTypes = ((J.MethodInvocation)m).getMethodType().getParameterTypes();
                        parameterTypes.set(0, JavaType.ShallowClass.build("java.lang.String[]"));
                        return ((J.MethodInvocation)((J.MethodInvocation)m).withArguments((List)args)).withMethodType(((J.MethodInvocation)m).getMethodType().withParameterTypes(parameterTypes));
                    }
                    List<Expression> args = ((J.MethodInvocation)m).getArguments();
                    boolean needWrap = false;
                    Expression arg0 = args.get(0);
                    if (!(arg0 instanceof J.Identifier || arg0 instanceof J.Literal || arg0 instanceof J.MethodInvocation)) {
                        needWrap = true;
                    }
                    String code = needWrap ? "(#{any()}).split(\" \")" : "#{any()}.split(\" \")";
                    JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), code).build();
                    arg0 = (Expression)args.get(0).withTemplate(template, args.get(0).getCoordinates().replace(), args.get(0));
                    args.set(0, arg0);
                    List<JavaType> parameterTypes = ((J.MethodInvocation)m).getMethodType().getParameterTypes();
                    parameterTypes.set(0, JavaType.ShallowClass.build("java.lang.String[]"));
                    return ((J.MethodInvocation)((J.MethodInvocation)m).withArguments((List)args)).withMethodType(((J.MethodInvocation)m).getMethodType().withParameterTypes(parameterTypes));
                }
                return m;
            }
        };
    }

    private static String toStringArguments(String[] cmds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmds.length; ++i) {
            String token = cmds[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"").append(token).append("\"");
        }
        return sb.toString();
    }
}

