/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveUnusedPrivateFields
extends Recipe {
    public String getDisplayName() {
        return "Remove unused private fields";
    }

    public String getDescription() {
        return "If a private field is declared but not used in the program, it can be considered dead code and should therefore be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1068");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J cd = super.visitClassDeclaration(classDecl, executionContext);
                ArrayList<J.VariableDeclarations> checkFields = new ArrayList<J.VariableDeclarations>();
                boolean skipSerialVersionUID = ((J.ClassDeclaration)cd).getType() == null || ((J.ClassDeclaration)cd).getType().isAssignableTo("java.io.Serializable");
                for (Statement statement : ((J.ClassDeclaration)cd).getBody().getStatements()) {
                    J.MethodDeclaration md;
                    if (statement instanceof J.VariableDeclarations) {
                        J.VariableDeclarations vd = (J.VariableDeclarations)statement;
                        if (skipSerialVersionUID && this.isSerialVersionUid(vd) || !vd.getLeadingAnnotations().isEmpty() || !vd.hasModifier(J.Modifier.Type.Private)) continue;
                        checkFields.add(vd);
                        continue;
                    }
                    if (!(statement instanceof J.MethodDeclaration) || !(md = (J.MethodDeclaration)statement).hasModifier(J.Modifier.Type.Native)) continue;
                    return cd;
                }
                if (checkFields.isEmpty()) {
                    return cd;
                }
                for (J.VariableDeclarations fields : checkFields) {
                    Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> inUse = VariableUses.find(fields, (J.ClassDeclaration)cd);
                    for (Map.Entry<J.VariableDeclarations.NamedVariable, List<J.Identifier>> entry : inUse.entrySet()) {
                        if (!entry.getValue().isEmpty()) continue;
                        cd = (J.ClassDeclaration)new RemoveUnusedField(entry.getKey()).visitNonNull(cd, executionContext);
                    }
                }
                return cd;
            }

            private boolean isSerialVersionUid(J.VariableDeclarations vd) {
                return vd.hasModifier(J.Modifier.Type.Private) && vd.hasModifier(J.Modifier.Type.Static) && vd.hasModifier(J.Modifier.Type.Final) && TypeUtils.isOfClassType(vd.getType(), "long") && vd.getVariables().stream().anyMatch(it -> "serialVersionUID".equals(it.getSimpleName()));
            }
        };
    }

    @NonNull
    public String toString() {
        return "RemoveUnusedPrivateFields()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedPrivateFields)) {
            return false;
        }
        RemoveUnusedPrivateFields other = (RemoveUnusedPrivateFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveUnusedPrivateFields;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class RemoveUnusedField
    extends JavaVisitor<ExecutionContext> {
        private final J.VariableDeclarations.NamedVariable namedVariable;

        public RemoveUnusedField(J.VariableDeclarations.NamedVariable namedVariable) {
            this.namedVariable = namedVariable;
        }

        @Override
        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
            if (multiVariable.getVariables().size() == 1 && multiVariable.getVariables().contains(this.namedVariable)) {
                return null;
            }
            return super.visitVariableDeclarations(multiVariable, executionContext);
        }

        @Override
        public J visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
            if (variable == this.namedVariable) {
                return null;
            }
            return super.visitVariable(variable, executionContext);
        }
    }

    private static class VariableUses {
        private VariableUses() {
        }

        public static Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> find(final J.VariableDeclarations declarations, J.ClassDeclaration parent) {
            IdentityHashMap<J.VariableDeclarations.NamedVariable, List<J.Identifier>> found = new IdentityHashMap<J.VariableDeclarations.NamedVariable, List<J.Identifier>>(declarations.getVariables().size());
            final HashMap<String, J.VariableDeclarations.NamedVariable> signatureMap = new HashMap<String, J.VariableDeclarations.NamedVariable>();
            for (J.VariableDeclarations.NamedVariable variable : declarations.getVariables()) {
                if (variable.getVariableType() == null) continue;
                found.computeIfAbsent(variable, k -> new ArrayList());
                signatureMap.put(variable.getVariableType().toString(), variable);
            }
            JavaIsoVisitor<Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>>> visitor = new JavaIsoVisitor<Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>>>(){

                @Override
                public J.Identifier visitIdentifier(J.Identifier identifier, Map<J.VariableDeclarations.NamedVariable, List<J.Identifier>> identifiers) {
                    Cursor parent;
                    if (identifier.getFieldType() != null && signatureMap.containsKey(identifier.getFieldType().toString()) && (!((parent = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.ClassDeclaration)).getValue() instanceof J.VariableDeclarations) || parent.getValue() != declarations)) {
                        J.VariableDeclarations.NamedVariable name = (J.VariableDeclarations.NamedVariable)signatureMap.get(identifier.getFieldType().toString());
                        if (declarations.getVariables().contains(name)) {
                            J.VariableDeclarations.NamedVariable used = (J.VariableDeclarations.NamedVariable)signatureMap.get(identifier.getFieldType().toString());
                            identifiers.computeIfAbsent(used, k -> new ArrayList()).add(identifier);
                        }
                    }
                    return super.visitIdentifier(identifier, identifiers);
                }
            };
            visitor.visit(parent, found);
            return found;
        }
    }
}

