/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class RemoveImplements
extends Recipe {
    @Option(displayName="Interface Type", description="The fully qualified name of the interface to remove.", example="java.io.Serializable")
    private final String interfaceType;
    @Option(displayName="Filter", description="Only apply the interface removal to classes with fully qualified names that begin with this filter. `null` or empty matches all classes.", example="com.yourorg.")
    @Nullable
    private final String filter;

    public String getDisplayName() {
        return "Remove interface implementations";
    }

    public String getDescription() {
        return "Removes `implements` clauses from classes implementing the specified interface. Removes `@Overrides` annotations from methods which no longer override anything.";
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDeclaration, ctx);
                if (!(((J.ClassDeclaration)cd).getType() instanceof JavaType.Class) || ((J.ClassDeclaration)cd).getImplements() == null) {
                    return cd;
                }
                JavaType.Class cdt = (JavaType.Class)((J.ClassDeclaration)cd).getType();
                if ((RemoveImplements.this.filter == null || cdt.getFullyQualifiedName().startsWith(RemoveImplements.this.filter)) && cdt.getInterfaces().stream().anyMatch(it -> TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType))) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)"");
                }
                return cd;
            }
        };
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                if (!(cd.getType() instanceof JavaType.Class) || cd.getImplements() == null) {
                    return super.visitClassDeclaration(cd, ctx);
                }
                JavaType.Class cdt = (JavaType.Class)cd.getType();
                if ((RemoveImplements.this.filter == null || cdt.getFullyQualifiedName().startsWith(RemoveImplements.this.filter)) && cdt.getInterfaces().stream().anyMatch(it -> TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType))) {
                    cd = cd.withImplements(cd.getImplements().stream().filter(implement -> !TypeUtils.isOfClassType(implement.getType(), RemoveImplements.this.interfaceType)).collect(Collectors.toList()));
                    cdt = cdt.withInterfaces(cdt.getInterfaces().stream().filter(it -> !TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType)).collect(Collectors.toList()));
                    cd = cd.withType(cdt);
                    this.maybeRemoveImport(RemoveImplements.this.interfaceType);
                    this.getCursor().putMessage(cdt.getFullyQualifiedName(), (Object)cdt);
                }
                return super.visitClassDeclaration(cd, ctx);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext context) {
                if (md.getMethodType() == null) {
                    return super.visitMethodDeclaration(md, context);
                }
                Object maybeClassType = this.getCursor().getNearestMessage(md.getMethodType().getDeclaringType().getFullyQualifiedName());
                if (!(maybeClassType instanceof JavaType.Class)) {
                    return super.visitMethodDeclaration(md, context);
                }
                JavaType.Class cdt = (JavaType.Class)maybeClassType;
                if ((md = md.withMethodType(md.getMethodType().withDeclaringType(cdt))).getAllAnnotations().stream().noneMatch(ann -> TypeUtils.isOfClassType(ann.getType(), "java.lang.Override")) || TypeUtils.isOverride(md.getMethodType())) {
                    return super.visitMethodDeclaration(md, context);
                }
                md = (J.MethodDeclaration)new RemoveAnnotation("@java.lang.Override").getVisitor().visitNonNull(md, context, this.getCursor().getParentOrThrow());
                return super.visitMethodDeclaration(md, context);
            }
        };
    }

    public RemoveImplements(String interfaceType, @Nullable String filter) {
        this.interfaceType = interfaceType;
        this.filter = filter;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @NonNull
    public String toString() {
        return "RemoveImplements(interfaceType=" + this.getInterfaceType() + ", filter=" + this.getFilter() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImplements)) {
            return false;
        }
        RemoveImplements other = (RemoveImplements)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$interfaceType = this.getInterfaceType();
        String other$interfaceType = other.getInterfaceType();
        if (this$interfaceType == null ? other$interfaceType != null : !this$interfaceType.equals(other$interfaceType)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveImplements;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $interfaceType = this.getInterfaceType();
        result = result * 59 + ($interfaceType == null ? 43 : $interfaceType.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

