/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.internal.StringUtils;

public class StyleHelper {
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet();

    private static boolean isPrimitiveOrWrapper(Object value) {
        Class<?> type = value.getClass();
        return type.isPrimitive() || primitiveWrapperClasses.contains(type);
    }

    private static boolean isEnum(Object value) {
        Class<?> type = value.getClass();
        return type.isEnum();
    }

    public static <T> T merge(T left, T right) {
        Class<?> styleClass = left.getClass();
        if (right.getClass() != styleClass) {
            throw new RuntimeException(left.getClass().getName() + " and " + right.getClass().getName() + " should match exactly.");
        }
        for (Field f : styleClass.getDeclaredFields()) {
            Method getter;
            Method wither;
            try {
                wither = styleClass.getMethod("with" + StringUtils.capitalize(f.getName()), f.getType());
                getter = styleClass.getMethod("get" + StringUtils.capitalize(f.getName()), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                Object rightValue = getter.invoke(right, new Object[0]);
                if (rightValue == null) continue;
                if (!StyleHelper.isPrimitiveOrWrapper(rightValue) && !StyleHelper.isEnum(rightValue)) {
                    Object leftValue = getter.invoke(left, new Object[0]);
                    rightValue = StyleHelper.merge(leftValue, rightValue);
                }
                left = wither.invoke(left, rightValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return left;
    }

    static {
        primitiveWrapperClasses.add(Double.class);
        primitiveWrapperClasses.add(Float.class);
        primitiveWrapperClasses.add(Long.class);
        primitiveWrapperClasses.add(Integer.class);
        primitiveWrapperClasses.add(Short.class);
        primitiveWrapperClasses.add(Character.class);
        primitiveWrapperClasses.add(Byte.class);
        primitiveWrapperClasses.add(Boolean.class);
    }
}

