/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class RecipeRunStats
extends DataTable<Row> {
    public RecipeRunStats(Recipe recipe) {
        super(recipe, "Recipe performance", "Statistics used in analyzing the performance of recipes.");
    }

    public void record(ExecutionContext ctx, Recipe recipe, org.openrewrite.RecipeRunStats runStats) {
        this.insertRow(ctx, new Row(runStats.getRecipe().getName(), runStats.getCalls(), runStats.getCumulative().toNanos(), runStats.getMax().toNanos(), runStats.getOwnGetVisitor().toNanos(), runStats.getOwnVisit().toNanos()));
        for (org.openrewrite.RecipeRunStats called : runStats.getCalled()) {
            this.record(ctx, recipe, called);
        }
    }

    public static final class Row {
        @Column(displayName="Recipe that made changes", description="The specific recipe that made a change.")
        private final String recipe;
        @Column(displayName="Calls", description="The number of times the recipe ran over all cycles.")
        private final Integer calls;
        @Column(displayName="Cumulative time", description="The total time spent across all executions of this recipe in nanoseconds.")
        private final Long cumulative;
        @Column(displayName="Max time", description="The max time spent in any one execution of this recipe in nanoseconds.")
        private final Long max;
        @Column(displayName="Time running `getVisitor()`", description="The total time spent in running the visitor returned by `Recipe#getVisitor()` for this recipe.")
        private final Long ownGetVisitor;
        @Column(displayName="Time running `visit()`", description="The total time spent in running `Recipe#visit()` for this recipe.")
        private final Long ownVisit;

        public Row(String recipe, Integer calls, Long cumulative, Long max, Long ownGetVisitor, Long ownVisit) {
            this.recipe = recipe;
            this.calls = calls;
            this.cumulative = cumulative;
            this.max = max;
            this.ownGetVisitor = ownGetVisitor;
            this.ownVisit = ownVisit;
        }

        public String getRecipe() {
            return this.recipe;
        }

        public Integer getCalls() {
            return this.calls;
        }

        public Long getCumulative() {
            return this.cumulative;
        }

        public Long getMax() {
            return this.max;
        }

        public Long getOwnGetVisitor() {
            return this.ownGetVisitor;
        }

        public Long getOwnVisit() {
            return this.ownVisit;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$calls = this.getCalls();
            Integer other$calls = other.getCalls();
            if (this$calls == null ? other$calls != null : !((Object)this$calls).equals(other$calls)) {
                return false;
            }
            Long this$cumulative = this.getCumulative();
            Long other$cumulative = other.getCumulative();
            if (this$cumulative == null ? other$cumulative != null : !((Object)this$cumulative).equals(other$cumulative)) {
                return false;
            }
            Long this$max = this.getMax();
            Long other$max = other.getMax();
            if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                return false;
            }
            Long this$ownGetVisitor = this.getOwnGetVisitor();
            Long other$ownGetVisitor = other.getOwnGetVisitor();
            if (this$ownGetVisitor == null ? other$ownGetVisitor != null : !((Object)this$ownGetVisitor).equals(other$ownGetVisitor)) {
                return false;
            }
            Long this$ownVisit = this.getOwnVisit();
            Long other$ownVisit = other.getOwnVisit();
            if (this$ownVisit == null ? other$ownVisit != null : !((Object)this$ownVisit).equals(other$ownVisit)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $calls = this.getCalls();
            result = result * 59 + ($calls == null ? 43 : ((Object)$calls).hashCode());
            Long $cumulative = this.getCumulative();
            result = result * 59 + ($cumulative == null ? 43 : ((Object)$cumulative).hashCode());
            Long $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            Long $ownGetVisitor = this.getOwnGetVisitor();
            result = result * 59 + ($ownGetVisitor == null ? 43 : ((Object)$ownGetVisitor).hashCode());
            Long $ownVisit = this.getOwnVisit();
            result = result * 59 + ($ownVisit == null ? 43 : ((Object)$ownVisit).hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RecipeRunStats.Row(recipe=" + this.getRecipe() + ", calls=" + this.getCalls() + ", cumulative=" + this.getCumulative() + ", max=" + this.getMax() + ", ownGetVisitor=" + this.getOwnGetVisitor() + ", ownVisit=" + this.getOwnVisit() + ")";
        }
    }
}

