/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.merge;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.util.ChangeIdUtil;
import org.openrewrite.shaded.jgit.util.StringUtils;

public class MergeMessageFormatter {
    public String format(List<Ref> refsToMerge, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Merge ");
        ArrayList<String> branches = new ArrayList<String>();
        ArrayList<String> remoteBranches = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> commits = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        for (Ref ref : refsToMerge) {
            if (ref.getName().startsWith("refs/heads/")) {
                branches.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            if (ref.getName().startsWith("refs/remotes/")) {
                remoteBranches.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            if (ref.getName().startsWith("refs/tags/")) {
                tags.add("'" + Repository.shortenRefName(ref.getName()) + "'");
                continue;
            }
            ObjectId objectId = ref.getObjectId();
            if (objectId != null && ref.getName().equals(objectId.getName())) {
                commits.add("'" + ref.getName() + "'");
                continue;
            }
            others.add(ref.getName());
        }
        ArrayList<String> listings = new ArrayList<String>();
        if (!branches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(branches, "branch", "branches"));
        }
        if (!remoteBranches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(remoteBranches, "remote-tracking branch", "remote-tracking branches"));
        }
        if (!tags.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(tags, "tag", "tags"));
        }
        if (!commits.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(commits, "commit", "commits"));
        }
        if (!others.isEmpty()) {
            listings.add(StringUtils.join(others, ", ", " and "));
        }
        sb.append(StringUtils.join(listings, ", "));
        String targetName = target.getLeaf().getName();
        if (!targetName.equals("refs/heads/master")) {
            String targetShortName = Repository.shortenRefName(targetName);
            sb.append(" into " + targetShortName);
        }
        return sb.toString();
    }

    public String formatWithConflicts(String message, List<String> conflictingPaths) {
        StringBuilder sb = new StringBuilder();
        String[] lines = message.split("\n");
        int firstFooterLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        int i = 0;
        while (i < firstFooterLine) {
            sb.append(lines[i]).append('\n');
            ++i;
        }
        if (firstFooterLine == lines.length && message.length() != 0) {
            sb.append('\n');
        }
        MergeMessageFormatter.addConflictsMessage(conflictingPaths, sb);
        if (firstFooterLine < lines.length) {
            sb.append('\n');
        }
        i = firstFooterLine;
        while (i < lines.length) {
            sb.append(lines[i]).append('\n');
            ++i;
        }
        return sb.toString();
    }

    private static void addConflictsMessage(List<String> conflictingPaths, StringBuilder sb) {
        sb.append("Conflicts:\n");
        for (String conflictingPath : conflictingPaths) {
            sb.append('\t').append(conflictingPath).append('\n');
        }
    }

    private static String joinNames(List<String> names, String singular, String plural) {
        if (names.size() == 1) {
            return String.valueOf(singular) + " " + names.get(0);
        }
        return String.valueOf(plural) + " " + StringUtils.join(names, ", ", " and ");
    }
}

