/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.util.HashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.table.LanguageComposition;

public class FindLanguageComposition
extends Recipe {
    transient LanguageComposition composition = new LanguageComposition(this);

    @Override
    public String getDisplayName() {
        return "Find language composition";
    }

    @Override
    public String getDescription() {
        return "Produce a table of files and their language composition.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    HashSet ids = new HashSet();
                    FindLanguageComposition.this.composition.insertRow(ctx, new LanguageComposition.Row(sourceFile.getSourcePath().toString(), sourceFile.getClass().getSimpleName(), sourceFile.getWeight(id -> ids.add(System.identityHashCode(id))), (int)sourceFile.printAll().chars().filter(c -> c == 10).count()));
                }
                return tree;
            }
        };
    }
}

