/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import org.intellij.lang.annotations.Language;
import org.openrewrite.FileAttributes;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.Remote;

public final class RemoteFile
implements Remote {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final URI uri;
    @Nullable
    private final Charset charset;
    private final boolean charsetBomMarked;
    @Nullable
    private final FileAttributes fileAttributes;
    @Language(value="markdown")
    private final String description;

    @Override
    public <P> byte[] printAllAsBytes(P p) {
        return new HttpUrlConnectionSender().get(this.uri.toString()).send().getBodyAsBytes();
    }

    @Override
    public InputStream getInputStream(HttpSender httpSender) {
        return httpSender.get(this.uri.toString()).send().getBody();
    }

    public RemoteFile(UUID id, Path sourcePath, Markers markers, URI uri, @Nullable Charset charset, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Language(value="markdown") String description) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.uri = uri;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.description = description;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String toString() {
        return "RemoteFile(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", uri=" + this.getUri() + ", charset=" + this.getCharset() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", description=" + this.getDescription() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFile)) {
            return false;
        }
        RemoteFile other = (RemoteFile)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public RemoteFile withId(UUID id) {
        return this.id == id ? this : new RemoteFile(id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new RemoteFile(this.id, sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withMarkers(Markers markers) {
        return this.markers == markers ? this : new RemoteFile(this.id, this.sourcePath, markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withUri(URI uri) {
        return this.uri == uri ? this : new RemoteFile(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withCharset(@Nullable Charset charset) {
        return this.charset == charset ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, charset, this.charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, charsetBomMarked, this.fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, fileAttributes, this.description);
    }

    @NonNull
    public RemoteFile withDescription(@Language(value="markdown") String description) {
        return this.description == description ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, description);
    }
}

