/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quark;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.QuarkPrinter;
import org.openrewrite.quark.QuarkVisitor;

public final class Quark
implements SourceFile {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    @Nullable
    private final Checksum checksum;
    @Nullable
    private final FileAttributes fileAttributes;

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(QuarkVisitor.class);
    }

    @Override
    @Nullable
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)v.adapt(QuarkVisitor.class).visitQuark(this, p);
    }

    @Override
    public Charset getCharset() {
        throw new UnsupportedOperationException("The contents of a quark are unknown, so the charset is unknown.");
    }

    public SourceFile withCharset(Charset charset) {
        throw new UnsupportedOperationException("The contents of a quark are unknown, so the charset is unknown.");
    }

    @Override
    public boolean isCharsetBomMarked() {
        throw new UnsupportedOperationException("The contents of a quark are unknown, so the charset is unknown.");
    }

    public SourceFile withCharsetBomMarked(boolean marked) {
        throw new UnsupportedOperationException("The contents of a quark are unknown, so the charset is unknown.");
    }

    @Override
    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new QuarkPrinter();
    }

    public Quark(UUID id, Path sourcePath, Markers markers, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.checksum = checksum;
        this.fileAttributes = fileAttributes;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quark)) {
            return false;
        }
        Quark other = (Quark)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        FileAttributes this$fileAttributes = this.getFileAttributes();
        FileAttributes other$fileAttributes = other.getFileAttributes();
        return !(this$fileAttributes == null ? other$fileAttributes != null : !((Object)this$fileAttributes).equals(other$fileAttributes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        FileAttributes $fileAttributes = this.getFileAttributes();
        result = result * 59 + ($fileAttributes == null ? 43 : ((Object)$fileAttributes).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Quark(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", checksum=" + this.getChecksum() + ", fileAttributes=" + this.getFileAttributes() + ")";
    }

    @NonNull
    public Quark withId(UUID id) {
        return this.id == id ? this : new Quark(id, this.sourcePath, this.markers, this.checksum, this.fileAttributes);
    }

    @NonNull
    public Quark withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new Quark(this.id, sourcePath, this.markers, this.checksum, this.fileAttributes);
    }

    @NonNull
    public Quark withMarkers(Markers markers) {
        return this.markers == markers ? this : new Quark(this.id, this.sourcePath, markers, this.checksum, this.fileAttributes);
    }

    @NonNull
    public Quark withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new Quark(this.id, this.sourcePath, this.markers, checksum, this.fileAttributes);
    }

    @NonNull
    public Quark withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new Quark(this.id, this.sourcePath, this.markers, this.checksum, fileAttributes);
    }
}

