/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class DeclarativeRecipe
extends CompositeRecipe {
    private final String name;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final String description;
    private final Set<String> tags;
    @Nullable
    private final Duration estimatedEffortPerOccurrence;
    private final URI source;
    private final Map<RecipeUse, List<Recipe>> uninitializedRecipes = new HashMap<RecipeUse, List<Recipe>>();
    private final boolean causesAnotherCycle;
    @JsonIgnore
    private Validated validation = Validated.test("initialization", "initialize(..) must be called on DeclarativeRecipe prior to use.", this, r -> this.uninitializedRecipes.isEmpty());

    @Override
    public boolean causesAnotherCycle() {
        return this.causesAnotherCycle || super.causesAnotherCycle();
    }

    public void initialize(Collection<Recipe> availableRecipes) {
        for (Map.Entry<RecipeUse, List<Recipe>> recipesByUse : this.uninitializedRecipes.entrySet()) {
            for (int i = 0; i < recipesByUse.getValue().size(); ++i) {
                Recipe recipe = recipesByUse.getValue().get(i);
                if (recipe instanceof LazyLoadedRecipe) {
                    String recipeFqn = ((LazyLoadedRecipe)recipe).getRecipeFqn();
                    Optional<Recipe> next = availableRecipes.stream().filter(r -> r.getName().equals(recipeFqn)).findAny();
                    if (next.isPresent()) {
                        this.configureByUse(recipesByUse.getKey(), next.get());
                        continue;
                    }
                    String useProperty = "";
                    switch (recipesByUse.getKey()) {
                        case SingleSourceApplicability: {
                            useProperty = "applicability.singleSource";
                            break;
                        }
                        case AnySourceApplicability: {
                            useProperty = "applicability.anySource";
                            break;
                        }
                        case Recipe: {
                            useProperty = "recipeList";
                        }
                    }
                    this.validation = this.validation.and(Validated.invalid(this.name + "." + useProperty + "[" + i + "] (in " + this.source + ")", recipeFqn, "recipe '" + recipeFqn + "' does not exist.", null));
                    continue;
                }
                this.configureByUse(recipesByUse.getKey(), recipe);
            }
        }
        this.uninitializedRecipes.clear();
    }

    private void configureByUse(RecipeUse use, Recipe recipe) {
        switch (use) {
            case SingleSourceApplicability: {
                this.addSingleSourceApplicableTest(recipe);
                break;
            }
            case AnySourceApplicability: {
                this.addApplicableTest(recipe);
                break;
            }
            case Recipe: {
                this.doNext(recipe);
            }
        }
    }

    public void addUninitialized(RecipeUse use, Recipe recipe) {
        this.uninitializedRecipes.computeIfAbsent(use, u -> new ArrayList()).add(recipe);
    }

    public void addUninitialized(RecipeUse use, String recipeName, @Nullable ClassLoader classLoader) {
        try {
            this.uninitializedRecipes.computeIfAbsent(use, u -> new ArrayList()).add((Recipe)Class.forName(recipeName, true, classLoader != null ? classLoader : this.getClass().getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            this.uninitializedRecipes.computeIfAbsent(use, u -> new ArrayList()).add(new LazyLoadedRecipe(recipeName));
        }
    }

    public void addValidation(Validated validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated validate() {
        return this.validation;
    }

    public DeclarativeRecipe(String name, @Language(value="markdown") String displayName, @Language(value="markdown") String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, URI source, boolean causesAnotherCycle) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.source = source;
        this.causesAnotherCycle = causesAnotherCycle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    private static final class LazyLoadedRecipe
    extends Recipe {
        private final String recipeFqn;

        @Override
        public String getDisplayName() {
            return "Lazy loaded recipe";
        }

        public LazyLoadedRecipe(String recipeFqn) {
            this.recipeFqn = recipeFqn;
        }

        public String getRecipeFqn() {
            return this.recipeFqn;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.LazyLoadedRecipe(recipeFqn=" + this.getRecipeFqn() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LazyLoadedRecipe)) {
                return false;
            }
            LazyLoadedRecipe other = (LazyLoadedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$recipeFqn = this.getRecipeFqn();
            String other$recipeFqn = other.getRecipeFqn();
            return !(this$recipeFqn == null ? other$recipeFqn != null : !this$recipeFqn.equals(other$recipeFqn));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof LazyLoadedRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $recipeFqn = this.getRecipeFqn();
            result = result * 59 + ($recipeFqn == null ? 43 : $recipeFqn.hashCode());
            return result;
        }
    }

    public static enum RecipeUse {
        SingleSourceApplicability,
        AnySourceApplicability,
        Recipe;

    }
}

