/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.util.time;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ProposedTimestamp
implements AutoCloseable {
    public static void blockUntil(Iterable<ProposedTimestamp> times, Duration maxWait) throws TimeoutException, InterruptedException {
        Iterator<ProposedTimestamp> itr = times.iterator();
        if (!itr.hasNext()) {
            return;
        }
        long now = System.currentTimeMillis();
        long deadline = now + maxWait.toMillis();
        while (true) {
            long w;
            if ((w = deadline - now) < 0L) {
                throw new TimeoutException();
            }
            itr.next().blockUntil(Duration.ofMillis(w));
            if (!itr.hasNext()) break;
            now = System.currentTimeMillis();
        }
    }

    public abstract long read(TimeUnit var1);

    public abstract void blockUntil(Duration var1) throws InterruptedException, TimeoutException;

    public long millis() {
        return this.read(TimeUnit.MILLISECONDS);
    }

    public long micros() {
        return this.read(TimeUnit.MICROSECONDS);
    }

    public Instant instant() {
        long usec = this.micros();
        long secs = usec / 1000000L;
        long nanos = usec % 1000000L * 1000L;
        return Instant.ofEpochSecond(secs, nanos);
    }

    public Timestamp timestamp() {
        return Timestamp.from(this.instant());
    }

    public Date date() {
        return new Date(this.millis());
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.instant().toString();
    }
}

