/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.ci.BuildEnvironment;

public final class GitlabBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildId;
    private final String buildUrl;
    private final String host;
    private final String job;

    public static GitlabBuildEnvironment build(UnaryOperator<String> environment) {
        return new GitlabBuildEnvironment(Tree.randomId(), (String)environment.apply("CI_BUILD_ID"), (String)environment.apply("CI_JOB_URL"), (String)environment.apply("CI_SERVER_HOST"), (String)environment.apply("CI_BUILD_NAME"));
    }

    public GitlabBuildEnvironment(UUID id, String buildId, String buildUrl, String host, String job) {
        this.id = id;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.host = host;
        this.job = job;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    @NonNull
    public String toString() {
        return "GitlabBuildEnvironment(id=" + this.getId() + ", buildId=" + this.getBuildId() + ", buildUrl=" + this.getBuildUrl() + ", host=" + this.getHost() + ", job=" + this.getJob() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitlabBuildEnvironment)) {
            return false;
        }
        GitlabBuildEnvironment other = (GitlabBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        return !(this$job == null ? other$job != null : !this$job.equals(other$job));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        return result;
    }

    @NonNull
    public GitlabBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new GitlabBuildEnvironment(id, this.buildId, this.buildUrl, this.host, this.job);
    }
}

