/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.SourcesFiles;

public final class FindSourceFiles
extends Recipe {
    private final transient SourcesFiles results = new SourcesFiles(this);
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root).", example=".github/workflows/*.yml")
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Find files";
    }

    @Override
    public String getDescription() {
        return "Find files by source path.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                String sourcePath;
                if (tree instanceof SourceFile && StringUtils.matchesGlob((sourcePath = (sourceFile = (SourceFile)tree).getSourcePath().toString()).matches("^\\.?[/\\\\]") ? sourcePath : "./" + sourcePath, FindSourceFiles.this.filePattern)) {
                    FindSourceFiles.this.results.insertRow(ctx, new SourcesFiles.Row(sourcePath));
                    return SearchResult.found(sourceFile);
                }
                return tree;
            }
        };
    }

    public FindSourceFiles(String filePattern) {
        this.filePattern = filePattern;
    }

    public SourcesFiles getResults() {
        return this.results;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "FindSourceFiles(results=" + this.getResults() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindSourceFiles)) {
            return false;
        }
        FindSourceFiles other = (FindSourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindSourceFiles;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

