/*
 * Decompiled with CFR 0.152.
 */
package org.nield.kotlinstatistics.range;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.nield.kotlinstatistics.range.InvalidRangeException;
import org.nield.kotlinstatistics.range.Range;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/nield/kotlinstatistics/range/OpenClosedRange;", "T", "", "Lorg/nield/kotlinstatistics/range/Range;", "startExclusive", "endInclusive", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)V", "getEndInclusive", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "lowerBound", "getLowerBound", "getStartExclusive", "upperBound", "getUpperBound", "contains", "", "value", "(Ljava/lang/Comparable;)Z", "isEmpty", "toString", "", "kotlin-statistics"})
public final class OpenClosedRange<T extends Comparable<? super T>>
implements Range<T> {
    @NotNull
    private final T startExclusive;
    @NotNull
    private final T endInclusive;

    @Override
    @NotNull
    public T getLowerBound() {
        return this.startExclusive;
    }

    @Override
    @NotNull
    public T getUpperBound() {
        return this.endInclusive;
    }

    @Override
    public boolean contains(@NotNull T value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return value.compareTo(this.startExclusive) > 0 && value.compareTo(this.endInclusive) <= 0;
    }

    @Override
    public boolean isEmpty() {
        return Intrinsics.areEqual(this.endInclusive, this.startExclusive);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.startExclusive + ".." + this.endInclusive + ']';
    }

    @NotNull
    public final T getStartExclusive() {
        return this.startExclusive;
    }

    @NotNull
    public final T getEndInclusive() {
        return this.endInclusive;
    }

    public OpenClosedRange(@NotNull T startExclusive, @NotNull T endInclusive) {
        Intrinsics.checkParameterIsNotNull(startExclusive, (String)"startExclusive");
        Intrinsics.checkParameterIsNotNull(endInclusive, (String)"endInclusive");
        this.startExclusive = startExclusive;
        this.endInclusive = endInclusive;
        if (this.startExclusive.compareTo(this.endInclusive) > 0) {
            throw (Throwable)new InvalidRangeException("" + '(' + this.startExclusive + ".." + this.endInclusive + "] is an invalid OpenClosedRange!");
        }
    }
}

