/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.TadPack;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.cache.TadDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;

public class CpuTADManager
implements TADManager {
    private Map<TadDescriptor, Pair<DataBuffer, DataBuffer>> cache = new ConcurrentHashMap<TadDescriptor, Pair<DataBuffer, DataBuffer>>();
    private NativeOps nativeOps;
    private ConstantHandler constantHandler;
    private AtomicLong bytes = new AtomicLong(0L);
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 100;

    public void init(@NonNull NativeOps nativeOps, @NonNull ConstantHandler constantHandler) {
        if (nativeOps == null) {
            throw new NullPointerException("nativeOps is marked non-null but is null");
        }
        if (constantHandler == null) {
            throw new NullPointerException("constantHandler is marked non-null but is null");
        }
        this.nativeOps = nativeOps;
        this.constantHandler = constantHandler;
    }

    public void purgeBuffers() {
        this.cache = new ConcurrentHashMap<TadDescriptor, Pair<DataBuffer, DataBuffer>>();
    }

    public Pair<DataBuffer, DataBuffer> getTADOnlyShapeInfo(INDArray array, int[] dimension) {
        if (dimension != null && dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if (dimension == null) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        TadPack pack = Nd4j.getExecutioner().tadShapeInfoAndOffsets(array, dimension);
        return new Pair((Object)pack.getTadShapeInfo(), (Object)pack.getTadOffsets());
    }

    public long getCachedBytes() {
        return this.bytes.get();
    }
}

