/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer.factory;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaFloatDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaHalfDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaIntDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaLongDataBuffer;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaDataBufferFactory
implements DataBufferFactory {
    private static final Logger log = LoggerFactory.getLogger(CudaDataBufferFactory.class);
    protected DataBuffer.AllocationMode allocationMode;

    public void setAllocationMode(DataBuffer.AllocationMode allocationMode) {
        this.allocationMode = allocationMode;
    }

    public DataBuffer.AllocationMode allocationMode() {
        if (this.allocationMode == null) {
            String otherAlloc = System.getProperty("alloc");
            if (otherAlloc.equals("heap")) {
                this.setAllocationMode(DataBuffer.AllocationMode.HEAP);
            } else if (otherAlloc.equals("direct")) {
                this.setAllocationMode(DataBuffer.AllocationMode.DIRECT);
            } else if (otherAlloc.equals("javacpp")) {
                this.setAllocationMode(DataBuffer.AllocationMode.JAVACPP);
            }
        }
        return this.allocationMode;
    }

    public DataBuffer create(DataBuffer underlyingBuffer, long offset, long length) {
        if (underlyingBuffer.dataType() == DataBuffer.Type.DOUBLE) {
            return new CudaDoubleDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.FLOAT) {
            return new CudaFloatDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.INT) {
            return new CudaIntDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.HALF) {
            return new CudaHalfDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.LONG) {
            return new CudaLongDataBuffer(underlyingBuffer, length, offset);
        }
        throw new ND4JIllegalStateException("Unknown data buffer type: " + underlyingBuffer.dataType().toString());
    }

    public DataBuffer createSame(DataBuffer buffer, boolean init) {
        switch (buffer.dataType()) {
            case INT: {
                return this.createInt(buffer.length(), init);
            }
            case FLOAT: {
                return this.createFloat(buffer.length(), init);
            }
            case DOUBLE: {
                return this.createDouble(buffer.length(), init);
            }
            case HALF: {
                return this.createHalf(buffer.length(), init);
            }
        }
        throw new UnsupportedOperationException("Unknown dataType: " + buffer.dataType());
    }

    public DataBuffer createSame(DataBuffer buffer, boolean init, MemoryWorkspace workspace) {
        switch (buffer.dataType()) {
            case INT: {
                return this.createInt(buffer.length(), init, workspace);
            }
            case FLOAT: {
                return this.createFloat(buffer.length(), init, workspace);
            }
            case DOUBLE: {
                return this.createDouble(buffer.length(), init, workspace);
            }
            case HALF: {
                return this.createHalf(buffer.length(), init, workspace);
            }
        }
        throw new UnsupportedOperationException("Unknown dataType: " + buffer.dataType());
    }

    public DataBuffer createFloat(float[] data, MemoryWorkspace workspace) {
        return this.createFloat(data, true, workspace);
    }

    public DataBuffer createFloat(float[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(data, copy, workspace);
    }

    public DataBuffer createInt(int[] data, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(data, workspace);
    }

    public DataBuffer createInt(int[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(data, copy, workspace);
    }

    public DataBuffer createInt(long offset, ByteBuffer buffer, int length) {
        return new CudaIntDataBuffer(buffer, length, offset);
    }

    public DataBuffer createFloat(long offset, ByteBuffer buffer, int length) {
        return new CudaFloatDataBuffer(buffer, (long)length, offset);
    }

    public DataBuffer createDouble(long offset, ByteBuffer buffer, int length) {
        return new CudaDoubleDataBuffer(buffer, (long)length, offset);
    }

    public DataBuffer createLong(ByteBuffer buffer, int length) {
        return new CudaLongDataBuffer(buffer, (long)length);
    }

    public DataBuffer createDouble(long offset, int length) {
        return new CudaDoubleDataBuffer((long)length, 8, offset);
    }

    public DataBuffer createFloat(long offset, int length) {
        return new CudaFloatDataBuffer((long)length, 4, (long)length);
    }

    public DataBuffer createInt(long offset, int length) {
        return new CudaIntDataBuffer((long)length, 4, offset);
    }

    public DataBuffer createDouble(long offset, int[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    public DataBuffer createFloat(long offset, int[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createInt(long offset, int[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(long offset, double[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(long offset, double[] data, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(data, true, offset, workspace);
    }

    public DataBuffer createDouble(long offset, byte[] data, int length) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubleArray((byte[])data), true, offset);
    }

    public DataBuffer createFloat(long offset, byte[] data, int length) {
        return new CudaFloatDataBuffer(ArrayUtil.toDoubleArray((byte[])data), true, offset);
    }

    public DataBuffer createFloat(long offset, double[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createInt(long offset, double[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(long offset, float[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    public DataBuffer createFloat(long offset, float[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createFloat(long offset, float[] data, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(data, true, offset, workspace);
    }

    public DataBuffer createInt(long offset, float[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(long offset, int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    public DataBuffer createFloat(long offset, int[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(long offset, int[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createDouble(long offset, double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, offset);
    }

    public DataBuffer createFloat(long offset, double[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(long offset, double[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createDouble(long offset, float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, offset);
    }

    public DataBuffer createFloat(long offset, float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(long offset, float[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(ByteBuffer buffer, int length) {
        return new CudaIntDataBuffer(buffer, length);
    }

    public DataBuffer createFloat(ByteBuffer buffer, int length) {
        return new CudaFloatDataBuffer(buffer, (long)length);
    }

    public DataBuffer createDouble(ByteBuffer buffer, int length) {
        return new CudaDoubleDataBuffer(buffer, (long)length);
    }

    public DataBuffer createDouble(long length) {
        return new CudaDoubleDataBuffer(length);
    }

    public DataBuffer createDouble(long length, boolean initialize) {
        return new CudaDoubleDataBuffer(length, initialize);
    }

    public DataBuffer createFloat(long length) {
        return new CudaFloatDataBuffer(length);
    }

    public DataBuffer createFloat(long length, boolean initialize) {
        return new CudaFloatDataBuffer(length, initialize);
    }

    public DataBuffer createFloat(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(length, initialize, workspace);
    }

    public DataBuffer createInt(long length) {
        return new CudaIntDataBuffer(length);
    }

    public DataBuffer createInt(long length, boolean initialize) {
        return new CudaIntDataBuffer(length, initialize);
    }

    public DataBuffer createInt(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(length, initialize, workspace);
    }

    public DataBuffer createDouble(int[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((int[])data));
    }

    public DataBuffer createFloat(int[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((int[])data));
    }

    public DataBuffer createInt(int[] data) {
        return new CudaIntDataBuffer(data);
    }

    public DataBuffer createDouble(double[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer createDouble(byte[] data, int length) {
        return new CudaDoubleDataBuffer(data, (long)length);
    }

    public DataBuffer createFloat(byte[] data, int length) {
        return new CudaFloatDataBuffer(data, (long)length);
    }

    public DataBuffer createFloat(double[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((double[])data));
    }

    public DataBuffer createInt(double[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((double[])data));
    }

    public DataBuffer createDouble(float[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((float[])data));
    }

    public DataBuffer createFloat(float[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer createInt(float[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((float[])data));
    }

    public DataBuffer createDouble(int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDouble((int[])data));
    }

    public DataBuffer createFloat(int[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((int[])data));
    }

    public DataBuffer createInt(int[] data, boolean copy) {
        return new CudaIntDataBuffer(data);
    }

    public DataBuffer createLong(int[] data, boolean copy) {
        return new CudaLongDataBuffer(data);
    }

    public DataBuffer createDouble(double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer createFloat(double[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((double[])data));
    }

    public DataBuffer createInt(double[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((double[])data));
    }

    public DataBuffer createDouble(float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((float[])data));
    }

    public DataBuffer createFloat(float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer createInt(float[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((float[])data));
    }

    public DataBuffer createDouble(long[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((long[])data));
    }

    public DataBuffer createFloat(long[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((long[])data));
    }

    public DataBuffer createInt(long[] data, boolean copy) {
        return new CudaIntDataBuffer(data);
    }

    public DataBuffer create(Pointer pointer, DataBuffer.Type type, long length, Indexer indexer) {
        switch (type) {
            case LONG: {
                return new CudaLongDataBuffer(pointer, indexer, length);
            }
            case INT: {
                return new CudaIntDataBuffer(pointer, indexer, length);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(pointer, indexer, length);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(pointer, indexer, length);
            }
            case HALF: {
                return new CudaHalfDataBuffer(pointer, indexer, length);
            }
        }
        throw new IllegalArgumentException("Illegal dtype " + type);
    }

    public DataBuffer create(DoublePointer doublePointer, long length) {
        return new CudaDoubleDataBuffer((Pointer)doublePointer, (Indexer)DoubleIndexer.create((DoublePointer)doublePointer), length);
    }

    public DataBuffer create(IntPointer intPointer, long length) {
        return new CudaIntDataBuffer((Pointer)intPointer, (Indexer)IntIndexer.create((IntPointer)intPointer), length);
    }

    public DataBuffer create(FloatPointer floatPointer, long length) {
        return new CudaFloatDataBuffer((Pointer)floatPointer, (Indexer)FloatIndexer.create((FloatPointer)floatPointer), length);
    }

    public DataBuffer createHalf(long length) {
        return new CudaHalfDataBuffer(length);
    }

    public DataBuffer createHalf(long length, boolean initialize) {
        return new CudaHalfDataBuffer(length, initialize);
    }

    public DataBuffer createHalf(float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(long offset, double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(long offset, float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(long offset, int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(long offset, double[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(long offset, float[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(long offset, float[] data, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(data, true, offset, workspace);
    }

    public DataBuffer createHalf(long offset, int[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(long offset, byte[] data, boolean copy) {
        return new CudaHalfDataBuffer(ArrayUtil.toFloatArray((byte[])data), copy, offset);
    }

    public DataBuffer createHalf(int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(float[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(double[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(int[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(long offset, byte[] data, int length) {
        return new CudaHalfDataBuffer(ArrayUtil.toFloatArray((byte[])data), true, offset);
    }

    public DataBuffer createHalf(long offset, int length) {
        return new CudaHalfDataBuffer(length);
    }

    public DataBuffer createHalf(ByteBuffer buffer, int length) {
        return new CudaHalfDataBuffer(buffer, (long)length);
    }

    public DataBuffer createHalf(byte[] data, int length) {
        return new CudaHalfDataBuffer(data, (long)length);
    }

    public DataBuffer createDouble(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(length, initialize, workspace);
    }

    public DataBuffer createDouble(double[] data, MemoryWorkspace workspace) {
        return this.createDouble(data, true, workspace);
    }

    public DataBuffer createDouble(double[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(data, copy, workspace);
    }

    public DataBuffer createHalf(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(length, initialize, workspace);
    }

    public DataBuffer createHalf(float[] data, MemoryWorkspace workspace) {
        return this.createHalf(data, true, workspace);
    }

    public DataBuffer createHalf(float[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(data, copy, workspace);
    }

    public Class<? extends DataBuffer> intBufferClass() {
        return CudaIntDataBuffer.class;
    }

    public Class<? extends DataBuffer> longBufferClass() {
        return CudaLongDataBuffer.class;
    }

    public Class<? extends DataBuffer> halfBufferClass() {
        return CudaHalfDataBuffer.class;
    }

    public Class<? extends DataBuffer> floatBufferClass() {
        return CudaFloatDataBuffer.class;
    }

    public Class<? extends DataBuffer> doubleBufferClass() {
        return CudaDoubleDataBuffer.class;
    }

    public DataBuffer createLong(long[] data) {
        return this.createLong(data, true);
    }

    public DataBuffer createLong(long[] data, boolean copy) {
        return new CudaLongDataBuffer(data, copy);
    }

    public DataBuffer createLong(long[] data, MemoryWorkspace workspace) {
        return new CudaLongDataBuffer(data, workspace);
    }

    public DataBuffer createLong(long length) {
        return this.createLong(length, true);
    }

    public DataBuffer createLong(long length, boolean initialize) {
        return new CudaLongDataBuffer(length, initialize);
    }

    public DataBuffer createLong(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaLongDataBuffer(length, initialize, workspace);
    }
}

