/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;

public class SerializationUtils {
    protected SerializationUtils() {
    }

    public static <T> T readObject(File file) {
        try {
            ObjectInputStream ois = new ObjectInputStream(FileUtils.openInputStream((File)file));
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readObject(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(Serializable toSave) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(toSave);
            byte[] ret = bos.toByteArray();
            os.close();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromByteArray(byte[] bytes) {
        return SerializationUtils.readObject(new ByteArrayInputStream(bytes));
    }

    public static <T> T deserialize(byte[] bytes) {
        return SerializationUtils.fromByteArray(bytes);
    }

    public static <T> T deserialize(InputStream is) {
        return SerializationUtils.readObject(is);
    }

    public static void writeObject(Serializable toSave, OutputStream writeTo) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(writeTo);
            os.writeObject(toSave);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serialize(Serializable object, OutputStream os) {
        SerializationUtils.writeObject(object, os);
    }

    public static void saveObject(Object toSave, File saveTo) {
        try {
            FileOutputStream os1 = FileUtils.openOutputStream((File)saveTo);
            ObjectOutputStream os = new ObjectOutputStream(os1);
            os.writeObject(toSave);
            os.flush();
            os.close();
            ((OutputStream)os1).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

