/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nd4j.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUtils.class);

    protected ArchiveUtils() {
    }

    public static void unzipFileTo(String file, String dest) throws IOException {
        File target;
        block69: {
            target = new File(file);
            if (!target.exists()) {
                throw new IllegalArgumentException("Archive doesnt exist");
            }
            FileInputStream fin = new FileInputStream(target);
            int BUFFER = 2048;
            byte[] data = new byte[BUFFER];
            if (file.endsWith(".zip") || file.endsWith(".jar")) {
                try (ZipInputStream zis = new ZipInputStream(fin);){
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null) {
                        int len;
                        String fileName = ze.getName();
                        String canonicalDestinationDirPath = new File(dest).getCanonicalPath();
                        File newFile = new File(dest + File.separator + fileName);
                        String canonicalDestinationFile = newFile.getCanonicalPath();
                        if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
                            log.debug("Attempt to unzip entry is outside of the target dir");
                            throw new IOException("Entry is outside of the target dir: ");
                        }
                        if (ze.isDirectory()) {
                            newFile.mkdirs();
                            zis.closeEntry();
                            ze = zis.getNextEntry();
                            continue;
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(data)) > 0) {
                            fos.write(data, 0, len);
                        }
                        fos.close();
                        ze = zis.getNextEntry();
                        log.debug("File extracted: " + newFile.getAbsoluteFile());
                    }
                    zis.closeEntry();
                }
            }
            if (file.endsWith(".tar.gz") || file.endsWith(".tgz")) {
                TarArchiveEntry entry;
                BufferedInputStream in = new BufferedInputStream(fin);
                GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
                TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);
                while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                    log.info("Extracting: " + entry.getName());
                    if (entry.isDirectory()) {
                        File f = new File(dest + File.separator + entry.getName());
                        f.mkdirs();
                        continue;
                    }
                    FileOutputStream fos = new FileOutputStream(dest + File.separator + entry.getName());
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream destStream = new BufferedOutputStream(fos, BUFFER);
                        Throwable throwable2 = null;
                        try {
                            int count;
                            while ((count = tarIn.read(data, 0, BUFFER)) != -1) {
                                destStream.write(data, 0, count);
                            }
                            destStream.flush();
                            IOUtils.closeQuietly((OutputStream)destStream);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (destStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    destStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            destStream.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                tarIn.close();
            } else {
                if (file.endsWith(".gz")) {
                    File extracted = new File(target.getParent(), target.getName().replace(".gz", ""));
                    if (extracted.exists()) {
                        extracted.delete();
                    }
                    extracted.createNewFile();
                    try (GZIPInputStream is2 = new GZIPInputStream(fin);
                         FileOutputStream fos = FileUtils.openOutputStream((File)extracted);){
                        IOUtils.copyLarge((InputStream)is2, (OutputStream)fos);
                        fos.flush();
                        break block69;
                    }
                }
                throw new IllegalStateException("Unable to infer file type (compression format) from source file name: " + file);
            }
        }
        target.delete();
    }

    public static List<String> tarGzListFiles(File tarGzFile) throws IOException {
        try (TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarGzFile))));){
            TarArchiveEntry entry;
            ArrayList<String> out = new ArrayList<String>();
            while ((entry = tin.getNextTarEntry()) != null) {
                String name = entry.getName();
                out.add(name);
            }
            ArrayList<String> arrayList = out;
            return arrayList;
        }
    }

    public static void tarGzExtractSingleFile(File tarGz, File destination, String pathInTarGz) throws IOException {
        try (TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarGz))));){
            TarArchiveEntry entry;
            ArrayList out = new ArrayList();
            boolean extracted = false;
            while ((entry = tin.getNextTarEntry()) != null) {
                String name = entry.getName();
                if (!pathInTarGz.equals(name)) continue;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destination));){
                    IOUtils.copy((InputStream)tin, (OutputStream)os);
                }
                extracted = true;
            }
            Preconditions.checkState(extracted, "No file was extracted. File not found? %s", (Object)pathInTarGz);
        }
    }
}

