/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.base.Preconditions;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static boolean containsAnyNegative(int[] arr) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyNegative(long[] arr) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean anyLargerThan(int[] arrs, int check) {
        for (int i = 0; i < arrs.length; ++i) {
            if (arrs[i] <= check) continue;
            return true;
        }
        return false;
    }

    public static boolean anyLessThan(int[] arrs, int check) {
        for (int i = 0; i < arrs.length; ++i) {
            if (arrs[i] >= check) continue;
            return true;
        }
        return false;
    }

    public static String[] convertToString(int[] arr) {
        Preconditions.checkNotNull(arr);
        String[] ret = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = String.valueOf(arr[i]);
        }
        return ret;
    }

    public static boolean listOfIntsContains(List<int[]> list, int[] target) {
        for (int[] arr : list) {
            if (!Arrays.equals(target, arr)) continue;
            return true;
        }
        return false;
    }

    public static int[] nTimes(int n, int toReplicate) {
        int[] ret = new int[n];
        Arrays.fill(ret, toReplicate);
        return ret;
    }

    public static long[] nTimes(long n, long toReplicate) {
        long[] ret = new long[(int)n];
        Arrays.fill(ret, toReplicate);
        return ret;
    }

    public static boolean allUnique(int[] toTest) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : toTest) {
            if (set.contains(i)) {
                return false;
            }
            set.add(i);
        }
        return true;
    }

    public static int[] randomPermutation(int size) {
        int j;
        Random r = new Random();
        int[] result = new int[size];
        for (j = 0; j < size; ++j) {
            result[j] = j + 1;
        }
        for (j = size - 1; j > 0; --j) {
            int k = r.nextInt(j);
            int temp = result[j];
            result[j] = result[k];
            result[k] = temp;
        }
        return result;
    }

    public static short toHalf(float data) {
        return ArrayUtil.fromFloat(data);
    }

    public static short toHalf(double data) {
        return ArrayUtil.fromFloat((float)data);
    }

    public static short[] toHalfs(float[] data) {
        short[] ret = new short[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ArrayUtil.fromFloat(data[i]);
        }
        return ret;
    }

    public static short[] toHalfs(int[] data) {
        short[] ret = new short[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ArrayUtil.fromFloat(data[i]);
        }
        return ret;
    }

    public static short[] toHalfs(long[] data) {
        short[] ret = new short[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ArrayUtil.fromFloat(data[i]);
        }
        return ret;
    }

    public static short[] toHalfs(double[] data) {
        short[] ret = new short[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ArrayUtil.fromFloat((float)data[i]);
        }
        return ret;
    }

    public static short fromFloat(float v) {
        if (Float.isNaN(v)) {
            return Short.MAX_VALUE;
        }
        if (v == Float.POSITIVE_INFINITY) {
            return 31744;
        }
        if (v == Float.NEGATIVE_INFINITY) {
            return -1024;
        }
        if (v == 0.0f) {
            return 0;
        }
        if (v == -0.0f) {
            return Short.MIN_VALUE;
        }
        if (v > 65504.0f) {
            return 31743;
        }
        if (v < -65504.0f) {
            return -1025;
        }
        if (v > 0.0f && v < 5.96046E-8f) {
            return 1;
        }
        if (v < 0.0f && v > -5.96046E-8f) {
            return -32767;
        }
        int f = Float.floatToIntBits(v);
        return (short)(f >> 16 & 0x8000 | (f & 0x7F800000) - 0x38000000 >> 13 & 0x7C00 | f >> 13 & 0x3FF);
    }

    public static int[] toInts(float[] data) {
        int[] ret = new int[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)data[i];
        }
        return ret;
    }

    public static int[] toInts(double[] data) {
        int[] ret = new int[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)data[i];
        }
        return ret;
    }

    public static int[] toInts(long[] array) {
        int[] retVal = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            retVal[i] = (int)array[i];
        }
        return retVal;
    }

    public static int[] mod(int[] input, int mod) {
        int[] ret = new int[input.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = input[i] % mod;
        }
        return ret;
    }

    public static int offsetFor(int[] stride, int i) {
        int ret = 0;
        for (int j = 0; j < stride.length; ++j) {
            ret += i * stride[j];
        }
        return ret;
    }

    public static int sum(List<Integer> add) {
        if (add.size() < 1) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < add.size(); ++i) {
            ret += add.get(i).intValue();
        }
        return ret;
    }

    public static int sum(int[] add) {
        if (add.length < 1) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < add.length; ++i) {
            ret += add[i];
        }
        return ret;
    }

    public static long sumLong(long ... add) {
        if (add.length < 1) {
            return 0L;
        }
        int ret = 0;
        for (int i = 0; i < add.length; ++i) {
            ret = (int)((long)ret + add[i]);
        }
        return ret;
    }

    public static int prod(List<Integer> mult) {
        if (mult.size() < 1) {
            return 0;
        }
        int ret = 1;
        for (int i = 0; i < mult.size(); ++i) {
            ret *= mult.get(i).intValue();
        }
        return ret;
    }

    public static int prod(long ... mult) {
        if (mult.length < 1) {
            return 0;
        }
        int ret = 1;
        for (int i = 0; i < mult.length; ++i) {
            ret = (int)((long)ret * mult[i]);
        }
        return ret;
    }

    public static int prod(int ... mult) {
        if (mult.length < 1) {
            return 0;
        }
        int ret = 1;
        for (int i = 0; i < mult.length; ++i) {
            ret *= mult[i];
        }
        return ret;
    }

    public static long prodLong(List<? extends Number> mult) {
        if (mult.size() < 1) {
            return 0L;
        }
        long ret = 1L;
        for (int i = 0; i < mult.size(); ++i) {
            ret *= mult.get(i).longValue();
        }
        return ret;
    }

    public static long prodLong(int ... mult) {
        if (mult.length < 1) {
            return 0L;
        }
        long ret = 1L;
        for (int i = 0; i < mult.length; ++i) {
            ret *= (long)mult[i];
        }
        return ret;
    }

    public static long prodLong(long ... mult) {
        if (mult.length < 1) {
            return 0L;
        }
        long ret = 1L;
        for (int i = 0; i < mult.length; ++i) {
            ret *= mult[i];
        }
        return ret;
    }

    public static boolean equals(float[] data, double[] data2) {
        if (data.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            double equals = Math.abs(data2[i] - (double)data[i]);
            if (!(equals > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public static int[] consArray(int a, int[] as) {
        int len = as.length;
        int[] nas = new int[len + 1];
        nas[0] = a;
        System.arraycopy(as, 0, nas, 1, len);
        return nas;
    }

    public static boolean isZero(int[] as) {
        for (int i = 0; i < as.length; ++i) {
            if (as[i] != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isZero(long[] as) {
        for (int i = 0; i < as.length; ++i) {
            if (as[i] != 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean anyMore(int[] target, int[] test) {
        Preconditions.checkArgument(target.length == test.length, "Unable to compare: different sizes: length %s vs. %s", target.length, test.length);
        for (int i = 0; i < target.length; ++i) {
            if (target[i] <= test[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean anyLess(int[] target, int[] test) {
        Preconditions.checkArgument(target.length == test.length, "Unable to compare: different sizes: length %s vs. %s", target.length, test.length);
        for (int i = 0; i < target.length; ++i) {
            if (target[i] >= test[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean lessThan(int[] target, int[] test) {
        Preconditions.checkArgument(target.length == test.length, "Unable to compare: different sizes: length %s vs. %s", target.length, test.length);
        for (int i = 0; i < target.length; ++i) {
            if (target[i] < test[i]) {
                return true;
            }
            if (target[i] <= test[i]) continue;
            return false;
        }
        return false;
    }

    public static boolean greaterThan(int[] target, int[] test) {
        Preconditions.checkArgument(target.length == test.length, "Unable to compare: different sizes: length %s vs. %s", target.length, test.length);
        for (int i = 0; i < target.length; ++i) {
            if (target[i] > test[i]) {
                return true;
            }
            if (target[i] >= test[i]) continue;
            return false;
        }
        return false;
    }

    public static int calcOffset(List<Integer> shape, List<Integer> offsets, List<Integer> strides) {
        if (shape.size() != offsets.size() || shape.size() != strides.size()) {
            throw new IllegalArgumentException("Shapes,strides, and offsets must be the same size");
        }
        int ret = 0;
        for (int i = 0; i < offsets.size(); ++i) {
            if (shape.get(i) == 1 && offsets.size() > 2 && i > 0) continue;
            ret += offsets.get(i) * strides.get(i);
        }
        return ret;
    }

    public static int calcOffset(int[] shape, int[] offsets, int[] strides) {
        if (shape.length != offsets.length || shape.length != strides.length) {
            throw new IllegalArgumentException("Shapes,strides, and offsets must be the same size");
        }
        int ret = 0;
        for (int i = 0; i < offsets.length; ++i) {
            if (shape[i] == 1) continue;
            ret += offsets[i] * strides[i];
        }
        return ret;
    }

    public static long calcOffsetLong(List<Integer> shape, List<Integer> offsets, List<Integer> strides) {
        if (shape.size() != offsets.size() || shape.size() != strides.size()) {
            throw new IllegalArgumentException("Shapes,strides, and offsets must be the same size");
        }
        long ret = 0L;
        for (int i = 0; i < offsets.size(); ++i) {
            if (shape.get(i) == 1 && offsets.size() > 2 && i > 0) continue;
            ret += (long)offsets.get(i).intValue() * (long)strides.get(i).intValue();
        }
        return ret;
    }

    public static long calcOffsetLong2(List<Long> shape, List<Long> offsets, List<Long> strides) {
        if (shape.size() != offsets.size() || shape.size() != strides.size()) {
            throw new IllegalArgumentException("Shapes,strides, and offsets must be the same size");
        }
        long ret = 0L;
        for (int i = 0; i < offsets.size(); ++i) {
            if (shape.get(i) == 1L && offsets.size() > 2 && i > 0) continue;
            ret += offsets.get(i) * strides.get(i);
        }
        return ret;
    }

    public static long calcOffsetLong(int[] shape, int[] offsets, int[] strides) {
        if (shape.length != offsets.length || shape.length != strides.length) {
            throw new IllegalArgumentException("Shapes,strides, and offsets must be the same size");
        }
        long ret = 0L;
        for (int i = 0; i < offsets.length; ++i) {
            if (shape[i] == 1) continue;
            ret += (long)offsets[i] * (long)strides[i];
        }
        return ret;
    }

    public static int dotProduct(List<Integer> xs, List<Integer> ys) {
        int result = 0;
        int n = xs.size();
        if (ys.size() != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += xs.get(i) * ys.get(i);
        }
        return result;
    }

    public static int dotProduct(int[] xs, int[] ys) {
        int result = 0;
        int n = xs.length;
        if (ys.length != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += xs[i] * ys[i];
        }
        return result;
    }

    public static long dotProductLong(List<Integer> xs, List<Integer> ys) {
        long result = 0L;
        int n = xs.size();
        if (ys.size() != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += (long)xs.get(i).intValue() * (long)ys.get(i).intValue();
        }
        return result;
    }

    public static long dotProductLong2(List<Long> xs, List<Long> ys) {
        long result = 0L;
        int n = xs.size();
        if (ys.size() != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += xs.get(i) * ys.get(i);
        }
        return result;
    }

    public static long dotProductLong(int[] xs, int[] ys) {
        long result = 0L;
        int n = xs.length;
        if (ys.length != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += (long)xs[i] * (long)ys[i];
        }
        return result;
    }

    public static int[] empty() {
        return new int[0];
    }

    public static int[] of(int ... arr) {
        return arr;
    }

    public static int[] copy(int[] copy) {
        int[] ret = new int[copy.length];
        System.arraycopy(copy, 0, ret, 0, ret.length);
        return ret;
    }

    public static long[] copy(long[] copy) {
        long[] ret = new long[copy.length];
        System.arraycopy(copy, 0, ret, 0, ret.length);
        return ret;
    }

    public static double[] doubleCopyOf(float[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static float[] floatCopyOf(double[] data) {
        if (data.length == 0) {
            return new float[1];
        }
        float[] ret = new float[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)data[i];
        }
        return ret;
    }

    public static double[] range(double[] data, int to) {
        return ArrayUtil.range(data, to, 1);
    }

    public static double[] range(double[] data, int to, int stride) {
        return ArrayUtil.range(data, to, stride, 1);
    }

    public static double[] range(double[] data, int to, int stride, int numElementsEachStride) {
        double[] ret = new double[to / stride];
        if (ret.length < 1) {
            ret = new double[1];
        }
        int count = 0;
        for (int i = 0; i < data.length; i += stride) {
            for (int j = 0; j < numElementsEachStride && i + j < data.length && count < ret.length; ++j) {
                ret[count++] = data[i + j];
            }
        }
        return ret;
    }

    public static List<Integer> toList(int ... ints) {
        if (ints == null) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int anInt : ints) {
            ret.add(anInt);
        }
        return ret;
    }

    public static int[] toArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static long[] toArrayLong(List<Long> list) {
        long[] ret = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static double[] toArrayDouble(List<Double> list) {
        double[] ret = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static int[] range(int from, int to, int increment) {
        int[] ret;
        block4: {
            block3: {
                int diff = Math.abs(from - to);
                ret = new int[diff / increment];
                if (ret.length < 1) {
                    ret = new int[1];
                }
                if (from >= to) break block3;
                int count = 0;
                for (int i = from; i < to && count < ret.length; i += increment) {
                    ret[count++] = i;
                }
                break block4;
            }
            if (from <= to) break block4;
            int count = 0;
            for (int i = from - 1; i >= to && count < ret.length; i -= increment) {
                ret[count++] = i;
            }
        }
        return ret;
    }

    public static long[] range(long from, long to, long increment) {
        long[] ret;
        block4: {
            block3: {
                long diff = Math.abs(from - to);
                ret = new long[(int)(diff / increment)];
                if (ret.length < 1) {
                    ret = new long[1];
                }
                if (from >= to) break block3;
                int count = 0;
                for (long i = from; i < to && count < ret.length; i += increment) {
                    ret[count++] = i;
                }
                break block4;
            }
            if (from <= to) break block4;
            int count = 0;
            int i = (int)from - 1;
            while ((long)i >= to && count < ret.length) {
                ret[count++] = i;
                i = (int)((long)i - increment);
            }
        }
        return ret;
    }

    public static int[] range(int from, int to) {
        if (from == to) {
            return new int[0];
        }
        return ArrayUtil.range(from, to, 1);
    }

    public static long[] range(long from, long to) {
        if (from == to) {
            return new long[0];
        }
        return ArrayUtil.range(from, to, 1L);
    }

    public static double[] toDoubles(int[] ints) {
        double[] ret = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static double[] toDoubles(long[] ints) {
        double[] ret = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static double[] toDoubles(float[] ints) {
        double[] ret = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static float[] toFloats(int[][] ints) {
        return ArrayUtil.toFloats(Ints.concat((int[][])ints));
    }

    public static double[] toDoubles(int[][] ints) {
        return ArrayUtil.toDoubles(Ints.concat((int[][])ints));
    }

    public static float[] toFloats(int[] ints) {
        float[] ret = new float[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static float[] toFloats(long[] ints) {
        float[] ret = new float[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static float[] toFloats(double[] ints) {
        float[] ret = new float[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = (float)ints[i];
        }
        return ret;
    }

    public static int[] replace(int[] data, int index, int newValue) {
        int[] copy = ArrayUtil.copy(data);
        copy[index] = newValue;
        return copy;
    }

    public static int[] keep(int[] data, int ... index) {
        if (index.length == data.length) {
            return data;
        }
        int[] ret = new int[index.length];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Ints.contains((int[])index, (int)i)) continue;
            ret[count++] = data[i];
        }
        return ret;
    }

    public static long[] keep(long[] data, int ... index) {
        if (index.length == data.length) {
            return data;
        }
        long[] ret = new long[index.length];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Ints.contains((int[])index, (int)i)) continue;
            ret[count++] = data[i];
        }
        return ret;
    }

    public static int[] removeIndex(int[] data, int ... index) {
        if (index.length >= data.length) {
            throw new IllegalStateException("Illegal remove: indexes.length > data.length (index.length=" + index.length + ", data.length=" + data.length + ")");
        }
        int offset = 0;
        int[] ret = new int[data.length - index.length + offset];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Ints.contains((int[])index, (int)i)) continue;
            ret[count++] = data[i];
        }
        return ret;
    }

    public static long[] removeIndex(long[] data, int ... index) {
        if (index.length >= data.length) {
            throw new IllegalStateException("Illegal remove: indexes.length > data.length (index.length=" + index.length + ", data.length=" + data.length + ")");
        }
        int offset = 0;
        long[] ret = new long[data.length - index.length + offset];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Ints.contains((int[])index, (int)i)) continue;
            ret[count++] = data[i];
        }
        return ret;
    }

    public static int[][] zip(int[] as, int[] bs) {
        int[][] result = new int[as.length][2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new int[]{as[i], bs[i]};
        }
        return result;
    }

    public static long[] getTensorMmulShape(long[] aShape, long[] bShape, int[][] axes) {
        long[] oldShapeB;
        long[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (aShape[axes[0][i]] != bShape[axes[1][i]]) {
                throw new IllegalArgumentException("Size of the given axes a t each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + aShape.length;
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + bShape.length;
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < aShape.length; ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < bShape.length; ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int n2 = 1;
        int aLength = Math.min(aShape.length, axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * aShape[axes[0][i]]);
        }
        if (listA.size() == 0) {
            oldShapeA = new long[]{1L};
        } else {
            oldShapeA = Longs.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = aShape[(int)oldShapeA[i]];
            }
        }
        int n3 = 1;
        int bNax = Math.min(bShape.length, axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * bShape[axes[1][i]]);
        }
        if (listB.size() == 0) {
            oldShapeB = new long[]{1L};
        } else {
            oldShapeB = Longs.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = bShape[(int)oldShapeB[i]];
            }
        }
        long[] aPlusB = Longs.concat((long[][])new long[][]{oldShapeA, oldShapeB});
        return aPlusB;
    }

    public static int[] permute(int[] shape, int[] dimensions) {
        int[] ret = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = shape[dimensions[i]];
        }
        return ret;
    }

    public static long[] permute(long[] shape, int[] dimensions) {
        long[] ret = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = shape[dimensions[i]];
        }
        return ret;
    }

    public static int[] argsort(int[] a) {
        return ArrayUtil.argsort(a, true);
    }

    public static int[] argsort(final int[] a, final boolean ascending) {
        Integer[] indexes = new Integer[a.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return (ascending ? 1 : -1) * Ints.compare((int)a[i1], (int)a[i2]);
            }
        });
        int[] ret = new int[indexes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = indexes[i];
        }
        return ret;
    }

    public static int[] convertNegativeIndices(int range, int[] axes) {
        int[] axesRet = ArrayUtil.range(0, range);
        int[] newAxes = ArrayUtil.copy(axes);
        for (int i = 0; i < axes.length; ++i) {
            newAxes[i] = axes[axesRet[i]];
        }
        return newAxes;
    }

    public static int[] copyOfRangeFrom(int length, int from, int to) {
        return Arrays.copyOfRange(ArrayUtil.range(0, length), from, to);
    }

    public static byte[] toByteArray(double[] doubleArray) {
        int times = 8;
        byte[] bytes = new byte[doubleArray.length * times];
        for (int i = 0; i < doubleArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putDouble(doubleArray[i]);
        }
        return bytes;
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        int times = 8;
        double[] doubles = new double[byteArray.length / times];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * times, times).getDouble();
        }
        return doubles;
    }

    public static byte[] toByteArray(float[] doubleArray) {
        int times = 4;
        byte[] bytes = new byte[doubleArray.length * times];
        for (int i = 0; i < doubleArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putFloat(doubleArray[i]);
        }
        return bytes;
    }

    public static long[] toLongArray(int[] intArray) {
        long[] ret = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            ret[i] = intArray[i];
        }
        return ret;
    }

    public static float[] toFloatArray(byte[] byteArray) {
        int times = 4;
        float[] doubles = new float[byteArray.length / times];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * times, times).getFloat();
        }
        return doubles;
    }

    public static byte[] toByteArray(int[] intArray) {
        int times = 4;
        byte[] bytes = new byte[intArray.length * times];
        for (int i = 0; i < intArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putInt(intArray[i]);
        }
        return bytes;
    }

    public static int[] toIntArray(byte[] byteArray) {
        int times = 4;
        int[] ints = new int[byteArray.length / times];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = ByteBuffer.wrap(byteArray, i * times, times).getInt();
        }
        return ints;
    }

    public static int[] removeIndex(int[] data, int index) {
        if (data == null) {
            return null;
        }
        if (index >= data.length) {
            throw new IllegalArgumentException("Unable to remove index " + index + " was >= data.length");
        }
        if (data.length < 1) {
            return data;
        }
        if (index < 0) {
            return data;
        }
        int len = data.length;
        int[] result = new int[len - 1];
        System.arraycopy(data, 0, result, 0, index);
        System.arraycopy(data, index + 1, result, index, len - index - 1);
        return result;
    }

    public static long[] removeIndex(long[] data, int index) {
        if (data == null) {
            return null;
        }
        if (index >= data.length) {
            throw new IllegalArgumentException("Unable to remove index " + index + " was >= data.length");
        }
        if (data.length < 1) {
            return data;
        }
        if (index < 0) {
            return data;
        }
        int len = data.length;
        long[] result = new long[len - 1];
        System.arraycopy(data, 0, result, 0, index);
        System.arraycopy(data, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] valueStartingAt(int valueStarting, int[] copy, int idxFrom, int idxAt, int length) {
        int[] ret = new int[length];
        Arrays.fill(ret, valueStarting);
        for (int i = 0; i < length && i + idxFrom < copy.length && i + idxAt < ret.length; ++i) {
            ret[i + idxAt] = copy[i + idxFrom];
        }
        return ret;
    }

    public static Integer[] removeIndex(Integer[] data, int index) {
        if (data == null) {
            return null;
        }
        if (data.length < 1) {
            return data;
        }
        int len = data.length;
        Integer[] result = new Integer[len - 1];
        System.arraycopy(data, 0, result, 0, index);
        System.arraycopy(data, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] calcStridesFortran(int[] shape, int startNum) {
        if (shape.length == 2 && (shape[0] == 1 || shape[1] == 1)) {
            int[] ret = new int[2];
            Arrays.fill(ret, startNum);
            return ret;
        }
        int dimensions = shape.length;
        int[] stride = new int[dimensions];
        int st = startNum;
        for (int j = 0; j < stride.length; ++j) {
            stride[j] = st;
            st *= shape[j];
        }
        return stride;
    }

    public static long[] calcStridesFortran(long[] shape, int startNum) {
        if (shape.length == 2 && (shape[0] == 1L || shape[1] == 1L)) {
            long[] ret = new long[2];
            Arrays.fill(ret, (long)startNum);
            return ret;
        }
        int dimensions = shape.length;
        long[] stride = new long[dimensions];
        int st = startNum;
        for (int j = 0; j < stride.length; ++j) {
            stride[j] = st;
            st = (int)((long)st * shape[j]);
        }
        return stride;
    }

    public static int[] calcStridesFortran(int[] shape) {
        return ArrayUtil.calcStridesFortran(shape, 1);
    }

    public static long[] calcStridesFortran(long[] shape) {
        return ArrayUtil.calcStridesFortran(shape, 1);
    }

    public static int[] calcStrides(int[] shape, int startValue) {
        if (shape.length == 2 && (shape[0] == 1 || shape[1] == 1)) {
            int[] ret = new int[2];
            Arrays.fill(ret, startValue);
            return ret;
        }
        int dimensions = shape.length;
        int[] stride = new int[dimensions];
        int st = startValue;
        for (int j = dimensions - 1; j >= 0; --j) {
            stride[j] = st;
            st *= shape[j];
        }
        return stride;
    }

    public static long[] calcStrides(long[] shape, int startValue) {
        if (shape.length == 2 && (shape[0] == 1L || shape[1] == 1L)) {
            long[] ret = new long[2];
            Arrays.fill(ret, (long)startValue);
            return ret;
        }
        int dimensions = shape.length;
        long[] stride = new long[dimensions];
        int st = startValue;
        for (int j = dimensions - 1; j >= 0; --j) {
            stride[j] = st;
            st = (int)((long)st * shape[j]);
        }
        return stride;
    }

    public static boolean isInverse(int[] first, int[] second) {
        int backWardCount = second.length - 1;
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[backWardCount--]) continue;
            return false;
        }
        return true;
    }

    public static int[] plus(int[] ints, int mult) {
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] + mult;
        }
        return ret;
    }

    public static int[] plus(int[] ints, int[] mult) {
        if (ints.length != mult.length) {
            throw new IllegalArgumentException("Both arrays must have the same length");
        }
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] + mult[i];
        }
        return ret;
    }

    public static int[] times(int[] ints, int mult) {
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] * mult;
        }
        return ret;
    }

    public static int[] times(int[] ints, int[] mult) {
        Preconditions.checkArgument(ints.length == mult.length, "Ints and mult must be the same length");
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] * mult[i];
        }
        return ret;
    }

    public static int nonOneStride(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 1) continue;
            return arr[i];
        }
        return 1;
    }

    public static int[] calcStrides(int[] shape) {
        return ArrayUtil.calcStrides(shape, 1);
    }

    public static long[] calcStrides(long[] shape) {
        return ArrayUtil.calcStrides(shape, 1);
    }

    public static int[] reverseCopy(int[] e) {
        if (e.length < 1) {
            return e;
        }
        int[] copy = new int[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            int temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static long[] reverseCopy(long[] e) {
        if (e.length < 1) {
            return e;
        }
        long[] copy = new long[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            long temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static double[] read(int length, DataInputStream dis) throws IOException {
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = dis.readDouble();
        }
        return ret;
    }

    public static void write(double[] data, DataOutputStream dos) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            dos.writeDouble(data[i]);
        }
    }

    public static double[] readDouble(int length, DataInputStream dis) throws IOException {
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = dis.readDouble();
        }
        return ret;
    }

    public static float[] readFloat(int length, DataInputStream dis) throws IOException {
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = dis.readFloat();
        }
        return ret;
    }

    public static void write(float[] data, DataOutputStream dos) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            dos.writeFloat(data[i]);
        }
    }

    public static void assertSquare(double[] ... d) {
        if (d.length > 2) {
            for (int i = 0; i < d.length; ++i) {
                ArrayUtil.assertSquare(new double[][]{d[i]});
            }
        } else {
            int firstLength = d[0].length;
            for (int i = 1; i < d.length; ++i) {
                Preconditions.checkState(d[i].length == firstLength);
            }
        }
    }

    public static void multiplyBy(int[] arr, int mult) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * mult;
        }
    }

    public static void reverse(int[] e) {
        for (int i = 0; i <= e.length / 2; ++i) {
            int temp = e[i];
            e[i] = e[e.length - i - 1];
            e[e.length - i - 1] = temp;
        }
    }

    public static void reverse(long[] e) {
        for (int i = 0; i <= e.length / 2; ++i) {
            long temp = e[i];
            e[i] = e[e.length - i - 1];
            e[e.length - i - 1] = temp;
        }
    }

    public static List<double[]> zerosMatrix(long ... dimensions) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (int i = 0; i < dimensions.length; ++i) {
            ret.add(new double[(int)dimensions[i]]);
        }
        return ret;
    }

    public static List<double[]> zerosMatrix(int ... dimensions) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (int i = 0; i < dimensions.length; ++i) {
            ret.add(new double[dimensions[i]]);
        }
        return ret;
    }

    public static float[] reverseCopy(float[] e) {
        float[] copy = new float[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            float temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static <E> E[] reverseCopy(E[] e) {
        Object[] copy = new Object[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            E temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static <E> void reverse(E[] e) {
        for (int i = 0; i <= e.length / 2; ++i) {
            E temp = e[i];
            e[i] = e[e.length - i - 1];
            e[e.length - i - 1] = temp;
        }
    }

    public static boolean[] flatten(boolean[][] arr) {
        if (arr.length == 0 || arr[0].length == 0) {
            return new boolean[0];
        }
        boolean[] ret = new boolean[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static boolean[] flatten(boolean[][][] arr) {
        if (arr.length == 0 || arr[0].length == 0 || arr[0][0].length == 0) {
            return new boolean[0];
        }
        boolean[] ret = new boolean[arr.length * arr[0].length * arr[0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    ret[count++] = arr[i][j][k];
                }
            }
        }
        return ret;
    }

    public static float[] flatten(float[][] arr) {
        if (arr.length == 0 || arr[0].length == 0) {
            return new float[0];
        }
        float[] ret = new float[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static float[] flatten(float[][][] arr) {
        if (arr.length == 0 || arr[0].length == 0 || arr[0][0].length == 0) {
            return new float[0];
        }
        float[] ret = new float[arr.length * arr[0].length * arr[0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    ret[count++] = arr[i][j][k];
                }
            }
        }
        return ret;
    }

    public static double[] flatten(double[][][] arr) {
        if (arr.length == 0 || arr[0].length == 0 || arr[0][0].length == 0) {
            return new double[0];
        }
        double[] ret = new double[arr.length * arr[0].length * arr[0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    ret[count++] = arr[i][j][k];
                }
            }
        }
        return ret;
    }

    public static int[] flatten(int[][][] arr) {
        if (arr.length == 0 || arr[0].length == 0 || arr[0][0].length == 0) {
            return new int[0];
        }
        int[] ret = new int[arr.length * arr[0].length * arr[0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    ret[count++] = arr[i][j][k];
                }
            }
        }
        return ret;
    }

    public static float[] flatten(float[][][][] arr) {
        float[] ret = new float[arr.length * arr[0].length * arr[0][0].length * arr[0][0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    for (int m = 0; m < arr[0][0][0].length; ++m) {
                        ret[count++] = arr[i][j][k][m];
                    }
                }
            }
        }
        return ret;
    }

    public static double[] flatten(double[][][][] arr) {
        double[] ret = new double[arr.length * arr[0].length * arr[0][0].length * arr[0][0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    for (int m = 0; m < arr[0][0][0].length; ++m) {
                        ret[count++] = arr[i][j][k][m];
                    }
                }
            }
        }
        return ret;
    }

    public static int[] flatten(int[][][][] arr) {
        int[] ret = new int[arr.length * arr[0].length * arr[0][0].length * arr[0][0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    for (int m = 0; m < arr[0][0][0].length; ++m) {
                        ret[count++] = arr[i][j][k][m];
                    }
                }
            }
        }
        return ret;
    }

    public static int[] flatten(int[][] arr) {
        if (arr.length == 0 || arr[0].length == 0) {
            return new int[0];
        }
        int[] ret = new int[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static long[] flatten(long[][] arr) {
        if (arr.length == 0 || arr[0].length == 0) {
            return new long[0];
        }
        long[] ret = new long[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static long[] flatten(long[][][] arr) {
        if (arr.length == 0 || arr[0].length == 0 || arr[0][0].length == 0) {
            return new long[0];
        }
        long[] ret = new long[arr.length * arr[0].length * arr[0][0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[0].length; ++j) {
                for (int k = 0; k < arr[0][0].length; ++k) {
                    ret[count++] = arr[i][j][k];
                }
            }
        }
        return ret;
    }

    public static double[] flatten(double[][] arr) {
        if (arr.length == 0 || arr[0].length == 0) {
            return new double[0];
        }
        double[] ret = new double[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static double[] flattenF(double[][] arr) {
        double[] ret = new double[arr.length * arr[0].length];
        int count = 0;
        for (int j = 0; j < arr[0].length; ++j) {
            for (int i = 0; i < arr.length; ++i) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static float[] flattenF(float[][] arr) {
        float[] ret = new float[arr.length * arr[0].length];
        int count = 0;
        for (int j = 0; j < arr[0].length; ++j) {
            for (int i = 0; i < arr.length; ++i) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static int[] flattenF(int[][] arr) {
        int[] ret = new int[arr.length * arr[0].length];
        int count = 0;
        for (int j = 0; j < arr[0].length; ++j) {
            for (int i = 0; i < arr.length; ++i) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static long[] flattenF(long[][] arr) {
        long[] ret = new long[arr.length * arr[0].length];
        int count = 0;
        for (int j = 0; j < arr[0].length; ++j) {
            for (int i = 0; i < arr.length; ++i) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static int[][] reshapeInt(int[] in, int rows, int cols) {
        int[][] out = new int[rows][cols];
        int x = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                out[i][j] = in[x++];
            }
        }
        return out;
    }

    public static int[][][] reshapeInt(int[] in, int d0, int d1, int d2) {
        int[][][] out = new int[d0][d1][d2];
        int x = 0;
        for (int i = 0; i < d0; ++i) {
            for (int j = 0; j < d1; ++j) {
                for (int k = 0; k < d2; ++k) {
                    out[i][j][k] = in[x++];
                }
            }
        }
        return out;
    }

    public static double[][] reshapeDouble(double[] in, int rows, int cols) {
        double[][] out = new double[rows][cols];
        int x = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                out[i][j] = in[x++];
            }
        }
        return out;
    }

    public static double[][][] reshapeDouble(double[] in, int d0, int d1, int d2) {
        double[][][] out = new double[d0][d1][d2];
        int x = 0;
        for (int i = 0; i < d0; ++i) {
            for (int j = 0; j < d1; ++j) {
                for (int k = 0; k < d2; ++k) {
                    out[i][j][k] = in[x++];
                }
            }
        }
        return out;
    }

    public static long[][] reshapeLong(long[] in, int rows, int cols) {
        long[][] out = new long[rows][cols];
        int x = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                out[i][j] = in[x++];
            }
        }
        return out;
    }

    public static long[][][] reshapeLong(long[] in, int d0, int d1, int d2) {
        long[][][] out = new long[d0][d1][d2];
        int x = 0;
        for (int i = 0; i < d0; ++i) {
            for (int j = 0; j < d1; ++j) {
                for (int k = 0; k < d2; ++k) {
                    out[i][j][k] = in[x++];
                }
            }
        }
        return out;
    }

    public static boolean[][] reshapeBoolean(boolean[] in, int rows, int cols) {
        boolean[][] out = new boolean[rows][cols];
        int x = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                out[i][j] = in[x++];
            }
        }
        return out;
    }

    public static boolean[][][] reshapeBoolean(boolean[] in, int d0, int d1, int d2) {
        boolean[][][] out = new boolean[d0][d1][d2];
        int x = 0;
        for (int i = 0; i < d0; ++i) {
            for (int j = 0; j < d1; ++j) {
                for (int k = 0; k < d2; ++k) {
                    out[i][j][k] = in[x++];
                }
            }
        }
        return out;
    }

    public static <T> T[][] reshapeObject(T[] in, int rows, int cols) {
        Object[][] out = new Object[rows][cols];
        int x = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                out[i][j] = in[x++];
            }
        }
        return out;
    }

    public static <T> T[][][] reshapeObject(T[] in, int d0, int d1, int d2) {
        Object[][][] out = new Object[d0][d1][d2];
        int x = 0;
        for (int i = 0; i < d0; ++i) {
            for (int j = 0; j < d1; ++j) {
                for (int k = 0; k < d2; ++k) {
                    out[i][j][k] = in[x++];
                }
            }
        }
        return out;
    }

    public static double[][] toDouble(int[][] arr) {
        double[][] ret = new double[arr.length][arr[0].length];
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[i][j] = arr[i][j];
            }
        }
        return ret;
    }

    public static float[] combineFloat(List<float[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        float[] ret = new float[length];
        int count = 0;
        for (float[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static float[] combine(List<float[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        float[] ret = new float[length];
        int count = 0;
        for (float[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static double[] combineDouble(List<double[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        double[] ret = new double[length];
        int count = 0;
        for (double[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static double[] combine(float[] ... ints) {
        int length = 0;
        for (int i = 0; i < ints.length; ++i) {
            length += ints[i].length;
        }
        double[] ret = new double[length];
        int count = 0;
        for (float[] i : ints) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static int[] combine(int[] ... ints) {
        int length = 0;
        for (int i = 0; i < ints.length; ++i) {
            length += ints[i].length;
        }
        int[] ret = new int[length];
        int count = 0;
        for (int[] i : ints) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static long[] combine(long[] ... ints) {
        int length = 0;
        for (int i = 0; i < ints.length; ++i) {
            length += ints[i].length;
        }
        long[] ret = new long[length];
        int count = 0;
        for (long[] i : ints) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static <E> E[] combine(E[] ... arrs) {
        int length = 0;
        for (int i = 0; i < arrs.length; ++i) {
            length += arrs[i].length;
        }
        Object[] ret = (Object[])Array.newInstance(arrs[0][0].getClass(), length);
        int count = 0;
        for (E[] i : arrs) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static int[] toOutcomeArray(int outcome, int numOutcomes) {
        int[] nums = new int[numOutcomes];
        nums[outcome] = 1;
        return nums;
    }

    public static double[] toDouble(int[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static double[] toDouble(long[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static float[] copy(float[] data) {
        float[] result = new float[data.length];
        System.arraycopy(data, 0, result, 0, data.length);
        return result;
    }

    public static double[] copy(double[] data) {
        double[] result = new double[data.length];
        System.arraycopy(data, 0, result, 0, data.length);
        return result;
    }

    public static double[] flattenDoubleArray(Object doubleArray) {
        if (doubleArray instanceof double[]) {
            return (double[])doubleArray;
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.push(doubleArray);
        int[] shape = ArrayUtil.arrayShape(doubleArray);
        int length = ArrayUtil.prod(shape);
        double[] flat = new double[length];
        int count = 0;
        while (!stack.isEmpty()) {
            int i;
            Object current = stack.pop();
            if (current instanceof double[]) {
                double[] arr = (double[])current;
                for (i = 0; i < arr.length; ++i) {
                    flat[count++] = arr[i];
                }
                continue;
            }
            if (current instanceof Object[]) {
                Object[] o = (Object[])current;
                for (i = o.length - 1; i >= 0; --i) {
                    stack.push(o[i]);
                }
                continue;
            }
            throw new IllegalArgumentException("Base array is not double[]");
        }
        if (count != flat.length) {
            throw new IllegalArgumentException("Fewer elements than expected. Array is ragged?");
        }
        return flat;
    }

    public static float[] flattenFloatArray(Object floatArray) {
        if (floatArray instanceof float[]) {
            return (float[])floatArray;
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.push(floatArray);
        int[] shape = ArrayUtil.arrayShape(floatArray);
        int length = ArrayUtil.prod(shape);
        float[] flat = new float[length];
        int count = 0;
        while (!stack.isEmpty()) {
            int i;
            Object current = stack.pop();
            if (current instanceof float[]) {
                float[] arr = (float[])current;
                for (i = 0; i < arr.length; ++i) {
                    flat[count++] = arr[i];
                }
                continue;
            }
            if (current instanceof Object[]) {
                Object[] o = (Object[])current;
                for (i = o.length - 1; i >= 0; --i) {
                    stack.push(o[i]);
                }
                continue;
            }
            throw new IllegalArgumentException("Base array is not float[]");
        }
        if (count != flat.length) {
            throw new IllegalArgumentException("Fewer elements than expected. Array is ragged?");
        }
        return flat;
    }

    public static int[] arrayShape(Object array) {
        return ArrayUtil.arrayShape(array, false);
    }

    public static int[] arrayShape(Object array, boolean allowSize0Dims) {
        int nDimensions = 0;
        for (Class<?> c = array.getClass().getComponentType(); c != null; c = c.getComponentType()) {
            ++nDimensions;
        }
        int[] shape = new int[nDimensions];
        Object current = array;
        for (int i = 0; i < shape.length - 1; ++i) {
            shape[i] = ((Object[])current).length;
            if (shape[i] == 0) {
                if (allowSize0Dims) {
                    return shape;
                }
                throw new IllegalStateException("Cannot calculate array shape: Array has size 0 for dimension " + i);
            }
            current = ((Object[])current)[0];
        }
        if (current instanceof Object[]) {
            shape[shape.length - 1] = ((Object[])current).length;
        } else if (current instanceof double[]) {
            shape[shape.length - 1] = ((double[])current).length;
        } else if (current instanceof float[]) {
            shape[shape.length - 1] = ((float[])current).length;
        } else if (current instanceof long[]) {
            shape[shape.length - 1] = ((long[])current).length;
        } else if (current instanceof int[]) {
            shape[shape.length - 1] = ((int[])current).length;
        } else if (current instanceof byte[]) {
            shape[shape.length - 1] = ((byte[])current).length;
        } else if (current instanceof char[]) {
            shape[shape.length - 1] = ((char[])current).length;
        } else if (current instanceof boolean[]) {
            shape[shape.length - 1] = ((boolean[])current).length;
        } else if (current instanceof short[]) {
            shape[shape.length - 1] = ((short[])current).length;
        } else {
            throw new IllegalStateException("Unknown array opType");
        }
        return shape;
    }

    public static int max(int[] in) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] <= max) continue;
            max = in[i];
        }
        return max;
    }

    public static int min(int[] in) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] >= min) continue;
            min = in[i];
        }
        return min;
    }

    public static int argMax(int[] in) {
        int maxIdx = 0;
        for (int i = 1; i < in.length; ++i) {
            if (in[i] <= in[maxIdx]) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static int argMin(int[] in) {
        int minIdx = 0;
        for (int i = 1; i < in.length; ++i) {
            if (in[i] >= in[minIdx]) continue;
            minIdx = i;
        }
        return minIdx;
    }

    public static int argMax(long[] in) {
        int maxIdx = 0;
        for (int i = 1; i < in.length; ++i) {
            if (in[i] <= in[maxIdx]) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static int argMin(long[] in) {
        int minIdx = 0;
        for (int i = 1; i < in.length; ++i) {
            if (in[i] >= in[minIdx]) continue;
            minIdx = i;
        }
        return minIdx;
    }

    public static int[] buildHalfVector(Random rng, int length) {
        int i;
        int[] result = new int[length];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (i = result.length - 1; i >= result.length / 2; --i) {
            indexes.add(i);
        }
        Collections.shuffle(indexes, rng);
        for (i = 0; i < result.length; ++i) {
            if (i < result.length / 2) {
                result[i] = (Integer)indexes.get(0);
                indexes.remove(0);
                continue;
            }
            result[i] = -1;
        }
        return result;
    }

    public static int[] buildInterleavedVector(Random rng, int length) {
        int i;
        int[] result = new int[length];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> odds = new ArrayList<Integer>();
        for (i = 1; i < result.length; i += 2) {
            indexes.add(i);
            odds.add(i - 1);
        }
        Collections.shuffle(indexes, rng);
        for (i = 0; i < result.length; ++i) {
            if (i % 2 == 0 && indexes.size() >= 1) {
                int idx = (Integer)indexes.get(0);
                indexes.remove(0);
                result[i] = idx;
                continue;
            }
            result[i] = -1;
        }
        if (length % 2 != 0) {
            int rndClause = (Integer)odds.get(rng.nextInt(odds.size()));
            int tmp = result[rndClause];
            result[rndClause] = result[result.length - 1];
            result[result.length - 1] = tmp;
        }
        return result;
    }

    public static long[] buildInterleavedVector(Random rng, long length) {
        int i;
        long[] result = new long[(int)length];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> odds = new ArrayList<Integer>();
        for (i = 1; i < result.length; i += 2) {
            indexes.add(i);
            odds.add(i - 1);
        }
        Collections.shuffle(indexes, rng);
        for (i = 0; i < result.length; ++i) {
            if (i % 2 == 0 && indexes.size() >= 1) {
                int idx = (Integer)indexes.get(0);
                indexes.remove(0);
                result[i] = idx;
                continue;
            }
            result[i] = -1L;
        }
        if (length % 2L != 0L) {
            int rndClause = (Integer)odds.get(rng.nextInt(odds.size()));
            long tmp = result[rndClause];
            result[rndClause] = result[result.length - 1];
            result[result.length - 1] = tmp;
        }
        return result;
    }

    protected static <T> void swap(List<T> objects, int idxA, int idxB) {
        T tmpA = objects.get(idxA);
        T tmpB = objects.get(idxB);
        objects.set(idxA, tmpB);
        objects.set(idxB, tmpA);
    }

    public static <T> void shuffleWithMap(List<T> objects, int[] map) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] < 0) continue;
            ArrayUtil.swap(objects, i, map[i]);
        }
    }

    public static int argMinOfMax(int[] first, int[] second) {
        int minIdx = 0;
        int maxAtMinIdx = Math.max(first[0], second[0]);
        for (int i = 1; i < first.length; ++i) {
            int maxAtIndex = Math.max(first[i], second[i]);
            if (maxAtMinIdx <= maxAtIndex) continue;
            maxAtMinIdx = maxAtIndex;
            minIdx = i;
        }
        return minIdx;
    }

    public static long argMinOfMax(long[] first, long[] second) {
        long minIdx = 0L;
        long maxAtMinIdx = Math.max(first[0], second[0]);
        for (int i = 1; i < first.length; ++i) {
            long maxAtIndex = Math.max(first[i], second[i]);
            if (maxAtMinIdx <= maxAtIndex) continue;
            maxAtMinIdx = maxAtIndex;
            minIdx = i;
        }
        return minIdx;
    }

    public static int argMinOfMax(int[] ... arrays) {
        int minIdx = 0;
        int maxAtMinIdx = Integer.MAX_VALUE;
        for (int i = 0; i < arrays[0].length; ++i) {
            int maxAtIndex = Integer.MIN_VALUE;
            for (int j = 0; j < arrays.length; ++j) {
                maxAtIndex = Math.max(maxAtIndex, arrays[j][i]);
            }
            if (maxAtMinIdx <= maxAtIndex) continue;
            maxAtMinIdx = maxAtIndex;
            minIdx = i;
        }
        return minIdx;
    }

    public static long argMinOfMax(long[] ... arrays) {
        int minIdx = 0;
        long maxAtMinIdx = Long.MAX_VALUE;
        for (int i = 0; i < arrays[0].length; ++i) {
            long maxAtIndex = Long.MIN_VALUE;
            for (int j = 0; j < arrays.length; ++j) {
                maxAtIndex = Math.max(maxAtIndex, arrays[j][i]);
            }
            if (maxAtMinIdx <= maxAtIndex) continue;
            maxAtMinIdx = maxAtIndex;
            minIdx = i;
        }
        return minIdx;
    }

    public static int argMinOfSum(int[] first, int[] second) {
        int minIdx = 0;
        int sumAtMinIdx = first[0] + second[0];
        for (int i = 1; i < first.length; ++i) {
            int sumAtIndex = first[i] + second[i];
            if (sumAtMinIdx <= sumAtIndex) continue;
            sumAtMinIdx = sumAtIndex;
            minIdx = i;
        }
        return minIdx;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> T getRandomElement(List<T> list) {
        if (list.size() < 1) {
            return null;
        }
        return list.get(RandomUtils.nextInt((int)0, (int)list.size()));
    }

    public static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }
}

