/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.nio.ByteBuffer;
import lombok.NonNull;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;

public class LongBuffer
extends BaseDataBuffer {
    public LongBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public LongBuffer(long length) {
        super(length);
    }

    public LongBuffer(long length, boolean initialize) {
        super(length, initialize);
    }

    public LongBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, initialize, workspace);
    }

    public LongBuffer(int[] ints, boolean copy, MemoryWorkspace workspace) {
        super(ints, copy, workspace);
    }

    public LongBuffer(ByteBuffer buffer, int length, long offset) {
        super(buffer, (long)length, offset);
    }

    public LongBuffer(byte[] data, int length) {
        super(data, (long)length);
    }

    public LongBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public LongBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public LongBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public LongBuffer(long[] data, boolean copy) {
        super(data, copy);
    }

    public LongBuffer(long[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, workspace);
    }

    public LongBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public LongBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public LongBuffer(int length, int elementSize) {
        super((long)length, elementSize);
    }

    public LongBuffer(int length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public LongBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public LongBuffer(ByteBuffer buffer, int length) {
        super(buffer, (long)length);
    }

    public LongBuffer(@NonNull Pointer hostPointer, long numberOfElements) {
        if (hostPointer == null) {
            throw new NullPointerException("hostPointer is marked @NonNull but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.offset = 0L;
        this.originalOffset = 0L;
        this.underlyingLength = numberOfElements;
        this.length = numberOfElements;
        this.initTypeAndSize();
        this.pointer = new PagedPointer(hostPointer, numberOfElements).asLongPointer();
        this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
    }

    @Override
    protected DataBuffer create(long length) {
        return new LongBuffer(length);
    }

    public LongBuffer(int[] data) {
        super(data);
    }

    public LongBuffer(double[] data) {
        super(data);
    }

    public LongBuffer(float[] data) {
        super(data);
    }

    public LongBuffer(long[] data) {
        super(data, true);
    }

    @Override
    public DataBuffer create(double[] data) {
        return new LongBuffer(data);
    }

    @Override
    public DataBuffer create(float[] data) {
        return new LongBuffer(data);
    }

    @Override
    public DataBuffer create(int[] data) {
        return new LongBuffer(data);
    }

    public LongBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    @Override
    protected void initTypeAndSize() {
        this.elementSize = (byte)8;
        this.type = DataType.LONG;
    }
}

