/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data.primitives;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.linalg.profiler.data.primitives.ComparableAtomicLong;
import org.nd4j.linalg.profiler.data.primitives.StackDescriptor;
import org.nd4j.linalg.profiler.data.primitives.StackNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTree {
    private static final Logger log = LoggerFactory.getLogger(StackTree.class);
    protected Map<String, StackNode> basement = new HashMap<String, StackNode>();
    protected AtomicLong eventsCount = new AtomicLong(0L);
    protected Map<StackDescriptor, ComparableAtomicLong> branches = new HashMap<StackDescriptor, ComparableAtomicLong>();
    protected StackDescriptor lastDescriptor;

    public String renderTree(boolean displayCounts) {
        StringBuilder builder = new StringBuilder();
        for (StackNode cNode : this.basement.values()) {
            cNode.traverse(0, displayCounts);
        }
        return builder.toString();
    }

    public void consumeStackTrace(@NonNull StackDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        this.consumeStackTrace(descriptor, 1L);
    }

    public void consumeStackTrace(@NonNull StackDescriptor descriptor, long increment) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        this.eventsCount.incrementAndGet();
        this.lastDescriptor = descriptor;
        if (!this.branches.containsKey(descriptor)) {
            this.branches.put(descriptor, new ComparableAtomicLong(0L));
        }
        this.branches.get(descriptor).incrementAndGet();
        String entry = descriptor.getEntryName();
        if (!this.basement.containsKey(entry)) {
            this.basement.put(entry, new StackNode(entry));
        }
        this.basement.get(entry).consume(descriptor, 0, increment);
    }

    public long getTotalEventsNumber() {
        return this.eventsCount.get();
    }

    public int getUniqueBranchesNumber() {
        return this.branches.size();
    }

    public void reset() {
        this.basement.clear();
        this.eventsCount.set(0L);
        this.branches.clear();
    }

    public StackDescriptor getLastDescriptor() {
        return this.lastDescriptor;
    }
}

