/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.memory.abstracts;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.DebugMode;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.memory.enums.LocationPolicy;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.enums.ResetPolicy;
import org.nd4j.linalg.api.memory.enums.SpillPolicy;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.memory.pointers.PointersPair;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.MemoryManager;
import org.nd4j.linalg.util.ND4JFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jWorkspace
implements MemoryWorkspace {
    private static final Logger log = LoggerFactory.getLogger(Nd4jWorkspace.class);
    protected int deviceId;
    protected Long threadId;
    protected MemoryWorkspace.Type workspaceType = MemoryWorkspace.Type.SCOPED;
    protected static final long SAFETY_OFFSET = 1024L;
    protected String id;
    protected AtomicLong currentSize = new AtomicLong(0L);
    protected AtomicLong hostOffset = new AtomicLong(0L);
    protected AtomicLong deviceOffset = new AtomicLong(0L);
    protected PointersPair workspace = new PointersPair();
    protected MemoryManager memoryManager;
    protected AtomicBoolean isLearning = new AtomicBoolean(true);
    protected AtomicBoolean isUsed = new AtomicBoolean(true);
    protected AtomicLong disabledCounter = new AtomicLong(0L);
    protected AtomicLong cyclesCount = new AtomicLong(0L);
    protected AtomicLong stepsCount = new AtomicLong(0L);
    protected int stepsNumber = 1;
    protected AtomicLong lastCycleAllocations = new AtomicLong(0L);
    protected AtomicLong cycleAllocations = new AtomicLong(0L);
    protected AtomicLong spilledAllocationsSize = new AtomicLong(0L);
    protected AtomicLong pinnedAllocationsSize = new AtomicLong(0L);
    protected AtomicLong maxCycle = new AtomicLong(0L);
    protected AtomicBoolean resetPlanned = new AtomicBoolean(false);
    protected AtomicBoolean isOpen = new AtomicBoolean(false);
    protected AtomicBoolean isInit = new AtomicBoolean(false);
    protected AtomicBoolean isOver = new AtomicBoolean(false);
    protected AtomicBoolean isBorrowed = new AtomicBoolean(false);
    protected AtomicInteger tagScope = new AtomicInteger(0);
    protected AtomicBoolean isDebug = new AtomicBoolean(false);
    protected AtomicInteger externalCount = new AtomicInteger(0);
    protected AtomicInteger pinnedCount = new AtomicInteger(0);
    protected AtomicBoolean trimmedMode = new AtomicBoolean(false);
    protected AtomicLong trimmedStep = new AtomicLong(0L);
    protected final WorkspaceConfiguration workspaceConfiguration;
    protected List<PointersPair> externalAllocations = new ArrayList<PointersPair>();
    protected Queue<PointersPair> pinnedAllocations = new LinkedTransferQueue<PointersPair>();
    protected MemoryWorkspace previousWorkspace;
    protected MemoryWorkspace borrowingWorkspace;
    protected AtomicLong initialBlockSize = new AtomicLong(0L);
    protected String guid;
    protected File tempFile;
    protected AtomicLong generationId = new AtomicLong(0L);

    public Nd4jWorkspace(@NonNull WorkspaceConfiguration configuration) {
        this(configuration, "DefaultWorkspace");
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Nd4jWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String workspaceId) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        if (workspaceId == null) {
            throw new NullPointerException("workspaceId is marked @NonNull but is null");
        }
        this.workspaceConfiguration = configuration;
        this.id = workspaceId;
        this.threadId = Thread.currentThread().getId();
        this.guid = Nd4j.getWorkspaceManager().getUUID();
        this.memoryManager = Nd4j.getMemoryManager();
        this.deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        this.currentSize.set(this.workspaceConfiguration.getInitialSize());
        this.workspaceType = this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED ? MemoryWorkspace.Type.CIRCULAR : MemoryWorkspace.Type.SCOPED;
        if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED && this.workspaceConfiguration.getPolicyAllocation() == AllocationPolicy.OVERALLOCATE) {
            if (this.workspaceConfiguration.getOverallocationLimit() < 1.0) {
                throw new ND4JIllegalStateException("For cyclic workspace overallocation should be positive integral value.");
            }
            this.stepsNumber = (int)(this.workspaceConfiguration.getOverallocationLimit() + 1.0);
            log.debug("Steps: {}", (Object)this.stepsNumber);
        }
        if (configuration.getPolicyLocation() == LocationPolicy.MMAP) {
            if (configuration.getTempFilePath() != null) {
                this.tempFile = new File(configuration.getTempFilePath());
                if (this.tempFile.length() == 0L || this.tempFile.length() < configuration.getInitialSize()) {
                    if (configuration.getInitialSize() <= 0L) throw new ND4JIllegalStateException("Memory-mapped file should have positive length.");
                    try {
                        Nd4jWorkspace.fillFile(this.tempFile, configuration.getInitialSize());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    configuration.setInitialSize(this.tempFile.length());
                }
            } else {
                if (configuration.getInitialSize() <= 0L) throw new ND4JIllegalStateException("MMAP target file path should be non-null or workspace initialSize should be >0 for temp file");
                try {
                    this.tempFile = ND4JFileUtils.createTempFile((String)"workspace", (String)"tempMMAP");
                    this.tempFile.deleteOnExit();
                    Nd4jWorkspace.fillFile(this.tempFile, configuration.getInitialSize());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.init();
    }

    public MemoryWorkspace.Type getWorkspaceType() {
        return this.workspaceType;
    }

    public static void fillFile(File file, long length) throws Exception {
        byte[] buffer = new byte[16384];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = 0;
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            for (long written = 0L; written < length; written += (long)buffer.length) {
                fos.write(buffer);
            }
        }
    }

    public long getGenerationId() {
        return this.generationId.get();
    }

    public long getStepNumber() {
        return this.stepsCount.get();
    }

    public long getSpilledSize() {
        return this.spilledAllocationsSize.get();
    }

    public long getPinnedSize() {
        return this.pinnedAllocationsSize.get();
    }

    public long getInitialBlockSize() {
        return this.initialBlockSize.get();
    }

    public MemoryWorkspace getParentWorkspace() {
        return this.previousWorkspace;
    }

    public long getDeviceOffset() {
        return this.deviceOffset.get();
    }

    public long getHostOffset() {
        return this.hostOffset.get();
    }

    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public long getCurrentOffset() {
        return this.hostOffset.get();
    }

    protected void init() {
        if (this.currentSize.get() > 0L) {
            if (!this.isOver.get() && this.workspaceConfiguration.getPolicyAllocation() == AllocationPolicy.OVERALLOCATE && this.workspaceConfiguration.getOverallocationLimit() > 0.0) {
                this.currentSize.addAndGet((long)((double)this.currentSize.get() * this.workspaceConfiguration.getOverallocationLimit()));
                this.isOver.set(true);
            }
            if (this.workspaceConfiguration.getMaxSize() > 0L && this.currentSize.get() > this.workspaceConfiguration.getMaxSize()) {
                this.currentSize.set(this.workspaceConfiguration.getMaxSize());
            }
        }
    }

    public PagedPointer alloc(long requiredMemory, DataBuffer.Type type, boolean initialize) {
        return this.alloc(requiredMemory, MemoryKind.HOST, type, initialize);
    }

    public void enableDebug(boolean reallyEnable) {
        this.isDebug.set(reallyEnable);
    }

    public PagedPointer alloc(long requiredMemory, MemoryKind kind, DataBuffer.Type type, boolean initialize) {
        boolean trimmer;
        long div = requiredMemory % 8L;
        if (div != 0L) {
            requiredMemory += div;
        }
        long numElements = requiredMemory / (long)Nd4j.sizeOfDataType(type);
        if (!this.isUsed.get()) {
            if (this.disabledCounter.incrementAndGet() % 10L == 0L) {
                log.warn("Workspace was turned off, and wasn't enabled after {} allocations", (Object)this.disabledCounter.get());
            }
            PagedPointer pointer = new PagedPointer(this.memoryManager.allocate(requiredMemory, MemoryKind.HOST, initialize), numElements);
            this.externalAllocations.add(new PointersPair(pointer, null));
            return pointer;
        }
        boolean bl = trimmer = this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED && requiredMemory + this.cycleAllocations.get() > this.initialBlockSize.get() && this.initialBlockSize.get() > 0L || this.trimmedMode.get();
        if (trimmer && this.workspaceConfiguration.getPolicySpill() == SpillPolicy.REALLOCATE && !this.trimmedMode.get()) {
            this.trimmedMode.set(true);
            this.trimmedStep.set(this.stepsCount.get());
        }
        if (this.hostOffset.get() + requiredMemory <= this.currentSize.get() && !trimmer && Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.SPILL_EVERYTHING) {
            this.cycleAllocations.addAndGet(requiredMemory);
            long prevOffset = this.hostOffset.getAndAdd(requiredMemory);
            this.deviceOffset.set(this.hostOffset.get());
            PagedPointer ptr = this.workspace.getHostPointer().withOffset(prevOffset, numElements);
            if (this.isDebug.get()) {
                log.info("Workspace [{}]: Allocating array of {} bytes, capacity of {} elements, prevOffset: {}; currentOffset: {}; address: {}", new Object[]{this.id, requiredMemory, numElements, prevOffset, this.hostOffset.get(), ptr.address()});
            }
            if (initialize) {
                Pointer.memset((Pointer)ptr, (int)0, (long)requiredMemory);
            }
            return ptr;
        }
        if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED && this.currentSize.get() > 0L && !trimmer && Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.SPILL_EVERYTHING) {
            this.reset();
            this.resetPlanned.set(true);
            return this.alloc(requiredMemory, kind, type, initialize);
        }
        if (!trimmer) {
            this.spilledAllocationsSize.addAndGet(requiredMemory);
        } else {
            this.pinnedAllocationsSize.addAndGet(requiredMemory);
        }
        if (this.isDebug.get()) {
            log.info("Workspace [{}]: step: {}, spilled  {} bytes, capacity of {} elements", new Object[]{this.id, this.stepsCount.get(), requiredMemory, numElements});
        }
        switch (this.workspaceConfiguration.getPolicySpill()) {
            case REALLOCATE: 
            case EXTERNAL: {
                this.cycleAllocations.addAndGet(requiredMemory);
                if (!trimmer) {
                    this.externalCount.incrementAndGet();
                    PagedPointer pointer = new PagedPointer(this.memoryManager.allocate(requiredMemory, MemoryKind.HOST, initialize), numElements);
                    this.externalAllocations.add(new PointersPair(pointer, null));
                    return pointer;
                }
                this.pinnedCount.incrementAndGet();
                PagedPointer pointer = new PagedPointer(this.memoryManager.allocate(requiredMemory, MemoryKind.HOST, initialize), numElements);
                this.pinnedAllocations.add(new PointersPair(Long.valueOf(this.stepsCount.get()), Long.valueOf(requiredMemory), pointer, null));
                return pointer;
            }
        }
        throw new ND4JIllegalStateException("Can't allocate memory: Workspace is full");
    }

    public void free(Pointer pointer) {
    }

    public void initializeWorkspace() {
        if (!(this.currentSize.get() >= this.maxCycle.get() && this.currentSize.get() >= this.cycleAllocations.get() || this.workspaceConfiguration.getPolicySpill() != SpillPolicy.REALLOCATE || this.workspaceConfiguration.getMaxSize() != 0L && this.maxCycle.get() >= this.workspaceConfiguration.getMaxSize() || this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED)) {
            this.destroyWorkspace(true);
            this.isInit.set(false);
        }
        if (this.trimmedMode.get() && this.trimmedStep.get() + 2L < this.stepsCount.get()) {
            this.destroyWorkspace(false);
            this.isInit.set(false);
            this.isOver.set(false);
        }
        if (!this.isInit.get() && this.workspaceConfiguration.getPolicyLearning() != LearningPolicy.NONE) {
            if (this.workspaceConfiguration.getMaxSize() > 0L) {
                this.currentSize.set(Math.min(this.maxCycle.get(), this.workspaceConfiguration.getMaxSize()));
            } else {
                this.currentSize.set(this.maxCycle.get());
            }
            if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED) {
                this.currentSize.set((long)((double)this.currentSize.get() * 1.3));
                this.currentSize.addAndGet(8L - this.currentSize.get() % 8L);
                this.maxCycle.set(this.currentSize.get());
            }
            this.initialBlockSize.set(this.currentSize.get());
            if (!this.isOver.get() && this.workspaceConfiguration.getPolicyAllocation() == AllocationPolicy.OVERALLOCATE && this.workspaceConfiguration.getOverallocationLimit() > 0.0 && this.currentSize.get() > 0L) {
                this.currentSize.set(this.currentSize.get() + (long)((double)this.currentSize.get() * this.workspaceConfiguration.getOverallocationLimit()));
                this.isOver.set(true);
            }
            if (this.workspaceConfiguration.getMinSize() > 0L && this.currentSize.get() < this.workspaceConfiguration.getMinSize()) {
                this.currentSize.set(this.workspaceConfiguration.getMinSize());
            }
            if (this.externalCount.get() > 0 && (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.BLOCK_LEFT || this.resetPlanned.get())) {
                this.clearExternalAllocations();
                this.resetPlanned.set(false);
            }
            this.init();
        }
    }

    public int getNumberOfExternalAllocations() {
        return this.externalCount.get();
    }

    public int getNumberOfPinnedAllocations() {
        return this.pinnedCount.get();
    }

    public void destroyWorkspace() {
        this.destroyWorkspace(true);
    }

    public void destroyWorkspace(boolean extended) {
        if (this.workspace.getHostPointer() != null && this.workspace.getHostPointer().getOriginalPointer() != null && this.workspace.getHostPointer().getOriginalPointer() instanceof BytePointer) {
            this.workspace.getHostPointer().getOriginalPointer().deallocate();
        }
        this.workspace.setHostPointer(null);
        this.currentSize.set(0L);
        this.reset();
        if (extended) {
            this.clearExternalAllocations();
        }
    }

    public MemoryWorkspace notifyScopeBorrowed() {
        if (this.isBorrowed.get()) {
            throw new ND4JIllegalStateException("Workspace [" + this.id + "]: Can't borrow from borrowed workspace");
        }
        this.borrowingWorkspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        this.isBorrowed.set(true);
        Nd4j.getMemoryManager().setCurrentWorkspace(this);
        return this;
    }

    public long getCyclesCount() {
        return this.cyclesCount.get();
    }

    public void close() {
        long diff;
        if (this.isBorrowed.get()) {
            this.isBorrowed.set(false);
            Nd4j.getMemoryManager().setCurrentWorkspace(this.borrowingWorkspace);
            return;
        }
        if (this.tagScope.get() > 0) {
            if (this.tagScope.decrementAndGet() == 0) {
                Nd4j.getMemoryManager().setCurrentWorkspace(this);
            }
            return;
        }
        Nd4j.getExecutioner().commit();
        Nd4j.getMemoryManager().setCurrentWorkspace(this.previousWorkspace);
        this.isOpen.set(false);
        this.cyclesCount.incrementAndGet();
        if (this.cyclesCount.get() > 1L & (this.cyclesCount.get() - 1L) % (long)this.stepsNumber == 0L) {
            this.stepsCount.incrementAndGet();
        }
        if (!this.isUsed.get()) {
            log.warn("Workspace was turned off, and wasn't ever turned on back again");
            this.isUsed.set(true);
        }
        if (this.cycleAllocations.get() > this.maxCycle.get()) {
            if (this.isDebug.get()) {
                log.info("Workspace [{}] device_{}, current cycle: {}; max cycle: {}", new Object[]{this.id, Nd4j.getAffinityManager().getDeviceForCurrentThread(), this.cycleAllocations.get(), this.maxCycle.get()});
            }
            this.maxCycle.set(this.cycleAllocations.get());
        }
        if (this.workspaceConfiguration.getPolicyLearning() != LearningPolicy.NONE && this.maxCycle.get() > 0L) {
            if (this.externalCount.get() > 0 && (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.BLOCK_LEFT || this.resetPlanned.get())) {
                this.clearExternalAllocations();
                this.resetPlanned.set(false);
            }
            if (this.workspaceConfiguration.getPolicyLearning() == LearningPolicy.OVER_TIME && this.workspaceConfiguration.getCyclesBeforeInitialization() == this.cyclesCount.intValue() || this.workspaceConfiguration.getPolicyLearning() == LearningPolicy.FIRST_LOOP && this.currentSize.get() == 0L) {
                if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.SPILL_EVERYTHING) {
                    this.initializeWorkspace();
                }
            } else if (this.currentSize.get() > 0L && this.cycleAllocations.get() > 0L && this.workspaceConfiguration.getPolicySpill() == SpillPolicy.REALLOCATE && this.workspaceConfiguration.getPolicyReset() != ResetPolicy.ENDOFBUFFER_REACHED && Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.SPILL_EVERYTHING) {
                this.initializeWorkspace();
            }
        }
        if (this.pinnedCount.get() > 0) {
            this.clearPinnedAllocations(false);
        }
        if (this.trimmedMode.get() && this.trimmedStep.get() + 2L < this.stepsCount.get()) {
            this.initialBlockSize.set(this.maxCycle.get());
            this.initializeWorkspace();
            this.trimmedMode.set(false);
            this.trimmedStep.set(0L);
            this.reset();
        }
        this.lastCycleAllocations.set(this.cycleAllocations.get());
        this.disabledCounter.set(0L);
        if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.BLOCK_LEFT) {
            this.reset();
        } else if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.ENDOFBUFFER_REACHED && this.currentSize.get() > 0L && (diff = this.initialBlockSize.get() - this.cycleAllocations.get()) > 0L && !this.trimmedMode.get() && this.deviceOffset.get() > 0L) {
            if (this.isDebug.get()) {
                log.info("Worskpace [{}]: Align to [{}]; diff: [{}]; block size: [{}]; currentOffset: [{}]; workspaceSize: [{}]; trimmedMode: {}", new Object[]{this.id, this.initialBlockSize.get(), diff, this.cycleAllocations.get(), this.deviceOffset.get(), this.currentSize.get(), this.trimmedMode.get()});
            }
            this.deviceOffset.getAndAdd(diff);
            this.hostOffset.getAndAdd(diff);
        }
        this.cycleAllocations.set(0L);
    }

    protected abstract void clearPinnedAllocations(boolean var1);

    protected abstract void clearExternalAllocations();

    public MemoryWorkspace notifyScopeEntered() {
        MemoryWorkspace prev = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (prev == this && this.isOpen.get()) {
            this.tagScope.incrementAndGet();
            return this;
        }
        this.previousWorkspace = prev;
        Nd4j.getMemoryManager().setCurrentWorkspace(this);
        this.isOpen.set(true);
        if (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.BLOCK_LEFT) {
            this.reset();
        }
        if (this.externalCount.get() > 0 && (this.workspaceConfiguration.getPolicyReset() == ResetPolicy.BLOCK_LEFT || this.resetPlanned.get())) {
            this.clearExternalAllocations();
            this.resetPlanned.set(false);
        }
        this.cycleAllocations.set(0L);
        this.disabledCounter.set(0L);
        this.generationId.incrementAndGet();
        return this;
    }

    public void reset() {
        this.hostOffset.set(0L);
        this.deviceOffset.set(0L);
    }

    protected abstract void resetWorkspace();

    public MemoryWorkspace notifyScopeLeft() {
        this.close();
        return this;
    }

    public void toggleWorkspaceUse(boolean isEnabled) {
        this.isUsed.set(isEnabled);
    }

    public long getLastCycleAllocations() {
        return this.lastCycleAllocations.get();
    }

    public long getThisCycleAllocations() {
        return this.cycleAllocations.get();
    }

    public long getMaxCycleAllocations() {
        return this.maxCycle.get();
    }

    public boolean isScopeActive() {
        return this.isOpen.get();
    }

    public MemoryWorkspace tagOutOfScopeUse() {
        this.tagScope.incrementAndGet();
        return this;
    }

    public String toString() {
        return "Nd4jWorkspace{id='" + this.id + '\'' + ", currentSize=" + this.currentSize.get() + '}';
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public String getId() {
        return this.id;
    }

    public WorkspaceConfiguration getWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    public void setPreviousWorkspace(MemoryWorkspace previousWorkspace) {
        this.previousWorkspace = previousWorkspace;
    }

    public static class GarbageWorkspaceReference
    extends WeakReference<MemoryWorkspace> {
        private PointersPair pointersPair;
        private String id;
        private Long threadId;
        private Queue<PointersPair> pinnedPointers;
        private List<PointersPair> externalPointers;
        private String key;

        public GarbageWorkspaceReference(MemoryWorkspace referent, ReferenceQueue<? super MemoryWorkspace> queue) {
            super(referent, queue);
            this.pointersPair = ((Nd4jWorkspace)referent).workspace;
            this.id = referent.getId();
            this.threadId = referent.getThreadId();
            this.pinnedPointers = ((Nd4jWorkspace)referent).pinnedAllocations;
            this.externalPointers = ((Nd4jWorkspace)referent).externalAllocations;
            this.key = this.id + "_" + this.threadId;
        }

        public PointersPair getPointersPair() {
            return this.pointersPair;
        }

        public String getId() {
            return this.id;
        }

        public Long getThreadId() {
            return this.threadId;
        }

        public Queue<PointersPair> getPinnedPointers() {
            return this.pinnedPointers;
        }

        public List<PointersPair> getExternalPointers() {
            return this.externalPointers;
        }

        public String getKey() {
            return this.key;
        }

        public void setPointersPair(PointersPair pointersPair) {
            this.pointersPair = pointersPair;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setThreadId(Long threadId) {
            this.threadId = threadId;
        }

        public void setPinnedPointers(Queue<PointersPair> pinnedPointers) {
            this.pinnedPointers = pinnedPointers;
        }

        public void setExternalPointers(List<PointersPair> externalPointers) {
            this.externalPointers = externalPointers;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GarbageWorkspaceReference)) {
                return false;
            }
            GarbageWorkspaceReference other = (GarbageWorkspaceReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PointersPair this$pointersPair = this.getPointersPair();
            PointersPair other$pointersPair = other.getPointersPair();
            if (this$pointersPair == null ? other$pointersPair != null : !this$pointersPair.equals(other$pointersPair)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Long this$threadId = this.getThreadId();
            Long other$threadId = other.getThreadId();
            if (this$threadId == null ? other$threadId != null : !((Object)this$threadId).equals(other$threadId)) {
                return false;
            }
            Queue<PointersPair> this$pinnedPointers = this.getPinnedPointers();
            Queue<PointersPair> other$pinnedPointers = other.getPinnedPointers();
            if (this$pinnedPointers == null ? other$pinnedPointers != null : !this$pinnedPointers.equals(other$pinnedPointers)) {
                return false;
            }
            List<PointersPair> this$externalPointers = this.getExternalPointers();
            List<PointersPair> other$externalPointers = other.getExternalPointers();
            if (this$externalPointers == null ? other$externalPointers != null : !((Object)this$externalPointers).equals(other$externalPointers)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GarbageWorkspaceReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PointersPair $pointersPair = this.getPointersPair();
            result = result * 59 + ($pointersPair == null ? 43 : $pointersPair.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Long $threadId = this.getThreadId();
            result = result * 59 + ($threadId == null ? 43 : ((Object)$threadId).hashCode());
            Queue<PointersPair> $pinnedPointers = this.getPinnedPointers();
            result = result * 59 + ($pinnedPointers == null ? 43 : $pinnedPointers.hashCode());
            List<PointersPair> $externalPointers = this.getExternalPointers();
            result = result * 59 + ($externalPointers == null ? 43 : ((Object)$externalPointers).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "Nd4jWorkspace.GarbageWorkspaceReference(pointersPair=" + this.getPointersPair() + ", id=" + this.getId() + ", threadId=" + this.getThreadId() + ", pinnedPointers=" + this.getPinnedPointers() + ", externalPointers=" + this.getExternalPointers() + ", key=" + this.getKey() + ")";
        }
    }
}

