/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.options;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayType;

public class ArrayOptionsHelper {
    public static boolean hasBitSet(long[] shapeInfo, long bit) {
        long opt = Shape.options(shapeInfo);
        return ArrayOptionsHelper.hasBitSet(opt, bit);
    }

    public static void setOptionBit(long[] storage, ArrayType type) {
        int length = Shape.shapeInfoLength(storage);
        storage[length - 3] = ArrayOptionsHelper.setOptionBit(storage[length - 3], type);
    }

    public static boolean hasBitSet(long storage, long bit) {
        return (storage & bit) == bit;
    }

    public static ArrayType arrayType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        if (ArrayOptionsHelper.hasBitSet(opt, 2L)) {
            return ArrayType.SPARSE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return ArrayType.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 8L)) {
            return ArrayType.EMPTY;
        }
        return ArrayType.DENSE;
    }

    public static DataBuffer.Type dataType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return DataBuffer.Type.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4096L)) {
            return DataBuffer.Type.HALF;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 16384L)) {
            return DataBuffer.Type.FLOAT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 32768L)) {
            return DataBuffer.Type.DOUBLE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 262144L)) {
            return DataBuffer.Type.INT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 524288L)) {
            return DataBuffer.Type.LONG;
        }
        return DataBuffer.Type.UNKNOWN;
    }

    public static long setOptionBit(long storage, DataBuffer.Type type) {
        long bit = 0L;
        switch (type) {
            case HALF: {
                bit = 4096L;
                break;
            }
            case FLOAT: {
                bit = 16384L;
                break;
            }
            case DOUBLE: {
                bit = 32768L;
                break;
            }
            case INT: {
                bit = 262144L;
                break;
            }
            case LONG: {
                bit = 524288L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException();
            }
        }
        return storage |= bit;
    }

    public static long setOptionBit(long storage, ArrayType type) {
        long bit = 0L;
        switch (type) {
            case SPARSE: {
                bit = 2L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            case EMPTY: {
                bit = 8L;
                break;
            }
            default: {
                return storage;
            }
        }
        return storage |= bit;
    }
}

