/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomExponential
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(RandomExponential.class);
    private double lambda = 0.0;

    public RandomExponential() {
    }

    public RandomExponential(SameDiff sd, SDVariable shape, double lambda) {
        super(null, sd, new SDVariable[]{shape});
        Preconditions.checkState((lambda >= 0.0 ? 1 : 0) != 0, (String)"Lambda parameter must be > 0 - got %s", (double)lambda);
        this.lambda = lambda;
        this.addTArgument(lambda);
    }

    public RandomExponential(INDArray shape, INDArray out, double lambda) {
        super(null, new INDArray[]{shape}, new INDArray[]{out}, Collections.singletonList(lambda), (List<Integer>)null);
        this.lambda = lambda;
    }

    @Override
    public String opName() {
        return "random_exponential";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }
}

