/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class Min
extends BaseDynamicTransformOp {
    public Min() {
    }

    public Min(SameDiff sameDiff, @NonNull SDVariable first, @NonNull SDVariable second) {
        this(sameDiff, new SDVariable[]{first, second}, false);
        if (first == null) {
            throw new NullPointerException("first is marked @NonNull but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked @NonNull but is null");
        }
    }

    public Min(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, args, inPlace);
    }

    public Min(INDArray[] inputs, INDArray[] outputs) {
        super(inputs, outputs);
    }

    @Override
    public String opName() {
        return "minimum";
    }

    @Override
    public String onnxName() {
        return "Min";
    }

    @Override
    public String tensorflowName() {
        return "Minimum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable min = this.outputVariables()[0];
        SDVariable eq1 = this.sameDiff.eq(this.larg(), min);
        SDVariable eq2 = this.sameDiff.eq(this.rarg(), min);
        return Arrays.asList(eq1.mul(f1.get(0)), eq2.mul(f1.get(0)));
    }
}

