/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class ATan2
extends BaseDynamicTransformOp {
    public ATan2(SameDiff sameDiff, SDVariable y, SDVariable x) {
        super(sameDiff, new SDVariable[]{y, x}, false);
    }

    public ATan2() {
    }

    @Override
    public String opName() {
        return "tf_atan2";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Atan2";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable y = this.larg();
        SDVariable x = this.rarg();
        SDVariable xGrad = this.f().neg(y.div(x.pow(2.0).add(y.pow(2.0)))).mul(i_v.get(0));
        SDVariable yGrad = x.div(x.pow(2.0).add(y.pow(2.0))).mul(i_v.get(0));
        return Arrays.asList(yGrad, xGrad);
    }
}

