/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.tensorops;

import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.BaseTensorOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.list.compat.TensorList;

public class TensorArrayScatterV3
extends BaseTensorOp {
    public TensorArrayScatterV3(String name, SameDiff sameDiff, SDVariable[] args) {
        super(name, sameDiff, args);
    }

    public TensorArrayScatterV3(SameDiff sameDiff, SDVariable[] args) {
        super(null, sameDiff, args);
    }

    public TensorArrayScatterV3() {
    }

    @Override
    public String tensorflowName() {
        return "TensorArrayScatterV3";
    }

    @Override
    public TensorList execute(SameDiff sameDiff) {
        TensorList list = this.getList(sameDiff);
        INDArray indices = this.getArgumentArray(1);
        INDArray source = this.getArgumentArray(2);
        if (indices.length() == 1L && indices.getInt(0) == -1) {
            indices = Nd4j.create(ArrayUtil.toDouble((long[])ArrayUtil.range((long)0L, (long)source.shape()[0])), new long[]{source.shape()[0]});
        }
        int[] axis = ArrayUtil.range((int)1, (int)source.rank());
        int e = 0;
        while ((long)e < indices.length()) {
            int cIdx = indices.getInt(e++);
            INDArray array = source.tensorAlongDimension(cIdx, axis).dup(source.ordering());
            list.put(cIdx, array);
        }
        return list;
    }

    @Override
    public String toString() {
        return this.opName();
    }

    @Override
    public String opName() {
        return "tensorarrayscatterv3";
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
    }
}

