/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv2D.class);
    protected DeConv2DConfig config;

    public DeConv2D(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, DeConv2DConfig config) {
        super(null, inputArrays, outputs);
        this.sameDiff = sameDiff;
        this.config = config;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addArgs();
        sameDiff.putFunctionForId(this.getOwnName(), this);
        sameDiff.addArgsFor(inputs, (DifferentialFunction)this);
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).dataFormat((Long)this.iArguments.get(9) == 1L ? "NHWC" : "NCHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pH", "pW"}).build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("pH", paddingWidthHeight);
        map.put("pW", paddingWidthHeight);
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        DeConv2DConfig conv2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        int sH = 1;
        int sW = 1;
        int kH = 1;
        int kW = 1;
        AttrValue aPadding = nodeDef.getAttrOrDefault("padding", null);
        String paddingMode = aPadding.getS().toStringUtf8();
        SDVariable[] args = this.args();
        INDArray arr = this.sameDiff.getVariable(args[1].getVarName()).getArr();
        if (arr == null) {
            arr = TFGraphMapper.getInstance().getNDArrayFromTensor(nodeDef.getInput(0), nodeDef, graph);
            SDVariable varForOp = initWith.getVariable(args[1].getVarName());
            if (arr != null) {
                initWith.associateArrayWithVariable(arr, varForOp);
            }
        }
        String dataFormat = "nhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            dataFormat = attr.getS().toStringUtf8().toLowerCase();
        }
        if (dataFormat.equalsIgnoreCase("NCHW")) {
            sH = tfStrides.get(2).intValue();
            sW = tfStrides.get(3).intValue();
            kH = (int)arr.size(2);
            kW = (int)arr.size(3);
        } else {
            sH = tfStrides.get(1).intValue();
            sW = tfStrides.get(2).intValue();
            kH = (int)arr.size(0);
            kW = (int)arr.size(1);
        }
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        this.config = conv2DConfig = DeConv2DConfig.builder().kH(kH).kW(kW).sH(sW).sW(sH).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("NHWC") ? "NHWC" : "NCHW").build();
        this.addArgs();
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        DeConv2DConfig conv2DConfig;
        String autoPad = !attributesForNode.containsKey("auto_pad") ? "VALID" : attributesForNode.get("auto_pad").getS().toStringUtf8();
        OnnxProto3.AttributeProto dilations = attributesForNode.get("dilations");
        int dilationY = dilations == null ? 1 : dilations.getIntsList().get(0).intValue();
        int dilationX = dilations == null ? 1 : dilations.getIntsList().get(1).intValue();
        OnnxProto3.AttributeProto group = attributesForNode.get("group");
        OnnxProto3.AttributeProto kernelShape = attributesForNode.get("kernel_shape");
        int kH = kernelShape.getIntsList().get(0).intValue();
        int kW = kernelShape.getIntsList().size() < 2 ? kH : kernelShape.getIntsList().get(1).intValue();
        SDVariable vertexId = this.args()[0];
        INDArray arr = vertexId.getArr();
        arr = arr.permute(3, 2, 0, 1).dup('c');
        initWith.associateArrayWithVariable(arr, vertexId);
        String dataFormat = "nhwc";
        OnnxProto3.AttributeProto strides = attributesForNode.get("strides");
        Long sH = strides.getIntsList().get(0);
        Long sW = strides.getIntsList().size() < 2 ? sH : strides.getIntsList().get(1);
        boolean isSameMode = autoPad.equalsIgnoreCase("SAME");
        this.config = conv2DConfig = DeConv2DConfig.builder().kH(kH).kW(kW).sH(sH.intValue()).sW(sW.intValue()).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("nhwc") ? "NHWC" : "NCHW").build();
        this.addArgs();
        this.addOutputArgument(arr);
    }

    @Override
    public String opName() {
        return "deconv2d";
    }

    @Override
    public String onnxName() {
        return "ConvTranspose";
    }

    @Override
    public String tensorflowName() {
        return "Conv2DTranspose";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.addAll(f1);
        DeConv2DDerivative deConv2DDerivative = DeConv2DDerivative.derivativeBuilder().sameDiff(this.sameDiff).config(this.config).inputs(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(deConv2DDerivative.outputVariables()));
        return ret;
    }

    public static DeConv2DBuilder builder() {
        return new DeConv2DBuilder();
    }

    public DeConv2DConfig getConfig() {
        return this.config;
    }

    public DeConv2D() {
    }

    public static class DeConv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private DeConv2DConfig config;

        DeConv2DBuilder() {
        }

        public DeConv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public DeConv2DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public DeConv2DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public DeConv2DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public DeConv2DBuilder config(DeConv2DConfig config) {
            this.config = config;
            return this;
        }

        public DeConv2D build() {
            return new DeConv2D(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.config);
        }

        public String toString() {
            return "DeConv2D.DeConv2DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", config=" + this.config + ")";
        }
    }
}

